/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IndirectDependenceAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.AbstractAnalysis;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyAnalysis<T1, C1, E1, KT, VE, E2, C2, T2, KE, VT>
extends AbstractAnalysis
implements IDependencyAnalysis<T1, C1, E1, E2, C2, T2> {
    public static final Collection<Comparable<?>> IDENTIFIERS = new HashSet();
    protected final Map<KE, VT> dependee2dependent = new HashMap<KE, VT>(Constants.getNumOfMethodsInApplication());
    protected final Map<KT, VE> dependent2dependee = new HashMap<KT, VE>(Constants.getNumOfMethodsInApplication());
    private Pair.PairManager pairMgr;
    private final IDependencyAnalysis.Direction theDirection;

    static {
        IDENTIFIERS.add((Comparable<?>)((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA));
        IDENTIFIERS.add((Comparable<?>)((Object)IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA));
        IDENTIFIERS.add((Comparable<?>)((Object)IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA));
        IDENTIFIERS.add((Comparable<?>)((Object)IDependencyAnalysis.DependenceSort.SYNCHRONIZATION_DA));
        IDENTIFIERS.add((Comparable<?>)((Object)IDependencyAnalysis.DependenceSort.DIVERGENCE_DA));
        IDENTIFIERS.add((Comparable<?>)((Object)IDependencyAnalysis.DependenceSort.INTERFERENCE_DA));
        IDENTIFIERS.add((Comparable<?>)((Object)IDependencyAnalysis.DependenceSort.READY_DA));
    }

    public AbstractDependencyAnalysis(IDependencyAnalysis.Direction direction) {
        this.theDirection = direction;
    }

    @Override
    public final IDependencyAnalysis.Direction getDirection() {
        return this.theDirection;
    }

    @Override
    public IDependencyAnalysis<T1, C1, E1, E2, C2, T2> getIndirectVersionOfDependence() {
        return new IndirectDependenceAnalysis(this, this.getDependenceRetriever());
    }

    @Override
    public void reset() {
        this.dependent2dependee.clear();
        this.dependee2dependent.clear();
        super.reset();
    }

    protected abstract IDependenceRetriever<T1, C1, E1, E2, C2, T2> getDependenceRetriever();

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.pairMgr = (Pair.PairManager)this.info.get(Pair.PairManager.ID);
        if (this.pairMgr == null) {
            throw new InitializationException(Pair.PairManager.ID + " was not provided in the info.");
        }
    }

    Object getKeyFor(Object entity, Object method) {
        return this.pairMgr.getPair(entity, method);
    }
}

