/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.ListUtils;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.StmtRetriever;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractControlDA
extends AbstractDependencyAnalysis<Stmt, SootMethod, Stmt, SootMethod, List<Collection<Stmt>>, Stmt, SootMethod, Stmt, SootMethod, List<Collection<Stmt>>> {
    protected ICallGraphInfo callgraph;
    private final TObjectIntHashMap node2fanout = new TObjectIntHashMap();

    public AbstractControlDA(IDependencyAnalysis.Direction direction) {
        super(direction);
    }

    @Override
    public final Collection<Stmt> getDependees(Stmt dependentStmt, SootMethod method) {
        List _list = (List)this.dependent2dependee.get(method);
        return this.getDependenceHelper(dependentStmt, method, _list);
    }

    @Override
    public final Collection<Stmt> getDependents(Stmt dependeeStmt, SootMethod method) {
        List _list = (List)this.dependee2dependent.get(method);
        return this.getDependenceHelper(dependeeStmt, method, _list);
    }

    @Override
    public final Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.CONTROL_DA);
    }

    public final String toString() {
        StringBuffer _result = new StringBuffer("Statistics for control dependence as calculated by " + this.getClass().getName() + "\n");
        int _edgeCount = 0;
        int _entryPointDep = 0;
        StringBuffer _temp = new StringBuffer();
        for (Map.Entry _entry : this.dependent2dependee.entrySet()) {
            SootMethod _method = (SootMethod)_entry.getKey();
            List<Stmt> _stmts = this.getStmtList(_method);
            List _cd = (List)_entry.getValue();
            int _localEdgeCount = 0;
            int _localEntryPointDep = _stmts.size();
            int _j = 0;
            while (_j < _stmts.size()) {
                Collection _dees;
                if (_cd != null && !_cd.isEmpty() && (_dees = (Collection)_cd.get(_j)) != null) {
                    _temp.append("\t\t" + _stmts.get(_j) + " --> " + _dees + "\n");
                    _localEdgeCount += _dees.size();
                    --_localEntryPointDep;
                }
                ++_j;
            }
            _result.append("\tFor " + _entry.getKey() + " there are " + _localEdgeCount + " control dependence edges with " + _localEntryPointDep + " entry point dependences.\n");
            _result.append(_temp);
            _temp.delete(0, _temp.length());
            _edgeCount += _localEdgeCount;
            _entryPointDep += _localEntryPointDep;
        }
        _result.append("A total of " + _edgeCount + " control dependence edges exists with " + _entryPointDep + " entry point dependences.");
        return _result.toString();
    }

    @Override
    protected IDependenceRetriever<Stmt, SootMethod, Stmt, Stmt, SootMethod, Stmt> getDependenceRetriever() {
        return new StmtRetriever();
    }

    protected final int getFanoutNumOf(BasicBlockGraph.BasicBlock basicblock) {
        if (!this.node2fanout.containsKey((Object)basicblock)) {
            int _fanout = basicblock.getSuccsOf().size();
            if (_fanout > 0 && basicblock.isAnExitBlock()) {
                ++_fanout;
            }
            this.node2fanout.put((Object)basicblock, _fanout);
        }
        return this.node2fanout.get((Object)basicblock);
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.callgraph == null) {
            throw new InitializationException(ICallGraphInfo.ID + " was not provided.");
        }
    }

    private Collection<Stmt> getDependenceHelper(Object stmt, Object method, List<Collection<Stmt>> list) {
        int _index;
        Collection _result = Collections.emptyList();
        if (list != null && (_index = this.getStmtList((SootMethod)method).indexOf(stmt)) > -1) {
            List _l = Collections.emptyList();
            _result = (Collection)ListUtils.getAtIndexFromList(list, (int)_index, _l);
        }
        return _result;
    }
}

