/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.independence;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.soot.SootPredicatesAndTransformers;
import edu.ksu.cis.indus.interfaces.IConcurrentIndependenceInfo;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import soot.SootClass;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndependentStmtDetector
extends AbstractProcessor
implements IConcurrentIndependenceInfo {
    protected IEscapeInfo escapeInfo;
    protected final Collection<Stmt> independentStmts = new ArrayList<Stmt>();
    private final Collection<String> independentClassNames = new ArrayList<String>();
    private boolean independentScope;

    public IndependentStmtDetector() {
        this.independentClassNames.add("java.lang.String");
        this.independentClassNames.add("java.lang.Integer");
        this.independentClassNames.add("java.lang.Float");
        this.independentClassNames.add("java.lang.Double");
        this.independentClassNames.add("java.lang.Boolean");
        this.independentClassNames.add("java.lang.Byte");
        this.independentClassNames.add("java.lang.Long");
        this.independentClassNames.add("java.lang.Short");
        this.independentClassNames.add("java.lang.Character");
        this.independentClassNames.add("java.lang.StringBuffer");
    }

    public final void callback(SootClass clazz) {
        super.callback(clazz);
        this.independentScope = this.independentClassNames.contains(clazz.getName());
    }

    public final void callback(Stmt stmt, Context context) {
        if (this.independentScope || !stmt.containsArrayRef() && !stmt.containsFieldRef() && !stmt.containsInvokeExpr() && !(stmt instanceof EnterMonitorStmt) || this.isIndependent(stmt, context.getCurrentMethod())) {
            this.independentStmts.add(stmt);
        }
    }

    public final Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(ID);
    }

    public final void hookup(ProcessingController ppc) {
        ppc.register((IProcessor)this);
        ppc.registerForAllStmts((IProcessor)this);
    }

    public final boolean isIndependent(Stmt stmt) {
        return this.independentStmts.contains(stmt);
    }

    public final void reset() {
        super.reset();
        this.independentStmts.clear();
    }

    public Collection<String> setAtomicClassNames(Collection<String> names) {
        ArrayList<String> _result = new ArrayList<String>(this.independentClassNames);
        this.independentClassNames.clear();
        this.independentClassNames.addAll(names);
        return _result;
    }

    public final void setEscapeAnalysis(IEscapeInfo analysis) {
        this.escapeInfo = analysis;
    }

    public final String toString() {
        return CollectionUtils.prettyPrint(this.independentStmts);
    }

    public final void unhook(ProcessingController ppc) {
        ppc.unregister((IProcessor)this);
        ppc.unregisterForAllStmts((IProcessor)this);
    }

    protected boolean isIndependent(Stmt stmt, SootMethod method) {
        boolean independent;
        boolean bl = independent = !stmt.containsInvokeExpr();
        if (independent && stmt.containsFieldRef() && stmt.getFieldRef().getField().isStatic()) {
            independent = this.escapeInfo.escapes(stmt.getFieldRef().getField().getDeclaringClass(), method);
        }
        Iterator _i = IteratorUtils.filteredIterator(stmt.getUseAndDefBoxes().iterator(), (IPredicate)SootPredicatesAndTransformers.ESCAPABLE_EXPR_FILTER);
        while (_i.hasNext() && independent) {
            ValueBox _vb = (ValueBox)_i.next();
            boolean bl2 = independent = !this.escapeInfo.escapes(_vb.getValue(), method);
        }
        return independent;
    }
}

