/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.independence;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.concurrency.independence.IndependentStmtDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndependentRegionDetector
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndependentRegionDetector.class);
    private final Map<BasicBlockGraph.BasicBlock, Collection<Stmt>> bb2beginsAfterCache = new HashMap<BasicBlockGraph.BasicBlock, Collection<Stmt>>();
    private final Map<BasicBlockGraph.BasicBlock, Collection<Stmt>> bb2beginsBeforeCache = new HashMap<BasicBlockGraph.BasicBlock, Collection<Stmt>>();
    private final Map<BasicBlockGraph.BasicBlock, Collection<Stmt>> bb2endsAfterCache = new HashMap<BasicBlockGraph.BasicBlock, Collection<Stmt>>();
    private final Map<BasicBlockGraph.BasicBlock, Collection<Stmt>> bb2endsBeforeCache = new HashMap<BasicBlockGraph.BasicBlock, Collection<Stmt>>();
    private BasicBlockGraphMgr bbgMgr;
    private IndependentStmtDetector independenceDetector;
    private final Collection<BasicBlockGraph.BasicBlock> independentBeginsBBCache = new ArrayList<BasicBlockGraph.BasicBlock>();
    private final Collection<BasicBlockGraph.BasicBlock> independentEndsBBCache = new ArrayList<BasicBlockGraph.BasicBlock>();
    private Map<SootMethod, Collection<Stmt>> method2beginsAfter = new HashMap<SootMethod, Collection<Stmt>>();
    private Map<SootMethod, Collection<Stmt>> method2beginsBefore = new HashMap<SootMethod, Collection<Stmt>>();
    private Map<SootMethod, Collection<Stmt>> method2endsAfter = new HashMap<SootMethod, Collection<Stmt>>();
    private Map<SootMethod, Collection<Stmt>> method2endsBefore = new HashMap<SootMethod, Collection<Stmt>>();

    public void callback(SootMethod method) {
        super.callback(method);
        if (this.bbgMgr == null) {
            LOGGER.error("callback(SootMethod) - Please call setBasicBlockGraphMgr() before executing this processor.");
            throw new IllegalStateException("Please call setBasicBlockGraphMgr() before executing this processor.");
        }
        BasicBlockGraph _bbg = this.bbgMgr.getBasicBlockGraph(method);
        List _nodes = _bbg.getNodes();
        Iterator _i = _nodes.iterator();
        int _iEnd = _nodes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Collection<Stmt> _collection;
            Stmt _trailerStmt;
            int _indexOfAtomicEnd;
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_i.next();
            List _stmtsOf = _bb.getStmtsOf();
            boolean _independent = false;
            Stmt _independentBegin = null;
            Iterator _j = _stmtsOf.iterator();
            int _jEnd = _stmtsOf.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Stmt _stmt = (Stmt)_j.next();
                if (this.independenceDetector.isIndependent(_stmt) && !_independent) {
                    _independent = true;
                    _independentBegin = _stmt;
                } else if (!this.independenceDetector.isIndependent(_stmt) && _independent) {
                    int _indexOfAtomicEnd2 = _stmtsOf.indexOf(_stmt);
                    if (_indexOfAtomicEnd2 - _stmtsOf.indexOf(_independentBegin) >= 1) {
                        MapUtils.putIntoListInMap(this.bb2beginsBeforeCache, (Object)_bb, (Object)_independentBegin);
                        MapUtils.putIntoListInMap(this.bb2endsAfterCache, (Object)_bb, (Object)((Stmt)_stmtsOf.get(_indexOfAtomicEnd2 - 1)));
                    }
                    _independent = false;
                }
                ++_jIndex;
            }
            if (_independent && (_indexOfAtomicEnd = _stmtsOf.indexOf(_trailerStmt = _bb.getTrailerStmt())) - _stmtsOf.indexOf(_independentBegin) >= 0) {
                MapUtils.putIntoListInMap(this.bb2beginsBeforeCache, (Object)_bb, (Object)_independentBegin);
                MapUtils.putIntoListInMap(this.bb2endsAfterCache, (Object)_bb, (Object)_trailerStmt);
                this.independentEndsBBCache.add(_bb);
            }
            if ((_collection = this.bb2beginsBeforeCache.get(_bb)) != null && _collection.contains(_bb.getLeaderStmt())) {
                this.independentBeginsBBCache.add(_bb);
            }
            ++_iIndex;
        }
        this.calculateMultiBBRegions(_nodes);
        this.recordBeginsAndEndsFor(method);
        this.bb2beginsBeforeCache.clear();
        this.bb2beginsAfterCache.clear();
        this.bb2endsBeforeCache.clear();
        this.bb2endsAfterCache.clear();
        this.independentBeginsBBCache.clear();
        this.independentEndsBBCache.clear();
    }

    public Collection<Stmt> getAtomicRegionBeginAfterBoundariesFor(SootMethod method) {
        return MapUtils.queryCollection(this.method2beginsAfter, (Object)method);
    }

    public Collection<Stmt> getAtomicRegionBeginBeforeBoundariesFor(SootMethod method) {
        return MapUtils.queryCollection(this.method2beginsBefore, (Object)method);
    }

    public Collection<Stmt> getAtomicRegionEndAfterBoundariesFor(SootMethod method) {
        return MapUtils.queryCollection(this.method2endsAfter, (Object)method);
    }

    public Collection<Stmt> getAtomicRegionEndBeforeBoundariesFor(SootMethod method) {
        return MapUtils.queryCollection(this.method2endsBefore, (Object)method);
    }

    public void hookup(ProcessingController ppc) {
        ppc.register((IProcessor)this);
    }

    public void reset() {
        super.reset();
        this.method2beginsBefore.clear();
        this.method2beginsAfter.clear();
        this.method2endsAfter.clear();
    }

    public void setAtomicityDetector(IndependentStmtDetector detector) {
        this.independenceDetector = detector;
    }

    public void setBasicBlockGraphMgr(BasicBlockGraphMgr manager) {
        this.bbgMgr = manager;
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister((IProcessor)this);
    }

    private void calculateMultiBBRegions(Collection<BasicBlockGraph.BasicBlock> basicblocks) {
        LIFOWorkBag _beginsAfterTrailer = new LIFOWorkBag();
        LIFOWorkBag _endsBeforeLeader = new LIFOWorkBag();
        Iterator<BasicBlockGraph.BasicBlock> _i1 = this.independentEndsBBCache.iterator();
        int _i1End = this.independentEndsBBCache.size();
        int _i1Index = 0;
        while (_i1Index < _i1End) {
            BasicBlockGraph.BasicBlock _bb = _i1.next();
            Collection _succsOf = _bb.getSuccsOf();
            if (CollectionUtils.containsAny(this.independentBeginsBBCache, (Collection)_succsOf)) {
                this.bb2endsAfterCache.get(_bb).remove(_bb.getTrailerStmt());
                _endsBeforeLeader.addAllWorkNoDuplicates((Collection)SetUtils.difference((Collection)_succsOf, this.independentBeginsBBCache));
            } else {
                _i1.remove();
            }
            ++_i1Index;
        }
        Iterator<BasicBlockGraph.BasicBlock> _i2 = this.independentBeginsBBCache.iterator();
        int _i2End = this.independentBeginsBBCache.size();
        int _i2Index = 0;
        while (_i2Index < _i2End) {
            BasicBlockGraph.BasicBlock _bb = _i2.next();
            Collection _predsOf = _bb.getPredsOf();
            if (CollectionUtils.containsAny(this.independentEndsBBCache, (Collection)_predsOf)) {
                this.bb2beginsBeforeCache.get(_bb).remove(_bb.getLeaderStmt());
                _beginsAfterTrailer.addAllWorkNoDuplicates((Collection)SetUtils.difference((Collection)_predsOf, this.independentEndsBBCache));
            } else {
                _i2.remove();
            }
            ++_i2Index;
        }
        ArrayList<BasicBlockGraph.BasicBlock> _nonAtomicBegins = new ArrayList<BasicBlockGraph.BasicBlock>(basicblocks);
        ArrayList<BasicBlockGraph.BasicBlock> _nonAtomicEnds = new ArrayList<BasicBlockGraph.BasicBlock>(basicblocks);
        _nonAtomicBegins.removeAll(this.independentBeginsBBCache);
        _nonAtomicEnds.removeAll(this.independentEndsBBCache);
        while (true) {
            BasicBlockGraph.BasicBlock _bb;
            if (_beginsAfterTrailer.hasWork()) {
                _bb = (BasicBlockGraph.BasicBlock)_beginsAfterTrailer.getWork();
                MapUtils.putIntoListInMap(this.bb2beginsAfterCache, (Object)_bb, (Object)_bb.getTrailerStmt());
                _nonAtomicEnds.remove(_bb);
                _endsBeforeLeader.addAllWorkNoDuplicates((Collection)SetUtils.intersection(_nonAtomicBegins, (Collection)_bb.getSuccsOf()));
                continue;
            }
            while (_endsBeforeLeader.hasWork()) {
                _bb = (BasicBlockGraph.BasicBlock)_endsBeforeLeader.getWork();
                MapUtils.putIntoListInMap(this.bb2endsBeforeCache, (Object)_bb, (Object)_bb.getLeaderStmt());
                _nonAtomicBegins.remove(_bb);
                _beginsAfterTrailer.addAllWorkNoDuplicates((Collection)SetUtils.intersection(_nonAtomicEnds, (Collection)_bb.getPredsOf()));
            }
            if (!_beginsAfterTrailer.hasWork() && !_endsBeforeLeader.hasWork()) break;
        }
    }

    private <T> Collection<T> collectValues(Map<BasicBlockGraph.BasicBlock, Collection<T>> key2collection) {
        ArrayList<T> _result = new ArrayList<T>();
        for (Collection<T> _t : key2collection.values()) {
            _result.addAll(_t);
        }
        return _result;
    }

    private void recordBeginsAndEndsFor(SootMethod method) {
        this.method2beginsBefore.put(method, this.collectValues(this.bb2beginsBeforeCache));
        this.method2beginsAfter.put(method, this.collectValues(this.bb2beginsAfterCache));
        this.method2endsBefore.put(method, this.collectValues(this.bb2endsBeforeCache));
        this.method2endsAfter.put(method, this.collectValues(this.bb2endsAfterCache));
    }
}

