/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.independence;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.independence.IndependentRegionDetector;
import edu.ksu.cis.indus.staticanalyses.concurrency.independence.IndependentStmtDetector;
import edu.ksu.cis.indus.staticanalyses.concurrency.independence.IndependentStmtDetectorv2;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.PatchingChain;
import soot.SootMethod;
import soot.Value;
import soot.jimple.Stmt;
import soot.tagkit.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndependenceDetectionCLI
extends SootBasedDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndependenceDetectionCLI.class);
    private final IndependentStmtDetector detector;
    private String outputDir;

    public IndependenceDetectionCLI(IndependentStmtDetector arg) {
        this.detector = arg;
    }

    public static void main(String[] args) {
        Options _options = new Options();
        Option _option = new Option("o", "output", true, "Directory into which jimple files will be written into. [required]");
        _option.setArgs(1);
        _option.setArgName("ouput-directory");
        _option.setRequired(true);
        _options.addOption(_option);
        _option = new Option("h", "help", false, "Display message.");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("p", "soot-classpath", false, "Prepend this to soot class path.");
        _option.setArgs(1);
        _option.setArgName("classpath");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("useV2", false, "Use version 2 of the atomicity detection algorithm.");
        _options.addOption(_option);
        _option = new Option("scheme", false, "Scheme to indicate atomicity. Valid values are 'tag-stmt' and 'tag-region'.  By default, 'tag-stmt' scheme is used. ");
        _option.setArgs(1);
        _option.setArgName("scheme-name");
        _options.addOption(_option);
        _option = new Option("S", "scope", true, "The scope that should be analyzed.");
        _option.setArgs(1);
        _option.setArgName("scope");
        _option.setRequired(false);
        _options.addOption(_option);
        GnuParser _parser = new GnuParser();
        try {
            CommandLine _cl = _parser.parse(_options, args);
            if (_cl.hasOption("h")) {
                String _cmdLineSyn = "java " + IndependenceDetectionCLI.class.getName() + " <options> <classnames>";
                new HelpFormatter().printHelp(_cmdLineSyn, _options);
                System.exit(1);
            }
            if (_cl.getArgList().isEmpty()) {
                throw new MissingArgumentException("Please specify atleast one class.");
            }
            IndependenceDetectionCLI _cli = _cl.hasOption("useV2") ? new IndependenceDetectionCLI(new IndependentStmtDetectorv2()) : new IndependenceDetectionCLI(new IndependentStmtDetector());
            if (_cl.hasOption('p')) {
                _cli.addToSootClassPath(_cl.getOptionValue('p'));
            }
            if (_cl.hasOption('S')) {
                _cli.setScopeSpecFile(_cl.getOptionValue('S'));
            }
            _cli.setClassNames(_cl.getArgList());
            _cli.setOutputDir(_cl.getOptionValue('o'));
            _cli.execute(_cl);
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            System.out.println("Error while parsing command line." + (Object)((Object)_e));
            String _cmdLineSyn = "java " + IndependenceDetectionCLI.class.getName() + " <options> <classnames>";
            new HelpFormatter().printHelp(_cmdLineSyn, "Options are:", _options, "");
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    private void setOutputDir(String arg) {
        this.outputDir = arg;
    }

    private void annotateAtomicStmts(ICallGraphInfo cgi) {
        NamedTag _atomicTag = new NamedTag("AtomicTag");
        for (SootMethod _sm : cgi.getReachableMethods()) {
            if (!_sm.isConcrete()) continue;
            Body _body = this.getBbm().getStmtGraph(_sm).getBody();
            PatchingChain _sl = _body.getUnits();
            Iterator _j = _sl.iterator();
            int _jEnd = _sl.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Stmt _stmt = (Stmt)_j.next();
                if (this.detector.isIndependent(_stmt)) {
                    _stmt.addTag((Tag)_atomicTag);
                }
                ++_jIndex;
            }
        }
    }

    private <T extends ITokens<T, Value>> void execute(CommandLine cl) {
        this.setInfoLogger(LOGGER);
        IValueAnalyzer _aa = OFAnalyzer.getFSOSAnalyzer("AtomicityDetection:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList<IProcessor> _processors = new ArrayList<IProcessor>();
        Pair.PairManager _pairManager = new Pair.PairManager(false, true);
        CallGraphInfo _cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        ThreadGraph _tgi = new ThreadGraph(_cgi, new CFGAnalysis(_cgi, this.getBbm()), _pairManager);
        ValueAnalyzerBasedProcessingController _cgipc = new ValueAnalyzerBasedProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(_aa);
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("AtomicityDetection:FA"));
        _cgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _cgipc.setAnalyzer(_aa);
        _cgipc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(_cgi));
        HashMap _info = new HashMap();
        _info.put(ICallGraphInfo.ID, (Object)((Object)_cgi));
        _info.put(IThreadGraphInfo.ID, _tgi);
        _info.put(Pair.PairManager.ID, _pairManager);
        _info.put(IEnvironment.ID, _aa.getEnvironment());
        _info.put(IValueAnalyzer.ID, _aa);
        EquivalenceClassBasedEscapeAnalysis _ecba = new EquivalenceClassBasedEscapeAnalysis(_cgi, null, this.getBbm());
        IEscapeInfo _escapeInfo = _ecba.getEscapeInfo();
        _info.put(IEscapeInfo.ID, _escapeInfo);
        this.initialize();
        _aa.analyze(this.getEnvironment(), this.getRootMethods());
        _callGraphInfoCollector.reset();
        _processors.clear();
        _processors.add(_callGraphInfoCollector);
        _pc.reset();
        _pc.driveProcessors(_processors);
        _cgi.reset();
        _cgi.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
        this.writeInfo("CALL GRAPH:\n" + _cgi.toString());
        _processors.clear();
        _tgi.reset();
        _processors.add(_tgi);
        _cgipc.reset();
        _cgipc.driveProcessors(_processors);
        this.writeInfo("THREAD GRAPH:\n" + _tgi.toString());
        AnalysesController _ac = new AnalysesController(_info, _cgipc, this.getBbm());
        _ac.addAnalyses(EquivalenceClassBasedEscapeAnalysis.ID, (Collection<? extends IAnalysis>)Collections.singleton(_ecba));
        _ac.initialize();
        _ac.execute();
        this.writeInfo("END: Escape analysis");
        this.detector.setEscapeAnalysis(_escapeInfo);
        this.detector.hookup(_cgipc);
        _cgipc.process();
        this.detector.unhook(_cgipc);
        this.writeInfo("BEGIN: Independent statement detection");
        String _optionValue = cl.getOptionValue("scheme", "tag-stmt");
        if (_optionValue.equals("tag-region")) {
            IndependentRegionDetector _regionDetector = new IndependentRegionDetector();
            _regionDetector.setAtomicityDetector(this.detector);
            _regionDetector.setBasicBlockGraphMgr(this.getBbm());
            _regionDetector.hookup(_cgipc);
            _cgipc.process();
            _regionDetector.unhook(_cgipc);
            this.insertAtomicBoundaries(_regionDetector, _cgi);
        } else {
            this.annotateAtomicStmts(_cgi);
        }
        this.writeInfo("END: Independent region detection");
        this.dumpJimpleAndClassFiles(this.outputDir, true, false);
    }

    private void insertAtomicBoundaries(IndependentRegionDetector regionDetector, ICallGraphInfo cgi) {
        NamedTag _atomicBeginBeforeTag = new NamedTag("Atomic-Begin-Before-Tag");
        NamedTag _atomicBeginAfterTag = new NamedTag("Atomic-Begin-After-Tag");
        NamedTag _atomicEndBeforeTag = new NamedTag("Atomic-End-Before-Tag");
        NamedTag _atomicEndAfterTag = new NamedTag("Atomic-End-After-Tag");
        for (SootMethod _sm : cgi.getReachableMethods()) {
            for (Stmt _stmt : regionDetector.getAtomicRegionBeginBeforeBoundariesFor(_sm)) {
                _stmt.addTag((Tag)_atomicBeginBeforeTag);
            }
            for (Stmt _stmt : regionDetector.getAtomicRegionBeginAfterBoundariesFor(_sm)) {
                _stmt.addTag((Tag)_atomicBeginAfterTag);
            }
            for (Stmt _stmt : regionDetector.getAtomicRegionEndBeforeBoundariesFor(_sm)) {
                _stmt.addTag((Tag)_atomicEndBeforeTag);
            }
            for (Stmt _stmt : regionDetector.getAtomicRegionEndAfterBoundariesFor(_sm)) {
                _stmt.addTag((Tag)_atomicEndAfterTag);
            }
        }
    }
}

