/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.MethodContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.CastExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.VirtualInvokeExpr;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValueProcessor
extends AbstractJimpleValueSwitch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueProcessor.class);
    private final EquivalenceClassBasedEscapeAnalysis ecba;
    private boolean markLocals = true;
    private boolean rhs = true;
    private final Map<StringConstant, AliasSet> stringConstant2aliasSet = new HashMap<StringConstant, AliasSet>();

    ValueProcessor(EquivalenceClassBasedEscapeAnalysis analysis) {
        this.ecba = analysis;
    }

    public void caseArrayRef(ArrayRef v) {
        boolean _temp = this.rhs;
        this.rhs = true;
        this.process(v.getBase());
        this.rhs = _temp;
        AliasSet _base = (AliasSet)this.getResult();
        AliasSet _elt = this.processField(v.getType(), _base, "$ELT");
        this.setResult(_elt);
    }

    public void caseCastExpr(CastExpr v) {
        this.process(v.getOp());
    }

    public void caseInstanceFieldRef(InstanceFieldRef v) {
        boolean _temp = this.rhs;
        this.rhs = true;
        this.process(v.getBase());
        this.rhs = _temp;
        AliasSet _base = (AliasSet)this.getResult();
        String _fieldSig = v.getField().getSignature();
        AliasSet _field = this.processField(v.getType(), _base, _fieldSig);
        this.setResult(_field);
    }

    public void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
        this.processInvokeExpr((InvokeExpr)v);
    }

    public void caseLocal(Local v) {
        AliasSet _s = this.ecba.localASsCache.get(v);
        if (_s == null && (_s = AliasSet.getASForType(v.getType())) != null) {
            this.ecba.localASsCache.put(v, _s);
        }
        if (_s != null && this.markLocals) {
            this.recordAccessInfo(_s);
        }
        this.setResult(_s);
    }

    public void caseParameterRef(ParameterRef v) {
        AliasSet _as = this.ecba.methodCtxtCache.getParamAS(v.getIndex());
        this.setResult(_as);
    }

    public void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
        this.processInvokeExpr((InvokeExpr)v);
    }

    public void caseStaticFieldRef(StaticFieldRef v) {
        SootField _field = v.getField();
        AliasSet _base = this.ecba.getASForClass(_field.getDeclaringClass());
        AliasSet _fieldAS = this.processField(v.getType(), _base, _field.getSignature());
        this.setResult(_fieldAS);
    }

    public void caseStaticInvokeExpr(StaticInvokeExpr v) {
        this.processInvokeExpr((InvokeExpr)v);
    }

    public void caseThisRef(ThisRef v) {
        AliasSet _as = this.ecba.methodCtxtCache.getThisAS();
        this.setResult(_as);
    }

    public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
        this.processInvokeExpr((InvokeExpr)v);
    }

    public void defaultCase(Object o) {
        if (o instanceof StringConstant) {
            StringConstant _stringConstant = (StringConstant)o;
            AliasSet _r = this.stringConstant2aliasSet.get(_stringConstant);
            if (_r == null) {
                _r = AliasSet.createAliasSet();
                this.stringConstant2aliasSet.put(_stringConstant, _r);
            }
            this.setResult(_r);
        } else {
            this.setResult(null);
        }
    }

    void process(Value value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing value: " + value);
        }
        value.apply((Switch)this);
    }

    void reset() {
        this.stringConstant2aliasSet.clear();
    }

    boolean setMarkLocals(boolean value) {
        boolean _result = this.markLocals;
        this.markLocals = value;
        return _result;
    }

    boolean setRHS(boolean b) {
        boolean _r = this.rhs;
        this.rhs = b;
        return _r;
    }

    private List<AliasSet> processArguments(InvokeExpr v) {
        List<AliasSet> _argASs;
        int _paramCount = v.getMethod().getParameterCount();
        if (_paramCount == 0) {
            _argASs = Collections.emptyList();
        } else {
            _argASs = new ArrayList();
            int _i = 0;
            while (_i < _paramCount) {
                Value _val = v.getArg(_i);
                AliasSet _temp = null;
                if (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(_val.getType())) {
                    this.process(v.getArg(_i));
                    _temp = (AliasSet)this.ecba.valueProcessor.getResult();
                }
                _argASs.add(_temp);
                ++_i;
            }
        }
        return _argASs;
    }

    private void processCallees(Collection<SootMethod> callees, SootMethod caller, AliasSet primaryAliasSet, MethodContext siteContext) {
        for (SootMethod _callee : callees) {
            Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.ecba.getMethodInfo(_callee);
            assert (_triple != null) : "method info was null for " + _callee + " in the calling context of " + caller;
            MethodContext _mc = (MethodContext)_triple.getFirst();
            boolean _notInSameSCC = this.ecba.cfgAnalysis.notInSameSCC(caller, _callee);
            if (_notInSameSCC) {
                try {
                    _mc = _mc.clone();
                }
                catch (CloneNotSupportedException _e) {
                    LOGGER.error("Hell NO!  This should not happen.", (Throwable)_e);
                    throw new RuntimeException(_e);
                }
            }
            this.processNotifyWaitSync(primaryAliasSet, _callee);
            if (Util.isStartMethod((SootMethod)_callee)) {
                this.ecba.markMultiThreadedSystem();
                _mc.markAsCrossingThreadBoundary();
                if (_notInSameSCC) {
                    _mc.eraseIntraThreadInterProcRefEntities();
                }
            }
            siteContext.unifyMethodContext(_mc);
            if (!Util.isStartMethod((SootMethod)_callee) || !this.ecba.cfgAnalysis.executedMultipleTimes(this.ecba.context.getStmt(), caller)) continue;
            siteContext.selfUnify();
        }
    }

    private AliasSet processField(Type t, AliasSet base, String fieldSig) {
        AliasSet _field = base.getASForField(fieldSig);
        if (_field == null && (_field = AliasSet.getASForType(t)) != null) {
            base.putASForField(fieldSig, _field);
        }
        if (_field != null) {
            this.recordAccessInfo(_field);
        }
        if (this.rhs) {
            base.addReadField(fieldSig);
        } else {
            base.addWrittenField(fieldSig);
        }
        return _field;
    }

    private void processInvokeExpr(InvokeExpr expr) {
        ArrayList<SootMethod> _callees = new ArrayList<SootMethod>();
        SootMethod _caller = this.ecba.context.getCurrentMethod();
        SootMethod _sm = expr.getMethod();
        AliasSet _retAS = null;
        _retAS = AliasSet.getASForType(_sm.getReturnType());
        AliasSet _primaryAS = null;
        if (!_sm.isStatic()) {
            this.process(((InstanceInvokeExpr)expr).getBase());
            _primaryAS = (AliasSet)this.getResult();
        }
        List<AliasSet> _argASs = this.processArguments(expr);
        MethodContext _sc = new MethodContext(_sm, _primaryAS, _argASs, _retAS, AliasSet.createAliasSet(), this.ecba);
        this.ecba.scCache.put(new ICallGraphInfo.CallTriple(_caller, this.ecba.context.getStmt(), expr), _sc);
        if (expr instanceof StaticInvokeExpr) {
            _callees.add(_sm);
        } else if (expr instanceof InterfaceInvokeExpr || expr instanceof VirtualInvokeExpr || expr instanceof SpecialInvokeExpr) {
            _callees.addAll(this.ecba.cgi.getCallees(expr, this.ecba.context));
        }
        this.processCallees(_callees, _caller, _primaryAS, _sc);
        this.setResult(_retAS);
    }

    private void processNotifyWaitSync(AliasSet primaryAliasSet, SootMethod callee) {
        if (Util.isWaitMethod((SootMethod)callee)) {
            primaryAliasSet.setWaits();
            primaryAliasSet.setLocked();
        } else if (Util.isNotifyMethod((SootMethod)callee)) {
            primaryAliasSet.setNotifies();
        }
    }

    private void recordAccessInfo(AliasSet as) {
        as.setAccessed();
        if (this.ecba.tgi != null) {
            SootMethod _currentMethod = this.ecba.context.getCurrentMethod();
            Collection _executionThreads = this.ecba.tgi.getExecutionThreads(_currentMethod);
            if (this.rhs) {
                as.addReadThreads(_executionThreads);
            } else {
                as.addWriteThreads(_executionThreads);
            }
        }
    }
}

