/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.AbstractCallingContextRetriever;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.ThreadEscapeInfoBasedCallingContextRetriever;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadEscapeInfoBasedCallingContextRetrieverV2
extends ThreadEscapeInfoBasedCallingContextRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadEscapeInfoBasedCallingContextRetrieverV2.class);
    protected final boolean interferenceBased;
    protected final boolean readyBased;

    public ThreadEscapeInfoBasedCallingContextRetrieverV2(int callContextLenLimit, boolean preserveReady, boolean preserveInterference) {
        super(callContextLenLimit);
        this.readyBased = preserveReady;
        this.interferenceBased = preserveInterference;
    }

    @Override
    protected boolean considerProgramPoint(Context context) {
        boolean _result = super.considerProgramPoint(context);
        if (_result) {
            Value _value = context.getProgramPoint().getValue();
            Stmt _stmt = context.getStmt();
            SootMethod _currentMethod = context.getCurrentMethod();
            if (this.interferenceBased) {
                if (_stmt.containsFieldRef()) {
                    FieldRef _fr = _stmt.getFieldRef();
                    if (_fr instanceof InstanceFieldRef && ((InstanceFieldRef)_fr).getBase() == _value) {
                        _result = this.escapesInfo.fieldAccessShared(_value, _currentMethod, _fr.getField().getSignature(), (Object)"read write shared access");
                    } else if (_fr instanceof StaticFieldRef && _fr == _value) {
                        SootField _field = _fr.getField();
                        SootClass _declaringClass = _field.getDeclaringClass();
                        String _signature = _field.getSignature();
                        _result = this.escapesInfo.staticfieldAccessShared(_declaringClass, _currentMethod, _signature, (Object)"read write shared access");
                    }
                } else if (_stmt.containsArrayRef() && _stmt.getArrayRef().getBase() == _value) {
                    _result = this.escapesInfo.fieldAccessShared(_value, _currentMethod, (Object)"read write shared access");
                }
            } else if (this.readyBased) {
                if (_stmt instanceof MonitorStmt && ((MonitorStmt)_stmt).getOp() == _value) {
                    _result = this.escapesInfo.lockUnlockShared(_value, _currentMethod);
                } else if (_stmt.containsInvokeExpr()) {
                    InvokeExpr _ex = _stmt.getInvokeExpr();
                    SootMethod _invokedMethod = _ex.getMethod();
                    if (_ex instanceof VirtualInvokeExpr && (Util.isWaitMethod((SootMethod)_invokedMethod) || Util.isNotifyMethod((SootMethod)_invokedMethod)) && ((VirtualInvokeExpr)_ex).getBase() == _value) {
                        _result = this.escapesInfo.waitNotifyShared(_value, _currentMethod);
                    }
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("considerProgramPoint() - result =" + _result);
        }
        return _result;
    }

    @Override
    protected boolean considerThis(Context methodContext) {
        boolean _result2;
        SootMethod _method = methodContext.getCurrentMethod();
        boolean _result1 = this.interferenceBased && this.escapesInfo.thisFieldAccessShared(_method, (Object)"read write shared access");
        boolean bl = _result2 = this.readyBased && (this.escapesInfo.thisWaitNotifyShared(_method) || this.escapesInfo.thisLockUnlockShared(_method));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("considerThis() -  : _result = " + (_result1 || _result2));
        }
        return _result1 || _result2;
    }

    @Override
    protected Object getCallerSideToken(Object token, SootMethod callee, ICallGraphInfo.CallTriple callsite, Stack<ICallGraphInfo.CallTriple> calleeCallStack) {
        Object _result = super.getCallerSideToken(token, callee, callsite, calleeCallStack);
        if (!(_result instanceof AbstractCallingContextRetriever.Tokens)) {
            AliasSet _callerSideToken = (AliasSet)_result;
            AliasSet _calleeSideToken = (AliasSet)token;
            if (_callerSideToken != null && _calleeSideToken != null && this.shouldCallerSideTokenBeDiscarded(_callerSideToken, _calleeSideToken)) {
                _result = Util.isStartMethod((SootMethod)callee) ? AbstractCallingContextRetriever.Tokens.ACCEPT_NON_TERMINAL_CONTEXT_TOKEN : AbstractCallingContextRetriever.Tokens.DISCARD_CONTEXT_TOKEN;
            }
        }
        return _result;
    }

    protected boolean shouldCallerSideTokenBeDiscarded(AliasSet callerSideToken, AliasSet calleeSideToken) {
        boolean _considerForLock;
        boolean _considerForReady;
        boolean _considerForInterference;
        if (this.interferenceBased) {
            Collection<Object> _callerRWEntities = callerSideToken.getReadWriteShareEntities();
            Collection<Object> _calleeRWEntities = calleeSideToken.getReadWriteShareEntities();
            _considerForInterference = _callerRWEntities != null && _calleeRWEntities != null && CollectionUtils.containsAny(_callerRWEntities, _calleeRWEntities);
        } else {
            _considerForInterference = false;
        }
        if (this.readyBased) {
            Collection<Object> _callerReadyEntities = callerSideToken.getReadyEntities();
            Collection<Object> _calleeReadyEntities = calleeSideToken.getReadyEntities();
            _considerForReady = _callerReadyEntities != null && _calleeReadyEntities != null && CollectionUtils.containsAny(_callerReadyEntities, _calleeReadyEntities);
            Collection<Object> _callerLockEntities = callerSideToken.getLockEntities();
            Collection<Object> _calleeLockEntities = calleeSideToken.getLockEntities();
            _considerForLock = _callerLockEntities != null && _calleeLockEntities != null && CollectionUtils.containsAny(_callerLockEntities, _calleeLockEntities);
        } else {
            _considerForReady = false;
            _considerForLock = false;
        }
        return !_considerForInterference && !_considerForReady && !_considerForLock;
    }
}

