/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.AbstractCallingContextRetriever;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;
import soot.jimple.StaticFieldRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadEscapeInfoBasedCallingContextRetriever
extends AbstractCallingContextRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadEscapeInfoBasedCallingContextRetriever.class);
    protected IEscapeInfo escapesInfo;
    protected EquivalenceClassBasedEscapeAnalysis ecba;

    public ThreadEscapeInfoBasedCallingContextRetriever(int callContextLenLimit) {
        super(callContextLenLimit);
    }

    public void setECBA(EquivalenceClassBasedEscapeAnalysis oracle) {
        this.ecba = oracle;
    }

    public void setEscapeInfo(IEscapeInfo info) {
        this.escapesInfo = info;
    }

    protected boolean considerProgramPoint(Context context) {
        Value _value = context.getProgramPoint().getValue();
        SootMethod _currentMethod = context.getCurrentMethod();
        boolean _result = _value instanceof StaticFieldRef ? this.escapesInfo.escapes(((StaticFieldRef)_value).getField().getDeclaringClass(), _currentMethod) : this.escapesInfo.escapes(_value, _currentMethod);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("considerProgramPoint() - result =" + _result);
        }
        return _result;
    }

    protected boolean considerThis(Context methodContext) {
        SootMethod _method = methodContext.getCurrentMethod();
        boolean _result = _method.isStatic() ? this.escapesInfo.escapes(_method.getDeclaringClass(), _method) : this.escapesInfo.thisEscapes(_method);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("considerThis() -  : _result = " + _result);
        }
        return _result;
    }

    protected Object getCallerSideToken(Object token, SootMethod callee, ICallGraphInfo.CallTriple callsite, Stack<ICallGraphInfo.CallTriple> calleeCallStack) {
        AliasSet _as;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getCallerSideToken(callee = " + callee + ", callsite = " + callsite + ")");
        }
        Object _result = (_as = this.ecba.getCallerSideAliasSet((AliasSet)token, callee, callsite)) != null && _as.escapes() ? _as.find() : (Util.isStartMethod((SootMethod)callee) ? AbstractCallingContextRetriever.Tokens.ACCEPT_NON_TERMINAL_CONTEXT_TOKEN : AbstractCallingContextRetriever.Tokens.DISCARD_CONTEXT_TOKEN);
        return _result;
    }

    protected final IEscapeInfo getEscapeInfo() {
        return this.escapesInfo;
    }

    protected Object getTokenForProgramPoint(Context context) {
        Value _value;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTokenForProgramPoint(context = " + context + ")");
        }
        AliasSet _as = (_value = context.getProgramPoint().getValue()) instanceof StaticFieldRef ? this.ecba.queryAliasSetFor(((StaticFieldRef)_value).getField().getDeclaringClass()) : this.ecba.queryAliasSetFor(_value, context.getCurrentMethod());
        return this.prepareToken(_as);
    }

    protected Object getTokenForThis(Context methodContext) {
        SootMethod _method = methodContext.getCurrentMethod();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTokenForThis(method = " + _method + ")");
        }
        AliasSet _as = _method.isStatic() ? this.ecba.queryAliasSetFor(_method.getDeclaringClass()) : this.ecba.queryAliasSetForThis(_method);
        return this.prepareToken(_as);
    }

    private Object prepareToken(AliasSet as) {
        Object _result = as != null ? as.find() : AbstractCallingContextRetriever.Tokens.DISCARD_CONTEXT_TOKEN;
        return _result;
    }
}

