/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AssignStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.util.Switch;

final class StmtProcessor
extends AbstractStmtSwitch {
    static final Logger LOGGER = LoggerFactory.getLogger(StmtProcessor.class);
    private final EquivalenceClassBasedEscapeAnalysis ecba;

    StmtProcessor(EquivalenceClassBasedEscapeAnalysis analysis) {
        this.ecba = analysis;
    }

    public void caseAssignStmt(AssignStmt stmt) {
        boolean _temp = this.ecba.valueProcessor.setRHS(true);
        this.ecba.valueProcessor.process(stmt.getRightOp());
        AliasSet _r = (AliasSet)this.ecba.valueProcessor.getResult();
        this.ecba.valueProcessor.setRHS(false);
        this.ecba.valueProcessor.process(stmt.getLeftOp());
        AliasSet _l = (AliasSet)this.ecba.valueProcessor.getResult();
        this.ecba.valueProcessor.setRHS(_temp);
        if (_r != null && _l != null) {
            _l.unifyAliasSet(_r);
        }
    }

    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        this.ecba.valueProcessor.process(stmt.getOp());
        ((AliasSet)this.ecba.valueProcessor.getResult()).setLocked();
    }

    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        this.ecba.valueProcessor.process(stmt.getOp());
    }

    public void caseIdentityStmt(IdentityStmt stmt) {
        boolean _t = this.ecba.valueProcessor.setMarkLocals(false);
        this.ecba.valueProcessor.process(stmt.getRightOp());
        AliasSet _r = (AliasSet)this.ecba.valueProcessor.getResult();
        this.ecba.valueProcessor.process(stmt.getLeftOp());
        AliasSet _l = (AliasSet)this.ecba.valueProcessor.getResult();
        this.ecba.valueProcessor.setMarkLocals(_t);
        if (_r != null && _l != null) {
            _l.unifyAliasSet(_r);
        }
    }

    public void caseInvokeStmt(InvokeStmt stmt) {
        this.ecba.valueProcessor.process((Value)stmt.getInvokeExpr());
    }

    public void caseReturnStmt(ReturnStmt stmt) {
        this.ecba.valueProcessor.process(stmt.getOp());
        AliasSet _l = (AliasSet)this.ecba.valueProcessor.getResult();
        if (_l != null) {
            this.ecba.methodCtxtCache.getReturnAS().unifyAliasSet(_l);
        }
    }

    public void caseThrowStmt(ThrowStmt stmt) {
        this.ecba.valueProcessor.process(stmt.getOp());
        AliasSet _l = (AliasSet)this.ecba.valueProcessor.getResult();
        if (_l != null) {
            this.ecba.methodCtxtCache.getThrownAS().unifyAliasSet(_l);
        }
    }

    void process(Stmt stmt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing statement: " + stmt);
        }
        stmt.apply((Switch)this);
    }
}

