/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedWriteBasedEquivalence
extends AbstractProcessor {
    private final Collection<Pair<AssignStmt, SootMethod>> defStmts;
    private final IEscapeInfo einfo;
    private final Map<Pair<AssignStmt, SootMethod>, Collection<Pair<AssignStmt, SootMethod>>> write2writes;

    public SharedWriteBasedEquivalence(IEscapeInfo escapeInfo) {
        this.einfo = escapeInfo;
        this.write2writes = new HashMap<Pair<AssignStmt, SootMethod>, Collection<Pair<AssignStmt, SootMethod>>>();
        this.defStmts = new HashSet<Pair<AssignStmt, SootMethod>>();
    }

    public void callback(ValueBox vBox, Context context) {
        Stmt _stmt = context.getStmt();
        if (((AssignStmt)_stmt).getLeftOpBox() == vBox) {
            SootMethod _currentMethod = context.getCurrentMethod();
            Pair _pair = new Pair((Object)((AssignStmt)_stmt), (Object)_currentMethod);
            this.defStmts.add((Pair<AssignStmt, SootMethod>)_pair);
        }
    }

    public void consolidate() {
        Iterator<Pair<AssignStmt, SootMethod>> _i = this.defStmts.iterator();
        int _iEnd = this.defStmts.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Pair<AssignStmt, SootMethod> _p1 = _i.next();
            DefinitionStmt _s1 = (DefinitionStmt)_p1.getFirst();
            SootMethod _m1 = (SootMethod)_p1.getSecond();
            Iterator<Pair<AssignStmt, SootMethod>> _j = this.defStmts.iterator();
            int _jIndex = 0;
            while (_jIndex < _iEnd) {
                SootMethod _m2;
                Pair<AssignStmt, SootMethod> _p2 = _j.next();
                DefinitionStmt _s2 = (DefinitionStmt)_p2.getFirst();
                if (this.writeWriteExecutionDependence(_s1, _m1, _s2, _m2 = (SootMethod)_p2.getSecond())) {
                    MapUtils.putIntoSetInMap(this.write2writes, _p1, _p2);
                    MapUtils.putIntoSetInMap(this.write2writes, _p2, _p1);
                }
                ++_jIndex;
            }
            ++_iIndex;
        }
        this.defStmts.clear();
    }

    public Collection<Pair<AssignStmt, SootMethod>> getSharedWritesInEquivalenceClassOf(Pair<AssignStmt, SootMethod> pair) {
        return Collections.unmodifiableCollection(MapUtils.queryCollection(this.write2writes, pair));
    }

    public Collection<Pair<AssignStmt, SootMethod>> getSharedWritesInNonSingletonEquivalenceClass() {
        return Collections.unmodifiableCollection((Collection)this.write2writes.keySet());
    }

    public void hookup(ProcessingController ppc) {
        ppc.register(AssignStmt.class, (IProcessor)this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("defStmts", this.defStmts).append("write2writes", this.write2writes).toString();
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister(AssignStmt.class, (IProcessor)this);
    }

    private boolean writeWriteExecutionDependence(DefinitionStmt s1, SootMethod m1, DefinitionStmt s2, SootMethod m2) {
        boolean _result = false;
        if (s1.containsArrayRef() && s2.containsArrayRef()) {
            _result = this.einfo.fieldAccessShared(s1.getArrayRef().getBase(), m1, s2.getArrayRef().getBase(), m2, (Object)"write write shared access");
        } else if (s1.containsFieldRef() && s2.containsFieldRef()) {
            FieldRef _fieldRef2 = s2.getFieldRef();
            FieldRef _fieldRef1 = s1.getFieldRef();
            SootField _field1 = _fieldRef1.getField();
            if (_field1.equals(_fieldRef2.getField())) {
                if (_fieldRef1 instanceof InstanceFieldRef && _fieldRef2 instanceof InstanceFieldRef) {
                    _result = this.einfo.fieldAccessShared(((InstanceFieldRef)_fieldRef1).getBase(), m1, ((InstanceFieldRef)_fieldRef2).getBase(), m2, (Object)"write write shared access");
                } else if (_fieldRef1 instanceof StaticFieldRef && _fieldRef2 instanceof StaticFieldRef) {
                    _result = !EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(_field1.getType()) || this.einfo.fieldAccessShared((Value)_fieldRef1, m1, (Value)_fieldRef2, m2, (Object)"write write shared access");
                }
            }
        }
        return _result;
    }
}

