/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.datastructures.FastUnionFindElement;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodContext
extends FastUnionFindElement<MethodContext>
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodContext.class);
    AliasSet ret;
    AliasSet thisAS;
    AliasSet thrown;
    private List<AliasSet> argAliasSets;
    private final EquivalenceClassBasedEscapeAnalysis ecba;
    private boolean globalDataRead;
    private boolean globalDataWritten;
    private final SootMethod method;

    MethodContext(SootMethod sm, AliasSet thisASParam, List<AliasSet> argASs, AliasSet retAS, AliasSet thrownAS, EquivalenceClassBasedEscapeAnalysis analysis) {
        this.method = sm;
        this.ecba = analysis;
        this.argAliasSets = new ArrayList<AliasSet>(argASs);
        if (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(sm.getReturnType())) {
            this.ret = retAS;
        }
        if (!sm.isStatic()) {
            this.thisAS = thisASParam;
        }
        this.thrown = thrownAS;
    }

    MethodContext(SootMethod sm, EquivalenceClassBasedEscapeAnalysis analysis) {
        this.method = sm;
        this.ecba = analysis;
        int _paramCount = sm.getParameterCount();
        if (_paramCount > 0) {
            this.argAliasSets = new ArrayList<AliasSet>(_paramCount);
            int _i = 0;
            while (_i < _paramCount) {
                this.argAliasSets.add(AliasSet.getASForType(sm.getParameterType(_i)));
                ++_i;
            }
        } else {
            this.argAliasSets = Collections.emptyList();
        }
        Type _retType = sm.getReturnType();
        this.ret = AliasSet.getASForType(_retType);
        this.thrown = AliasSet.createAliasSet();
        if (!sm.isStatic()) {
            this.thisAS = AliasSet.createAliasSet();
            if (sm.isSynchronized()) {
                this.thisAS.setLocked();
            }
        }
    }

    private static void fixUpFieldMapsOfClone(Map<AliasSet, AliasSet> src2clone) throws CloneNotSupportedException {
        HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(new HashSet());
        _wb.addAllWork((Collection)src2clone.keySet());
        while (_wb.hasWork()) {
            AliasSet _src = (AliasSet)_wb.getWork();
            AliasSet _clone = src2clone.get(_src);
            Map<String, AliasSet> _srcASFieldMap = _src.getFieldMap();
            Set<String> _srcASFields = _srcASFieldMap.keySet();
            Iterator<String> _i = _srcASFields.iterator();
            int _iEnd = _srcASFields.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                String _field = _i.next();
                AliasSet _srcFieldAS = (AliasSet)_src.getASForField(_field).find();
                AliasSet _cloneFieldAS = MethodContext.getCloneOf(src2clone, _srcFieldAS);
                if (_cloneFieldAS != _srcFieldAS) {
                    _wb.addWork((Object)_srcFieldAS);
                }
                _clone.putASForField(_field, _cloneFieldAS);
                ++_iIndex;
            }
        }
        for (AliasSet _k1 : src2clone.keySet()) {
            for (AliasSet _k2 : src2clone.keySet()) {
                if (_k1 == _k2 || _k1.find() != _k2.find()) continue;
                AliasSet _v1 = src2clone.get(_k1);
                AliasSet _v2 = src2clone.get(_k2);
                _v1.unifyAliasSetHelper(_v2, false);
            }
        }
    }

    private static AliasSet getCloneOf(Map<AliasSet, AliasSet> src2clone, AliasSet as) throws CloneNotSupportedException {
        AliasSet _repr = (AliasSet)as.find();
        AliasSet _result = src2clone.get(_repr);
        if (_result == null) {
            _result = _repr.clone();
            src2clone.put(_repr, _result);
        }
        return _result;
    }

    public MethodContext clone() throws CloneNotSupportedException {
        MethodContext _clone = null;
        if (this.find() != this) {
            _clone = ((MethodContext)this.find()).clone();
        } else {
            _clone = (MethodContext)super.clone();
            HashMap<AliasSet, AliasSet> _clonee2clone = new HashMap<AliasSet, AliasSet>();
            _clone.set = null;
            if (this.thisAS != null) {
                _clone.thisAS = MethodContext.getCloneOf(_clonee2clone, this.thisAS);
            }
            _clone.argAliasSets = new ArrayList<AliasSet>();
            for (AliasSet _tmp : this.argAliasSets) {
                if (_tmp != null) {
                    _clone.argAliasSets.add(MethodContext.getCloneOf(_clonee2clone, _tmp));
                    continue;
                }
                _clone.argAliasSets.add(null);
            }
            if (this.ret != null) {
                _clone.ret = MethodContext.getCloneOf(_clonee2clone, this.ret);
            }
            _clone.thrown = MethodContext.getCloneOf(_clonee2clone, this.thrown);
            MethodContext.fixUpFieldMapsOfClone(_clonee2clone);
        }
        return _clone;
    }

    public void eraseIntraThreadInterProcRefEntities() {
        if (this.find() != this) {
            ((MethodContext)this.find()).eraseIntraThreadInterProcRefEntities();
        } else {
            if (this.ret != null) {
                this.ret.eraseIntraThreadInterProcRefEntities();
            }
            if (this.thrown != null) {
                this.thrown.eraseIntraThreadInterProcRefEntities();
            }
            if (this.thisAS != null) {
                this.thisAS.eraseIntraThreadInterProcRefEntities();
            }
            for (AliasSet _argAS : this.argAliasSets) {
                if (_argAS == null) continue;
                _argAS.eraseIntraThreadInterProcRefEntities();
            }
            for (AliasSet _as : this.ecba.class2aliasSet.values()) {
                _as.eraseIntraThreadInterProcRefEntities();
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("thrown", (Object)this.thrown).append("argAliasSets", this.argAliasSets).append("ret", (Object)this.ret).append("thisAS", (Object)this.thisAS).append("method", (Object)this.method).toString();
    }

    void discardReferentialAliasSets() {
        if (this.thrown != null) {
            this.thrown = (AliasSet)this.thrown.find();
        }
        if (this.thisAS != null) {
            this.thisAS = (AliasSet)this.thisAS.find();
        }
        if (this.ret != null) {
            this.ret = (AliasSet)this.ret.find();
        }
        if (this.argAliasSets != null && !this.argAliasSets.isEmpty()) {
            int _size = this.argAliasSets.size();
            int _i = 0;
            while (_i < _size) {
                AliasSet _temp = this.argAliasSets.get(_i);
                if (_temp != null) {
                    this.argAliasSets.set(_i, (AliasSet)_temp.find());
                }
                ++_i;
            }
        }
    }

    AliasSet getImageOfRefInGivenContext(AliasSet ref, MethodContext context) {
        AliasSet _result = null;
        HashSet<Pair<AliasSet, AliasSet>> _temp = new HashSet<Pair<AliasSet, AliasSet>>();
        AliasSet _thisAS = this.getThisAS();
        AliasSet _thisAS2 = context.getThisAS();
        if (_thisAS != null && _thisAS2 != null) {
            _temp.clear();
            _result = _thisAS.getImageOfRefUnderRoot(_thisAS2, ref, _temp);
        }
        int _i = this.argAliasSets.size() - 1;
        while (_i >= 0 && _result == null) {
            AliasSet _paramAS = this.getParamAS(_i);
            AliasSet _paramAS2 = context.getParamAS(_i);
            if (_paramAS != null && _paramAS2 != null) {
                _temp.clear();
                _result = _paramAS.getImageOfRefUnderRoot(_paramAS2, ref, _temp);
            }
            --_i;
        }
        if (_result == null) {
            AliasSet _thrownAS = this.getThrownAS();
            AliasSet _thrownAS2 = context.getThrownAS();
            if (_thrownAS != null && _thrownAS2 != null) {
                _temp.clear();
                _result = _thrownAS.getImageOfRefUnderRoot(_thrownAS2, ref, _temp);
            }
            if (_result == null) {
                AliasSet _returnAS = this.getReturnAS();
                AliasSet _returnAS2 = context.getReturnAS();
                if (_returnAS != null && _returnAS2 != null) {
                    _temp.clear();
                    _result = _returnAS.getImageOfRefUnderRoot(_returnAS2, ref, _temp);
                }
            }
        }
        return _result;
    }

    AliasSet getParamAS(int index) {
        return ((MethodContext)this.find()).argAliasSets.get(index);
    }

    AliasSet getReturnAS() {
        return ((MethodContext)this.find()).ret;
    }

    AliasSet getThisAS() {
        return ((MethodContext)this.find()).thisAS;
    }

    AliasSet getThrownAS() {
        return ((MethodContext)this.find()).thrown;
    }

    void globalDataWasRead() {
        this.globalDataRead = true;
    }

    void globalDataWasWritten() {
        this.globalDataWritten = true;
    }

    boolean isGlobalDataRead() {
        return this.globalDataRead;
    }

    boolean isGlobalDataWritten() {
        return this.globalDataWritten;
    }

    void markAsCrossingThreadBoundary() {
        if (this.find() != this) {
            ((MethodContext)this.find()).markAsCrossingThreadBoundary();
        } else {
            if (this.ret != null) {
                this.ret.markAsCrossingThreadBoundary();
            }
            if (this.thrown != null) {
                this.thrown.markAsCrossingThreadBoundary();
            }
            if (this.thisAS != null) {
                this.thisAS.markAsCrossingThreadBoundary();
            }
            for (AliasSet _argAS : this.argAliasSets) {
                if (_argAS == null) continue;
                _argAS.markAsCrossingThreadBoundary();
            }
        }
    }

    void propogateInfoFromTo(MethodContext to) {
        MethodContext _toRep;
        MethodContext _fromRep = (MethodContext)this.find();
        if (_fromRep == (_toRep = (MethodContext)to.find())) {
            return;
        }
        int _paramCount = _fromRep.method.getParameterCount();
        int _i = 0;
        while (_i < _paramCount) {
            AliasSet _temp1;
            if (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(_fromRep.method.getParameterType(_i)) && (_temp1 = this.argAliasSets.get(_i)) != null) {
                AliasSet _temp2 = _toRep.argAliasSets.get(_i);
                AliasSet _temp3 = _fromRep.argAliasSets.get(_i);
                if (_temp3 != null && _temp2 != null) {
                    _temp3.propogateInfoFromTo(_temp2);
                }
            }
            ++_i;
        }
        AliasSet _retAS = _fromRep.ret;
        if (_retAS != null) {
            _retAS.propogateInfoFromTo(_toRep.ret);
        }
        _fromRep.thrown.propogateInfoFromTo(_toRep.thrown);
        AliasSet _thisAS = _fromRep.thisAS;
        if (_thisAS != null) {
            _thisAS.propogateInfoFromTo(_toRep.thisAS);
        }
    }

    void selfUnify() {
        MethodContext _methodContext = (MethodContext)this.find();
        int _paramCount = this.method.getParameterCount();
        int _i = 0;
        while (_i < _paramCount) {
            AliasSet _aliasSet;
            if (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(this.method.getParameterType(_i)) && (_aliasSet = _methodContext.argAliasSets.get(_i)) != null) {
                AliasSet.selfUnify(_aliasSet);
            }
            ++_i;
        }
        AliasSet _mRet = _methodContext.ret;
        if (_mRet != null) {
            AliasSet.selfUnify(_mRet);
        }
        AliasSet.selfUnify(_methodContext.thrown);
        AliasSet _mThis = _methodContext.thisAS;
        if (_mThis != null) {
            AliasSet.selfUnify(_mThis);
        }
    }

    void unifyMethodContext(MethodContext p) {
        MethodContext _n;
        if (p == null) {
            LOGGER.error("Unification with null requested.");
            throw new IllegalArgumentException("Unification with null requested.");
        }
        MethodContext _m = (MethodContext)this.find();
        if (_m != (_n = (MethodContext)p.find())) {
            _m.union(_n);
            MethodContext _representative = (MethodContext)_m.find();
            MethodContext _represented = _representative == _m ? _n : _m;
            _representative.globalDataWritten |= _represented.globalDataWritten;
            _representative.globalDataRead |= _represented.globalDataRead;
            int _paramCount = this.method.getParameterCount();
            int _i = 0;
            while (_i < _paramCount) {
                if (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(this.method.getParameterType(_i))) {
                    AliasSet _mAS = _representative.argAliasSets.get(_i);
                    AliasSet _nAS = _represented.argAliasSets.get(_i);
                    if (_mAS == null) {
                        _representative.argAliasSets.set(_i, _nAS);
                    } else {
                        _mAS.unifyAliasSet(_nAS);
                    }
                }
                ++_i;
            }
            this.unifyAliasSets(_representative.ret, _represented.ret);
            this.unifyAliasSets(_representative.thrown, _represented.thrown);
            this.unifyAliasSets(_representative.thisAS, _represented.thisAS);
        }
    }

    private void unifyAliasSets(AliasSet representative, AliasSet represented) {
        if (representative == null && represented != null || representative != null && represented == null) {
            LOGGER.error("Incompatible method contexts being unified - representative - " + representative + "\n represented - " + represented);
            throw new IllegalStateException("Unifying null aliasSet");
        }
        if (representative != null) {
            representative.unifyAliasSet(represented);
        }
    }
}

