/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import soot.Local;
import soot.SootMethod;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockAcquisitionBasedEquivalence
extends AbstractProcessor {
    private ICallGraphInfo cgi;
    private final Collection<Pair<EnterMonitorStmt, SootMethod>> enterMonitorStmts;
    private final Collection<Pair<InvokeStmt, SootMethod>> invokeStmts;
    private final IEscapeInfo locking;
    private final Map<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>> locking2lockings;

    public LockAcquisitionBasedEquivalence(IEscapeInfo escapeInfo, ICallGraphInfo callgraph) {
        this.locking = escapeInfo;
        this.cgi = callgraph;
        this.locking2lockings = new HashMap<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>>();
        this.enterMonitorStmts = new HashSet<Pair<EnterMonitorStmt, SootMethod>>();
        this.invokeStmts = new HashSet<Pair<InvokeStmt, SootMethod>>();
    }

    public void callback(SootMethod method) {
        if (method.isSynchronized()) {
            Pair _p = new Pair(null, (Object)method);
            this.enterMonitorStmts.add((Pair<EnterMonitorStmt, SootMethod>)_p);
            this.processLocal(null, method, (Pair<? extends Stmt, SootMethod>)_p);
        }
    }

    public void callback(Stmt stmt, Context context) {
        SootMethod _method = context.getCurrentMethod();
        if (stmt instanceof InvokeStmt) {
            if (Util.isWaitInvocation((InvokeStmt)((InvokeStmt)stmt), (SootMethod)_method, (ICallGraphInfo)this.cgi)) {
                InvokeStmt _s = (InvokeStmt)stmt;
                Pair _p = new Pair((Object)_s, (Object)_method);
                Local _l = (Local)((VirtualInvokeExpr)_s.getInvokeExpr()).getBase();
                this.invokeStmts.add((Pair<InvokeStmt, SootMethod>)_p);
                this.processLocal(_l, _method, (Pair<? extends Stmt, SootMethod>)_p);
            }
        } else {
            EnterMonitorStmt _n = (EnterMonitorStmt)stmt;
            Pair _p = new Pair((Object)_n, (Object)_method);
            Local _l = (Local)_n.getOp();
            this.enterMonitorStmts.add((Pair<EnterMonitorStmt, SootMethod>)_p);
            this.processLocal(_l, _method, (Pair<? extends Stmt, SootMethod>)_p);
        }
    }

    public void consolidate() {
        super.consolidate();
        this.enterMonitorStmts.clear();
        this.invokeStmts.clear();
    }

    public Collection<Pair<? extends Stmt, SootMethod>> getLockAcquisitionsInEquivalenceClassOf(Pair<Stmt, SootMethod> pair) {
        return Collections.unmodifiableCollection(MapUtils.getEmptyCollectionFromMap(this.locking2lockings, pair));
    }

    public Collection<Pair<? extends Stmt, SootMethod>> getLockAcquisitionsInNonSingletonEquivalenceClass() {
        HashSet<Pair<? extends Stmt, SootMethod>> _r = new HashSet<Pair<? extends Stmt, SootMethod>>();
        Iterator<Map.Entry<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>>> _i = this.locking2lockings.entrySet().iterator();
        int _iEnd = this.locking2lockings.entrySet().size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Map.Entry<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>> _e = _i.next();
            if (_e.getValue().size() > 1) {
                _r.add(_e.getKey());
            }
            ++_iIndex;
        }
        return _r;
    }

    public void hookup(ProcessingController ppc) {
        ppc.register(EnterMonitorStmt.class, (IProcessor)this);
        ppc.register(InvokeStmt.class, (IProcessor)this);
        ppc.register((IProcessor)this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("monitorStmts", this.enterMonitorStmts).append("invokeStmts", this.invokeStmts).append("locking2lockings", this.locking2lockings).toString();
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister(EnterMonitorStmt.class, (IProcessor)this);
        ppc.unregister(InvokeStmt.class, (IProcessor)this);
        ppc.unregister((IProcessor)this);
    }

    private void processLocal(Local local, SootMethod method, Pair<? extends Stmt, SootMethod> p) {
        Iterator<Pair<InvokeStmt, SootMethod>> _i = this.invokeStmts.iterator();
        int _iEnd = this.invokeStmts.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Local _l2;
            Pair<InvokeStmt, SootMethod> _p2 = _i.next();
            InvokeStmt _s = (InvokeStmt)_p2.getFirst();
            SootMethod _sm = (SootMethod)_p2.getSecond();
            Local local2 = _l2 = _s == null ? null : (Local)((VirtualInvokeExpr)_s.getInvokeExpr()).getBase();
            if (this.locking.areCoupledViaLocking(local, method, _l2, _sm)) {
                MapUtils.putIntoSetInMap(this.locking2lockings, _p2, p);
                MapUtils.putIntoSetInMap(this.locking2lockings, p, _p2);
            }
            ++_iIndex;
        }
        Iterator<Pair<EnterMonitorStmt, SootMethod>> _j = this.enterMonitorStmts.iterator();
        int _jEnd = this.enterMonitorStmts.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            Local _l2;
            Pair<EnterMonitorStmt, SootMethod> _p2 = _j.next();
            EnterMonitorStmt _s = (EnterMonitorStmt)_p2.getFirst();
            SootMethod _sm = (SootMethod)_p2.getSecond();
            Local local3 = _l2 = _s == null ? null : (Local)_s.getOp();
            if (this.locking.areCoupledViaLocking(local, method, _l2, _sm)) {
                MapUtils.putIntoSetInMap(this.locking2lockings, _p2, p);
                MapUtils.putIntoSetInMap(this.locking2lockings, p, _p2);
            }
            ++_jIndex;
        }
    }
}

