/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.AbstractStatus;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.MethodContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EscapeInfo
extends AbstractStatus
implements IEscapeInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapeInfo.class);
    boolean escapesDefaultValue;
    boolean lockunlockDefaultValue;
    boolean readwriteDefaultValue;
    boolean waitnotifyDefaultValue;
    boolean writewriteDefaultValue;
    private final EquivalenceClassBasedEscapeAnalysis analysis;

    EscapeInfo(EquivalenceClassBasedEscapeAnalysis instance) {
        this.analysis = instance;
        this.escapesDefaultValue = true;
        this.readwriteDefaultValue = true;
        this.writewriteDefaultValue = true;
        this.lockunlockDefaultValue = true;
        this.waitnotifyDefaultValue = true;
    }

    public boolean areCoupledViaLocking(Local local1, SootMethod method1, Local local2, SootMethod method2) {
        boolean _result;
        if (local1 == null && local2 == null && method1.isStatic() && method2.isStatic()) {
            _result = method1.getDeclaringClass().equals(method2.getDeclaringClass());
        } else if ((local1 == null && method1.isStatic()) ^ (local2 == null && method2.isStatic())) {
            _result = true;
        } else {
            AliasSet _a1 = this.getAliasSetForIn(local1, method1);
            AliasSet _a2 = this.getAliasSetForIn(local2, method2);
            Collection<Object> _a1LockEntities = _a1.getLockEntities();
            Collection<Object> _a2LockEntities = _a2.getLockEntities();
            _result = _a1LockEntities != null && _a2LockEntities != null && CollectionUtils.containsAny(_a1LockEntities, _a2LockEntities);
        }
        return _result;
    }

    public boolean areMonitorsCoupled(MonitorStmt enter, SootMethod enterMethod, MonitorStmt exit, SootMethod exitMethod) {
        boolean _result;
        if (enterMethod.isStatic() || exitMethod.isStatic()) {
            _result = true;
        } else {
            Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _trp1 = this.analysis.method2Triple.get(enterMethod);
            if (_trp1 == null) {
                throw new IllegalArgumentException(enterMethod + " was not processed.");
            }
            Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _trp2 = this.analysis.method2Triple.get(exitMethod);
            if (_trp2 == null) {
                throw new IllegalArgumentException(exitMethod + " was not processed.");
            }
            AliasSet _n = enter == null ? ((MethodContext)_trp1.getFirst()).getThisAS() : (AliasSet)((Map)_trp1.getSecond()).get(enter.getOp());
            AliasSet _x = exit == null ? ((MethodContext)_trp2.getFirst()).getThisAS() : (AliasSet)((Map)_trp2.getSecond()).get(exit.getOp());
            Collection<Object> _xLockEntities = _x.getLockEntities();
            Collection<Object> _nLockEntities = _n.getLockEntities();
            _result = _xLockEntities != null && _nLockEntities != null && CollectionUtils.containsAny(_nLockEntities, _xLockEntities);
        }
        return _result;
    }

    public boolean areWaitAndNotifyCoupled(InvokeStmt wait, SootMethod waitMethod, InvokeStmt notify, SootMethod notifyMethod) {
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _trp1 = this.analysis.method2Triple.get(waitMethod);
        if (_trp1 == null) {
            throw new IllegalArgumentException(waitMethod + " was not processed.");
        }
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _trp2 = this.analysis.method2Triple.get(notifyMethod);
        if (_trp2 == null) {
            throw new IllegalArgumentException(notifyMethod + " was not processed.");
        }
        InvokeExpr _wi = wait.getInvokeExpr();
        InvokeExpr _ni = notify.getInvokeExpr();
        boolean _result = false;
        if (_wi instanceof VirtualInvokeExpr && _ni instanceof VirtualInvokeExpr) {
            VirtualInvokeExpr _wTemp = (VirtualInvokeExpr)_wi;
            VirtualInvokeExpr _nTemp = (VirtualInvokeExpr)_ni;
            SootMethod _wSM = _wTemp.getMethod();
            SootMethod _nSM = _nTemp.getMethod();
            if (Util.isWaitMethod((SootMethod)_wSM) && Util.isNotifyMethod((SootMethod)_nSM)) {
                AliasSet _as1 = (AliasSet)((Map)_trp1.getSecond()).get(_wTemp.getBase());
                AliasSet _as2 = (AliasSet)((Map)_trp2.getSecond()).get(_nTemp.getBase());
                if (_as1.getReadyEntities() != null && _as2.getReadyEntities() != null) {
                    _result = CollectionUtils.containsAny(_as1.getReadyEntities(), _as2.getReadyEntities());
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("There are wait()s and/or notify()s in this program without corresponding notify()s and/or wait()s that occur in different threads - " + wait + "@" + waitMethod + " " + notify + "@" + notifyMethod);
                }
            }
        }
        return _result;
    }

    public boolean escapes(SootClass sc, SootMethod sm) {
        boolean _result = this.escapesDefaultValue;
        AliasSet _as = this.analysis.queryAliasSetFor(sc);
        if (_as != null) {
            _result = _as.escapes();
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("There is no information about " + sc + " occurring in " + sm + ".  So, providing default value - " + _result);
        }
        return _result;
    }

    public boolean escapes(Value v, SootMethod sm) {
        boolean _result = this.escapesDefaultValue;
        if (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(v.getType())) {
            AliasSet _as = this.analysis.queryAliasSetFor(v, sm);
            if (_as != null) {
                _result = _as.escapes();
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There is no information about " + v + " occurring in " + sm + ".  So, providing default value - " + _result);
            }
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("There is no information about " + v + " occurring in " + sm + ".  So, providing default value - " + _result);
        }
        return _result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean fieldAccessShared(Value v, SootMethod sm, Object sharedAccessSort) {
        boolean _result = this.getDefaultValueForSharedAccessSort(sharedAccessSort);
        try {
            if (!EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(v.getType())) return false;
            if (sharedAccessSort.equals("read write shared access")) {
                return this.analysis.queryAliasSetFor(v, sm).readWriteShared();
            }
            if (!sharedAccessSort.equals("write write shared access")) throw new IllegalArgumentException("sharedAccessSort has to be either IEscapeInfo.WRITE_WRITE_SHARED_ACCESS or IEscapeInfo.READ_WRITE_SHARED_ACCESS");
            return this.analysis.queryAliasSetFor(v, sm).writeWriteShared();
        }
        catch (NullPointerException _e) {
            if (!LOGGER.isInfoEnabled()) return _result;
            LOGGER.info("There is no information about " + v + " occurring in " + sm + ".  So, providing default value - " + _result, (Throwable)_e);
        }
        return _result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean fieldAccessShared(Value v, SootMethod sm, String fieldSignature, Object sharedAccessSort) {
        boolean _result = this.getDefaultValueForSharedAccessSort(sharedAccessSort);
        try {
            if (!EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(v.getType())) return false;
            if (sharedAccessSort.equals("read write shared access")) {
                return this.analysis.queryAliasSetFor(v, sm).readWriteShared(fieldSignature);
            }
            if (!sharedAccessSort.equals("write write shared access")) throw new IllegalArgumentException("sharedAccessSort has to be either IEscapeInfo.WRITE_WRITE_SHARED_ACCESS or IEscapeInfo.READ_WRITE_SHARED_ACCESS");
            return this.analysis.queryAliasSetFor(v, sm).writeWriteShared(fieldSignature);
        }
        catch (NullPointerException _e) {
            if (!LOGGER.isInfoEnabled()) return _result;
            LOGGER.info("There is no information about " + v + " occurring in " + sm + ".  So, providing default value - " + _result, (Throwable)_e);
        }
        return _result;
    }

    public boolean fieldAccessShared(Value v1, SootMethod sm1, Value v2, SootMethod sm2, Object sharedAccessSort) {
        boolean _result;
        block5: {
            boolean bl = _result = this.fieldAccessShared(v1, sm1, sharedAccessSort) && this.fieldAccessShared(v2, sm2, sharedAccessSort);
            if (_result) {
                try {
                    if (sharedAccessSort.equals("read write shared access")) {
                        Collection<Object> _o1 = this.analysis.queryAliasSetFor(v1, sm1).getReadWriteShareEntities();
                        Collection<Object> _o2 = this.analysis.queryAliasSetFor(v2, sm2).getReadWriteShareEntities();
                        _result = _o1 != null && _o2 != null && CollectionUtils.containsAny(_o1, _o2);
                        break block5;
                    }
                    if (sharedAccessSort.equals("write write shared access")) {
                        Collection<Object> _o1 = this.analysis.queryAliasSetFor(v1, sm1).getWriteWriteShareEntities();
                        Collection<Object> _o2 = this.analysis.queryAliasSetFor(v2, sm2).getWriteWriteShareEntities();
                        _result = _o1 != null && _o2 != null && CollectionUtils.containsAny(_o1, _o2);
                        break block5;
                    }
                    throw new IllegalArgumentException("sharedAccessSort has to be either IEscapeInfo.WRITE_WRITE_SHARED_ACCESS or IEscapeInfo.READ_WRITE_SHARED_ACCESS");
                }
                catch (NullPointerException _e) {
                    if (!LOGGER.isInfoEnabled()) break block5;
                    LOGGER.info("There is no information about " + v1 + "/" + v2 + " occurring in " + sm1 + "/" + sm2 + ".  So, providing pessimistic info (true).", (Throwable)_e);
                }
            }
        }
        return _result;
    }

    public Collection<Comparable<String>> getIds() {
        return Collections.singleton(IEscapeInfo.ID);
    }

    public Collection<Triple<InvokeStmt, SootMethod, SootClass>> getReadingThreadsOf(int paramIndex, SootMethod method) {
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _result;
        this.analysis.validate(paramIndex, method);
        if (method.getParameterType(paramIndex) instanceof RefType) {
            Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
            if (_triple != null) {
                MethodContext _ctxt = (MethodContext)_triple.getFirst();
                _result = _ctxt.getParamAS(paramIndex).getReadThreads();
            } else {
                _result = Collections.emptySet();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("No recorded information for " + method + " is available.  Returning optimistic info (there were no accesses).");
                }
            }
        } else {
            _result = Collections.emptySet();
        }
        return _result;
    }

    public Collection<Triple<InvokeStmt, SootMethod, SootClass>> getReadingThreadsOf(Local local, SootMethod method) {
        Map _local2as;
        AliasSet _as;
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _result = Collections.emptySet();
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple != null && (_as = (AliasSet)(_local2as = (Map)_triple.getSecond()).get(local)) != null) {
            _result = _as.getReadThreads();
        }
        return _result;
    }

    public Collection<Triple<InvokeStmt, SootMethod, SootClass>> getReadingThreadsOfThis(SootMethod method) {
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _result;
        this.analysis.validate(method);
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple != null) {
            MethodContext _ctxt = (MethodContext)_triple.getFirst();
            _result = Collections.unmodifiableCollection(_ctxt.thisAS.getReadThreads());
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No recorded information for " + method + " is available.  Returning pessimistic (true) info.");
            }
            _result = Collections.emptySet();
        }
        return _result;
    }

    public Collection<Triple<InvokeStmt, SootMethod, SootClass>> getWritingThreadsOf(int paramIndex, SootMethod method) {
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _result;
        this.analysis.validate(paramIndex, method);
        if (method.getParameterType(paramIndex) instanceof RefType) {
            Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
            if (_triple != null) {
                MethodContext _ctxt = (MethodContext)_triple.getFirst();
                _result = _ctxt.getParamAS(paramIndex).getWriteThreads();
            } else {
                _result = Collections.emptySet();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("No recorded information for " + method + " is available.  Returning optimistic info (there were no accesses).");
                }
            }
        } else {
            _result = Collections.emptySet();
        }
        return _result;
    }

    public Collection<Triple<InvokeStmt, SootMethod, SootClass>> getWritingThreadsOf(Local local, SootMethod method) {
        Map _local2as;
        AliasSet _as;
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _result = Collections.emptySet();
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple != null && (_as = (AliasSet)(_local2as = (Map)_triple.getSecond()).get(local)) != null) {
            _result = _as.getWriteThreads();
        }
        return _result;
    }

    public Collection<Triple<InvokeStmt, SootMethod, SootClass>> getWritingThreadsOfThis(SootMethod method) {
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _result;
        this.analysis.validate(method);
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple != null) {
            MethodContext _ctxt = (MethodContext)_triple.getFirst();
            _result = Collections.unmodifiableCollection(_ctxt.thisAS.getWriteThreads());
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No recorded information for " + method + " is available.  Returning pessimistic (true) info.");
            }
            _result = Collections.emptySet();
        }
        return _result;
    }

    public boolean lockUnlockShared(Value v, SootMethod sm) {
        boolean _result;
        block2: {
            _result = this.lockunlockDefaultValue;
            try {
                _result = EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(v.getType()) ? this.analysis.queryAliasSetFor(v, sm).lockUnlockShared() : false;
            }
            catch (NullPointerException _e) {
                if (!LOGGER.isInfoEnabled()) break block2;
                LOGGER.info("There is no information about " + v + " occurring in " + sm + ".  So, providing default value - " + _result, (Throwable)_e);
            }
        }
        return _result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean staticfieldAccessShared(SootClass sc, SootMethod sm, Object sharedAccessSort) {
        boolean _result = this.getDefaultValueForSharedAccessSort(sharedAccessSort);
        try {
            AliasSet _as = this.analysis.queryAliasSetFor(sc);
            if (_as == null) return false;
            if (sharedAccessSort.equals("read write shared access")) {
                return _as.readWriteShared();
            }
            if (!sharedAccessSort.equals("write write shared access")) throw new IllegalArgumentException("sharedAccessSort has to be either IEscapeInfo.WRITE_WRITE_SHARED_ACCESS or IEscapeInfo.READ_WRITE_SHARED_ACCESS");
            return _as.writeWriteShared();
        }
        catch (NullPointerException _e) {
            if (!LOGGER.isInfoEnabled()) return _result;
            LOGGER.info("There is no information about " + sc + " occurring in " + sm + ".  So, providing default value - " + _result, (Throwable)_e);
        }
        return _result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean staticfieldAccessShared(SootClass sc, SootMethod sm, String signature, Object sharedAccessSort) {
        boolean _result = this.getDefaultValueForSharedAccessSort(sharedAccessSort);
        try {
            AliasSet _as = this.analysis.queryAliasSetFor(sc);
            if (_as == null) return false;
            if (sharedAccessSort.equals("read write shared access")) {
                return _as.readWriteShared(signature);
            }
            if (!sharedAccessSort.equals("write write shared access")) throw new IllegalArgumentException("sharedAccessSort has to be either IEscapeInfo.WRITE_WRITE_SHARED_ACCESS or IEscapeInfo.READ_WRITE_SHARED_ACCESS");
            return _as.writeWriteShared(signature);
        }
        catch (NullPointerException _e) {
            if (!LOGGER.isInfoEnabled()) return _result;
            LOGGER.info("There is no information about " + sc + " occurring in " + sm + ".  So, providing default value - " + _result, (Throwable)_e);
        }
        return _result;
    }

    public boolean thisEscapes(SootMethod method) {
        boolean _result = this.escapesDefaultValue;
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There is no information about " + method + ".  So, providing default value - " + _result);
            }
        } else {
            AliasSet _as = ((MethodContext)_triple.getFirst()).getThisAS();
            if (_as != null) {
                _result = _as.escapes();
            }
        }
        return _result;
    }

    public boolean thisFieldAccessShared(SootMethod method, Object sharedAccessSort) {
        boolean _result = this.getDefaultValueForSharedAccessSort(sharedAccessSort);
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There is no information about " + method + ".  So, providing default value - " + _result);
            }
        } else {
            AliasSet _as = ((MethodContext)_triple.getFirst()).getThisAS();
            if (_as != null) {
                if (sharedAccessSort.equals("read write shared access")) {
                    _result = _as.readWriteShared();
                } else if (sharedAccessSort.equals("write write shared access")) {
                    _result = _as.writeWriteShared();
                } else {
                    throw new IllegalArgumentException("sharedAccessSort has to be either IEscapeInfo.WRITE_WRITE_SHARED_ACCESS or IEscapeInfo.READ_WRITE_SHARED_ACCESS");
                }
            }
        }
        return _result;
    }

    public boolean thisFieldAccessShared(SootMethod method, String signature, Object sharedAccessSort) {
        boolean _result = this.getDefaultValueForSharedAccessSort(sharedAccessSort);
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There is no information about " + method + ".  So, providing default value - " + _result);
            }
        } else {
            AliasSet _as = ((MethodContext)_triple.getFirst()).getThisAS();
            if (_as != null) {
                if (sharedAccessSort.equals("read write shared access")) {
                    _result = _as.readWriteShared(signature);
                } else if (sharedAccessSort.equals("write write shared access")) {
                    _result = _as.writeWriteShared(signature);
                } else {
                    throw new IllegalArgumentException("sharedAccessSort has to be either IEscapeInfo.WRITE_WRITE_SHARED_ACCESS or IEscapeInfo.READ_WRITE_SHARED_ACCESS");
                }
            }
        }
        return _result;
    }

    public boolean thisLockUnlockShared(SootMethod method) {
        boolean _result = this.lockunlockDefaultValue;
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There is no information about " + method + ".  So, providing default value - " + _result);
            }
        } else {
            AliasSet _as1 = ((MethodContext)_triple.getFirst()).getThisAS();
            if (_as1 != null) {
                _result = _as1.lockUnlockShared();
            }
        }
        return _result;
    }

    public boolean thisWaitNotifyShared(SootMethod method) {
        boolean _result = this.waitnotifyDefaultValue;
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.analysis.method2Triple.get(method);
        if (_triple == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There is no information about " + method + ".  So, providing default value - " + _result);
            }
        } else {
            AliasSet _as1 = ((MethodContext)_triple.getFirst()).getThisAS();
            if (_as1 != null) {
                _result = _as1.waitNotifyShared();
            }
        }
        return _result;
    }

    public boolean waitNotifyShared(Value v, SootMethod sm) {
        boolean _result;
        block2: {
            _result = this.waitnotifyDefaultValue;
            try {
                _result = EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(v.getType()) ? this.analysis.queryAliasSetFor(v, sm).waitNotifyShared() : false;
            }
            catch (NullPointerException _e) {
                if (!LOGGER.isInfoEnabled()) break block2;
                LOGGER.info("There is no information about " + v + " occurring in " + sm + ".  So, providing default value - " + _result, (Throwable)_e);
            }
        }
        return _result;
    }

    void stableAdapter() {
        super.stable();
    }

    void unstableAdapter() {
        super.unstable();
    }

    private AliasSet getAliasSetForIn(Local local, SootMethod method) throws IllegalArgumentException {
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _trp1 = this.analysis.method2Triple.get(method);
        if (_trp1 == null) {
            throw new IllegalArgumentException(method + " was not processed.");
        }
        AliasSet _a1 = local != null ? (AliasSet)((Map)_trp1.getSecond()).get(local) : ((MethodContext)_trp1.getFirst()).getThisAS();
        if (_a1 == null) {
            throw new IllegalArgumentException(local + " in " + method + " was not processed.");
        }
        return _a1;
    }

    private boolean getDefaultValueForSharedAccessSort(Object sharedAccessSort) {
        if (sharedAccessSort.equals("read write shared access")) {
            return this.readwriteDefaultValue;
        }
        if (sharedAccessSort.equals("write write shared access")) {
            return this.writewriteDefaultValue;
        }
        throw new IllegalArgumentException("sharedAccessSort has to be either IEscapeInfo.WRITE_WRITE_SHARED_ACCESS or IEscapeInfo.READ_WRITE_SHARED_ACCESS but was " + sharedAccessSort);
    }
}

