/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IReadWriteInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.FieldRef;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EscapeAndReadWriteCLI
extends SootBasedDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapeAndReadWriteCLI.class);

    public static void main(String[] args) {
        Options _options = new Options();
        Option _option = new Option("h", "help", false, "Display message.");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("p", "soot-classpath", false, "Prepend this to soot class path.");
        _option.setArgs(1);
        _option.setArgName("classpath");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("S", "scope", true, "The scope that should be analyzed.");
        _option.setArgs(1);
        _option.setArgName("scope");
        _option.setRequired(false);
        _options.addOption(_option);
        GnuParser _parser = new GnuParser();
        try {
            CommandLine _cl = _parser.parse(_options, args);
            if (_cl.hasOption("h")) {
                String _cmdLineSyn = "java " + EscapeAndReadWriteCLI.class.getName() + " <options> <classnames>";
                new HelpFormatter().printHelp(_cmdLineSyn, _options);
                System.exit(1);
            }
            if (_cl.getArgList().isEmpty()) {
                throw new MissingArgumentException("Please specify atleast one class.");
            }
            EscapeAndReadWriteCLI _cli = new EscapeAndReadWriteCLI();
            if (_cl.hasOption('p')) {
                _cli.addToSootClassPath(_cl.getOptionValue('p'));
            }
            if (_cl.hasOption('S')) {
                _cli.setScopeSpecFile(_cl.getOptionValue('S'));
            }
            _cli.setClassNames(_cl.getArgList());
            _cli.execute();
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            System.out.println("Error while parsing command line." + (Object)((Object)_e));
            String _cmdLineSyn = "java " + EscapeAndReadWriteCLI.class.getName() + " <options> <classnames>";
            new HelpFormatter().printHelp(_cmdLineSyn, "Options are:", _options, "");
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    private <T extends ITokens<T, Value>> void execute() {
        this.setInfoLogger(LOGGER);
        IValueAnalyzer _aa = OFAnalyzer.getFSOSAnalyzer("SideEffect:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList<IProcessor> _processors = new ArrayList<IProcessor>();
        Pair.PairManager _pairManager = new Pair.PairManager(false, true);
        CallGraphInfo _cgi = new CallGraphInfo(_pairManager);
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        ThreadGraph _tgi = new ThreadGraph(_cgi, new CFGAnalysis(_cgi, this.getBbm()), _pairManager);
        ValueAnalyzerBasedProcessingController _cgipc = new ValueAnalyzerBasedProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(_aa);
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("SideEffect:FA"));
        _cgipc.setAnalyzer(_aa);
        _cgipc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(_cgi));
        _cgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        HashMap _info = new HashMap();
        _info.put(ICallGraphInfo.ID, (Object)((Object)_cgi));
        _info.put(IThreadGraphInfo.ID, _tgi);
        _info.put(Pair.PairManager.ID, _pairManager);
        _info.put(IEnvironment.ID, _aa.getEnvironment());
        _info.put(IValueAnalyzer.ID, _aa);
        this.initialize();
        _aa.analyze(this.getEnvironment(), this.getRootMethods());
        _processors.clear();
        _processors.add(_callGraphInfoCollector);
        _pc.reset();
        _pc.driveProcessors(_processors);
        _cgi.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
        this.writeInfo("CALL GRAPH:\n" + _cgi.toString());
        _processors.clear();
        _tgi.reset();
        _processors.add(_tgi);
        _cgipc.reset();
        _cgipc.driveProcessors(_processors);
        this.writeInfo("THREAD GRAPH:\n" + _tgi.toString());
        EquivalenceClassBasedEscapeAnalysis _ecba = new EquivalenceClassBasedEscapeAnalysis(_cgi, _tgi, this.getBbm());
        IReadWriteInfo _rwInfo = _ecba.getReadWriteInfo();
        IEscapeInfo _escapeInfo = _ecba.getEscapeInfo();
        AnalysesController _ac = new AnalysesController(_info, _cgipc, this.getBbm());
        _ac.addAnalyses(EquivalenceClassBasedEscapeAnalysis.ID, (Collection<? extends IAnalysis>)Collections.singleton(_ecba));
        _ac.initialize();
        _ac.execute();
        this.writeInfo("END: Escape analysis");
        System.out.println("ReadWrite-Effect and Escape Information:");
        String[] _emptyStringArray = new String[]{};
        for (SootMethod _sm : _cgi.getReachableMethods()) {
            System.out.println("Method: " + _sm.getSignature());
            System.out.println("\tsealed: " + _ecba.isMethodSealed(_sm) + ", atomic: " + _ecba.isMethodAtomic(_sm));
            if (!_sm.isStatic()) {
                System.out.println("\tthis:");
                System.out.println("\t\tread =  " + _rwInfo.isThisBasedAccessPathRead(_sm, _emptyStringArray, true));
                System.out.println("\t\twritten =  " + _rwInfo.isThisBasedAccessPathWritten(_sm, _emptyStringArray, true));
                System.out.println("\t\tescapes = " + _escapeInfo.thisEscapes(_sm));
                System.out.println("\t\tmulti-thread RW = " + _escapeInfo.thisFieldAccessShared(_sm, (Object)"read write shared access"));
                System.out.println("\t\tmulti-thread LU = " + _escapeInfo.thisLockUnlockShared(_sm));
                System.out.println("\t\tmulti-thread WN = " + _escapeInfo.thisWaitNotifyShared(_sm));
                System.out.println("\t\tfield reading threads = " + _escapeInfo.getReadingThreadsOfThis(_sm));
                System.out.println("\t\tfield writing threads = " + _escapeInfo.getWritingThreadsOfThis(_sm));
                for (SootField _field : _sm.getDeclaringClass().getFields()) {
                    if (_field.isStatic()) continue;
                    String[] _accessPath = new String[]{_field.getSignature()};
                    System.out.println("\t\t\t" + _accessPath[0] + ": [read: " + _rwInfo.isThisBasedAccessPathRead(_sm, _accessPath, true) + ", written:" + _rwInfo.isThisBasedAccessPathWritten(_sm, _accessPath, true) + "]");
                }
                System.out.print("\t\tcoupled with parameters at position: ");
                int _k = 0;
                while (_k < _sm.getParameterCount()) {
                    if (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(_sm.getParameterType(_k)) && _rwInfo.canMethodInduceSharingBetweenParamAndThis(_sm, _k)) {
                        System.out.print(String.valueOf(_k) + ", ");
                    }
                    ++_k;
                }
                System.out.println("");
            }
            int _j = 0;
            while (_j < _sm.getParameterCount()) {
                System.out.println("\tParam" + (_j + 1) + "[" + _sm.getParameterType(_j) + "]:");
                System.out.println("\t\tread = " + _rwInfo.isParameterBasedAccessPathRead(_sm, _j, _emptyStringArray, true));
                System.out.println("\t\twritten = " + _rwInfo.isParameterBasedAccessPathWritten(_sm, _j, _emptyStringArray, true));
                System.out.println("\t\tfield reading threads: " + _escapeInfo.getReadingThreadsOf(_j, _sm));
                System.out.println("\t\tfield writing threads: " + _escapeInfo.getWritingThreadsOf(_j, _sm));
                System.out.print("\t\tcoupled with parameters at position: ");
                int _k = 0;
                while (_k < _sm.getParameterCount()) {
                    if (_k != _j && EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(_sm.getParameterType(_k)) && EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(_sm.getParameterType(_j)) && _rwInfo.canMethodInduceSharingBetweenParams(_sm, _j, _k)) {
                        System.out.print(String.valueOf(_k) + ", ");
                    }
                    ++_k;
                }
                System.out.println("");
                ++_j;
            }
            if (!_sm.hasActiveBody()) continue;
            Body _body = _sm.getActiveBody();
            for (Local _local : _body.getLocals()) {
                System.out.println("\tLocal " + _local.getName() + "[" + _local.getType() + "] : ");
                System.out.println("\t\tescapes = " + _escapeInfo.escapes((Value)_local, _sm));
                System.out.println("\t\tshared RW = " + _escapeInfo.fieldAccessShared((Value)_local, _sm, (Object)"read write shared access"));
                System.out.println("\t\tshared WW = " + _escapeInfo.fieldAccessShared((Value)_local, _sm, (Object)"write write shared access"));
                System.out.println("\t\tlocking = " + _escapeInfo.lockUnlockShared((Value)_local, _sm));
                System.out.println("\t\twaitNotify  = " + _escapeInfo.waitNotifyShared((Value)_local, _sm));
                System.out.println("\t\tfield reading threads: " + _escapeInfo.getReadingThreadsOf(_local, _sm));
                System.out.println("\t\tfield writing threads: " + _escapeInfo.getWritingThreadsOf(_local, _sm));
            }
            for (Stmt _stmt : _body.getUnits()) {
                FieldRef _fr;
                SootField _field;
                if (!_stmt.containsFieldRef() || !(_field = (_fr = _stmt.getFieldRef()).getField()).isStatic()) continue;
                System.out.println("\tStatic " + _field.getSignature() + " : ");
                System.out.println("\t\tshared RW = " + _escapeInfo.staticfieldAccessShared(_field.getDeclaringClass(), _sm, _field.getSignature(), (Object)"read write shared access"));
                System.out.println("\t\tshared WW = " + _escapeInfo.staticfieldAccessShared(_field.getDeclaringClass(), _sm, _field.getSignature(), (Object)"write write shared access"));
            }
        }
    }
}

