/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.datastructures.FastUnionFindElement;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IReadWriteInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EscapeInfo;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.MethodContext;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.ReadWriteInfo;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.StmtProcessor;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.ValueProcessor;
import edu.ksu.cis.indus.staticanalyses.interfaces.AbstractAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.ParameterRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EquivalenceClassBasedEscapeAnalysis
extends AbstractAnalysis {
    public static final Comparable<?> ID = "equivalence class based escape analysis";
    static final Logger LOGGER = LoggerFactory.getLogger(EquivalenceClassBasedEscapeAnalysis.class);
    final BasicBlockGraphMgr bbm;
    final CFGAnalysis cfgAnalysis;
    final ICallGraphInfo cgi;
    final Map<SootClass, AliasSet> class2aliasSet;
    final Context context;
    Map<Local, AliasSet> localASsCache;
    final Map<SootMethod, Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>>> method2Triple;
    MethodContext methodCtxtCache;
    final Map<Pair<AliasSet, String[]>, AliasSet> query2handle = new WeakHashMap<Pair<AliasSet, String[]>, AliasSet>();
    Map<ICallGraphInfo.CallTriple, MethodContext> scCache;
    final StmtProcessor stmtProcessor;
    final IThreadGraphInfo tgi;
    final ValueProcessor valueProcessor;
    private final EscapeInfo escapeInfo;
    private boolean multiThreadedSystem;
    private final ReadWriteInfo objectReadWriteInfo;

    public EquivalenceClassBasedEscapeAnalysis(ICallGraphInfo callgraph, IThreadGraphInfo threadgraph, BasicBlockGraphMgr basicBlockGraphMgr) {
        this.cgi = callgraph;
        this.tgi = threadgraph;
        this.class2aliasSet = new HashMap<SootClass, AliasSet>();
        this.method2Triple = new HashMap<SootMethod, Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>>>();
        this.stmtProcessor = new StmtProcessor(this);
        this.valueProcessor = new ValueProcessor(this);
        this.bbm = basicBlockGraphMgr;
        this.context = new Context();
        this.cfgAnalysis = new CFGAnalysis(this.cgi, this.bbm);
        this.escapeInfo = new EscapeInfo(this);
        this.objectReadWriteInfo = new ReadWriteInfo(this);
    }

    public static boolean canHaveAliasSet(Type type) {
        return type instanceof RefType || type instanceof ArrayType;
    }

    @Override
    public void analyze() {
        this.unstable();
        this.escapeInfo.unstableAdapter();
        this.objectReadWriteInfo.unstableAdapter();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Equivalence Class-based and Symbol-based Escape Analysis");
        }
        this.multiThreadedSystem = false;
        ArrayList<List<SootMethod>> _sccs = new ArrayList<List<SootMethod>>(this.cgi.getSCCs(false));
        this.performPhase2(_sccs);
        Collections.reverse(_sccs);
        this.performPhase3(_sccs);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("analyze() - " + this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Equivalence Class-based and Symbol-based Escape Analysis");
        }
        this.processGlobalAliasSets();
        this.processMethodsForAccessToGlobalData();
        this.stable();
        this.escapeInfo.stableAdapter();
        this.objectReadWriteInfo.stableAdapter();
    }

    public void flushSiteContexts() {
        for (SootMethod _sm : this.cgi.getReachableMethods()) {
            Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.method2Triple.get(_sm);
            this.method2Triple.put(_sm, (Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>>)new Triple((Object)((MethodContext)_triple.getFirst()), (Object)((Map)_triple.getSecond()), null));
        }
    }

    public IEscapeInfo getEscapeInfo() {
        return this.escapeInfo;
    }

    public IReadWriteInfo getReadWriteInfo() {
        return this.objectReadWriteInfo;
    }

    public boolean isMethodAtomic(SootMethod sm) {
        MethodContext _m = (MethodContext)this.getMethodInfo(sm).getFirst();
        boolean _result = _m.getThrownAS().isSharedDataReachable();
        if (!_result && _m.getThisAS() != null) {
            _result |= _m.getThisAS().isSharedDataReachable();
        }
        if (!_result && _m.getReturnAS() != null) {
            _result |= _m.getReturnAS().isSharedDataReachable();
        }
        int _iEnd = sm.getParameterCount();
        int _i = 0;
        while (_i < _iEnd && !_result) {
            AliasSet _arg = _m.getParamAS(_i);
            if (_arg != null) {
                _result |= _arg.isSharedDataReachable();
            }
            ++_i;
        }
        if (!_result) {
            for (AliasSet _as : ((Map)this.method2Triple.get(sm).getSecond()).values()) {
                if (_as == null) continue;
                _result |= _as.isSharedDataReachable();
            }
        }
        return !_result;
    }

    public boolean isMethodSealed(SootMethod sm) {
        MethodContext _m = (MethodContext)this.getMethodInfo(sm).getFirst();
        boolean _result = this.isMethodAtomic(sm);
        if (!_result) {
            boolean _r = _m.getThrownAS().isGlobalDataReachable();
            if (!_r && _m.getThisAS() != null) {
                _r |= _m.getThisAS().isGlobalDataReachable();
            }
            if (!_r && _m.getReturnAS() != null) {
                _r |= _m.getReturnAS().isGlobalDataReachable();
            }
            int _iEnd = sm.getParameterCount();
            int _i = 0;
            while (_i < _iEnd && !_r) {
                AliasSet _arg = _m.getParamAS(_i);
                if (_arg != null) {
                    _r |= _arg.isGlobalDataReachable();
                }
                ++_i;
            }
            if (!_r) {
                for (AliasSet _as : ((Map)this.method2Triple.get(sm).getSecond()).values()) {
                    if (_as == null) continue;
                    _r |= _as.isGlobalDataReachable();
                }
            }
            _result = !_r;
        }
        return _result;
    }

    @Override
    public void reset() {
        super.reset();
        this.class2aliasSet.clear();
        this.method2Triple.clear();
        this.valueProcessor.reset();
    }

    public void setEscapesDefaultValue(boolean value) {
        this.escapeInfo.escapesDefaultValue = value;
    }

    public void setReadDefaultValue(boolean value) {
        this.objectReadWriteInfo.readDefaultValue = value;
    }

    public void setWriteDefaultValue(boolean value) {
        this.objectReadWriteInfo.writeDefaultValue = value;
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("\n");
        Set<Map.Entry<SootMethod, Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>>>> _entrySet1 = this.method2Triple.entrySet();
        Iterator<Map.Entry<SootMethod, Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>>>> _i = _entrySet1.iterator();
        int _iEnd = _entrySet1.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Map.Entry<SootMethod, Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>>> _entry1 = _i.next();
            _result.append(_entry1.getKey());
            _result.append(":\n");
            Map _local2AS = (Map)_entry1.getValue().getSecond();
            _result.append(_local2AS.toString());
            _result.append("\n");
            ++_iIndex;
        }
        return _result.toString();
    }

    AliasSet getASForClass(SootClass declaringClass) {
        AliasSet _result = this.class2aliasSet.get(declaringClass);
        if (_result == null) {
            _result = AliasSet.getASForType((Type)declaringClass.getType());
            this.class2aliasSet.put(declaringClass, _result);
        }
        return _result;
    }

    AliasSet getCalleeSideAliasSet(AliasSet ref, SootMethod callee, ICallGraphInfo.CallTriple site) {
        if (this.class2aliasSet.containsValue(ref.find())) {
            return ref;
        }
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.method2Triple.get(site.getMethod());
        Map _callsite2mc = (Map)_triple.getThird();
        MethodContext _callingContext = (MethodContext)_callsite2mc.get(site);
        MethodContext _calleeContext = (MethodContext)this.method2Triple.get(callee).getFirst();
        return _callingContext.getImageOfRefInGivenContext(ref, _calleeContext);
    }

    AliasSet getCallerSideAliasSet(AliasSet ref, SootMethod callee, ICallGraphInfo.CallTriple site) {
        if (this.class2aliasSet.containsValue(ref.find())) {
            return ref;
        }
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.method2Triple.get(site.getMethod());
        Map _callsite2mc = (Map)_triple.getThird();
        MethodContext _callingContext = (MethodContext)_callsite2mc.get(site);
        MethodContext _calleeContext = (MethodContext)this.method2Triple.get(callee).getFirst();
        return _calleeContext.getImageOfRefInGivenContext(ref, _callingContext);
    }

    Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> getMethodInfo(SootMethod method) {
        Triple _triple;
        if (this.method2Triple.containsKey(method)) {
            _triple = this.method2Triple.get(method);
        } else {
            MethodContext _methodContext = new MethodContext(method, this);
            _triple = new Triple((Object)_methodContext, new HashMap(), new HashMap());
            this.method2Triple.put(method, (Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>>)_triple);
        }
        return _triple;
    }

    void markMultiThreadedSystem() {
        this.multiThreadedSystem = true;
    }

    AliasSet queryAliasSetFor(SootClass sc) {
        return this.class2aliasSet.get(sc);
    }

    AliasSet queryAliasSetFor(Value v, SootMethod sm) {
        AliasSet _result;
        Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _trp;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN - queryAliasSetFor(v = " + v.getClass() + ", sm = " + sm + ")");
        }
        if ((_trp = this.method2Triple.get(sm)) == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Non-existent method triple for " + sm);
            }
            _result = null;
        } else {
            Map _local2AS = (Map)_trp.getSecond();
            if (v instanceof InstanceFieldRef) {
                InstanceFieldRef _i = (InstanceFieldRef)v;
                AliasSet _temp = (AliasSet)_local2AS.get(_i.getBase());
                _result = _temp.getASForField(_i.getField().getSignature());
            } else if (v instanceof StaticFieldRef) {
                SootField _field = ((StaticFieldRef)v).getField();
                AliasSet _base = this.getASForClass(_field.getDeclaringClass());
                _result = _base.getASForField(_field.getSignature());
            } else if (v instanceof ArrayRef) {
                ArrayRef _a = (ArrayRef)v;
                AliasSet _temp = (AliasSet)_local2AS.get(_a.getBase());
                _result = _temp.getASForField("$ELT");
            } else if (v instanceof Local) {
                _result = (AliasSet)_local2AS.get(v);
            } else if (v instanceof ThisRef) {
                _result = ((MethodContext)_trp.getFirst()).getThisAS();
            } else if (v instanceof ParameterRef) {
                _result = ((MethodContext)_trp.getFirst()).getParamAS(((ParameterRef)v).getIndex());
            } else {
                if (v instanceof CaughtExceptionRef) {
                    LOGGER.error("CaughtExceptionRef cannot be handled.");
                    throw new IllegalArgumentException("CaughtExceptionRef cannot be handled.");
                }
                _result = null;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END - queryAliasSetFor(Value, SootMethod): " + _result);
        }
        return _result;
    }

    AliasSet queryAliasSetForThis(SootMethod method) {
        return ((MethodContext)this.method2Triple.get((Object)method).getFirst()).thisAS;
    }

    void validate(int paramPos, SootMethod method) throws IllegalArgumentException {
        if (paramPos >= method.getParameterCount()) {
            throw new IllegalArgumentException(method + " has " + method.getParameterCount() + " arguments, but " + paramPos + " was provided.");
        }
    }

    void validate(SootMethod method) throws IllegalArgumentException {
        if (method.isStatic()) {
            throw new IllegalArgumentException("The provided method should be non-static.");
        }
    }

    private void discardReferentialAliasSets(SootMethod method) {
        if (this.localASsCache.isEmpty()) {
            this.localASsCache = Collections.emptyMap();
        } else {
            for (Map.Entry<Local, AliasSet> entry : this.localASsCache.entrySet()) {
                AliasSet _as = entry.getValue();
                AliasSet _equiv = (AliasSet)_as.find();
                if (_equiv == _as) continue;
                entry.setValue(_equiv);
            }
        }
        if (this.scCache.isEmpty()) {
            this.scCache = Collections.emptyMap();
        } else {
            for (Map.Entry<Object, FastUnionFindElement> entry : this.scCache.entrySet()) {
                MethodContext _mc = (MethodContext)entry.getValue();
                MethodContext _mcRep = (MethodContext)_mc.find();
                if (_mcRep != _mc) {
                    entry.setValue(_mcRep);
                }
                _mcRep.discardReferentialAliasSets();
            }
        }
        this.methodCtxtCache.discardReferentialAliasSets();
        this.methodCtxtCache.find();
        this.method2Triple.put(method, (Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>>)new Triple((Object)this.methodCtxtCache, this.localASsCache, this.scCache));
    }

    private void performPhase2(List<List<SootMethod>> sccsInBottomUpOrder) {
        HashSet _processed = new HashSet();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_processed);
        for (List<SootMethod> _nodes : sccsInBottomUpOrder) {
            for (SootMethod _sm : _nodes) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Bottom-up processing method " + _sm);
                }
                Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _triple = this.getMethodInfo(_sm);
                if (!_sm.isConcrete()) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("NO BODY: " + _sm.getSignature());
                    continue;
                }
                this.methodCtxtCache = (MethodContext)_triple.getFirst();
                this.localASsCache = (Map)_triple.getSecond();
                this.scCache = (Map)_triple.getThird();
                this.context.setRootMethod(_sm);
                BasicBlockGraph _bbg = this.bbm.getBasicBlockGraph(_sm);
                _wb.clear();
                _processed.clear();
                _wb.addWork((Object)_bbg.getHead());
                while (_wb.hasWork()) {
                    BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_wb.getWork();
                    for (Stmt _stmt : _bb.getStmtsOf()) {
                        this.context.setStmt(_stmt);
                        this.stmtProcessor.process(_stmt);
                    }
                    _wb.addAllWorkNoDuplicates(_bb.getSuccsOf());
                }
                this.discardReferentialAliasSets(_sm);
            }
        }
        if (this.multiThreadedSystem) {
            for (AliasSet _as : this.class2aliasSet.values()) {
                _as.markAsCrossingThreadBoundary();
                AliasSet.selfUnify(_as);
            }
        }
    }

    private void performPhase3(List<List<SootMethod>> sccsInTopDownOrder) {
        for (List<SootMethod> _nodes : sccsInTopDownOrder) {
            for (SootMethod _caller : _nodes) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Top-down processing method : CALLER : " + _caller);
                }
                Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _callerTriple = this.method2Triple.get(_caller);
                Map _ctrp2sc = (Map)_callerTriple.getThird();
                Collection _callees = this.cgi.getCallees(_caller);
                for (ICallGraphInfo.CallTriple _ctrp : _callees) {
                    SootMethod _callee = _ctrp.getMethod();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Top-down processing : CALLEE : " + _callee);
                    }
                    Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _calleeTriple = this.method2Triple.get(_callee);
                    MethodContext _calleeMethodContext = (MethodContext)_calleeTriple.getFirst();
                    ICallGraphInfo.CallTriple _callerTrp = new ICallGraphInfo.CallTriple(_caller, _ctrp.getStmt(), _ctrp.getExpr());
                    MethodContext _calleeSiteContext = (MethodContext)_ctrp2sc.get(_callerTrp);
                    _calleeSiteContext.propogateInfoFromTo(_calleeMethodContext);
                }
            }
        }
    }

    private void processGlobalAliasSets() {
        HashSet _proc = new HashSet();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_proc);
        for (AliasSet _as : this.class2aliasSet.values()) {
            _wb.clear();
            _proc.clear();
            _wb.addWork((Object)((AliasSet)_as.find()));
            while (_wb.hasWork()) {
                AliasSet _a = (AliasSet)_wb.getWork();
                _a.setGlobal();
                for (AliasSet _fs : _a.getFieldMap().values()) {
                    _wb.addWork((Object)((AliasSet)_fs.find()));
                }
            }
        }
    }

    private void processMethodsForAccessToGlobalData() {
        HashSet _proc = new HashSet();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_proc);
        for (SootMethod _sm : this.method2Triple.keySet()) {
            Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _t = this.method2Triple.get(_sm);
            MethodContext _m = (MethodContext)_t.getFirst();
            _wb.clear();
            _proc.clear();
            if (_m.getThisAS() != null) {
                _wb.addWork((Object)_m.getThisAS());
            }
            if (_m.getReturnAS() != null) {
                _wb.addWork((Object)_m.getReturnAS());
            }
            int _iEnd = _sm.getParameterCount();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                AliasSet _arg = _m.getParamAS(_iIndex);
                if (_arg != null) {
                    _wb.addWork((Object)_arg);
                }
                ++_iIndex;
            }
            _wb.addWork((Object)_m.getThrownAS());
            for (AliasSet _as : ((Map)this.method2Triple.get(_sm).getSecond()).values()) {
                if (_as == null) continue;
                _wb.addWork((Object)_as);
            }
            boolean _read = _m.isGlobalDataRead();
            boolean _written = _m.isGlobalDataWritten();
            while (!(!_wb.hasWork() || _read && _written)) {
                AliasSet _a = (AliasSet)_wb.getWork();
                if (_a.isGlobal()) {
                    _read |= _a.wasAnyFieldRead();
                    _written |= _a.wasAnyFieldWritten();
                }
                for (AliasSet _fs : _a.getFieldMap().values()) {
                    _wb.addWork((Object)((AliasSet)_fs.find()));
                }
            }
            if (_read) {
                _m.globalDataWasRead();
            }
            if (!_written) continue;
            _m.globalDataWasWritten();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArgParamAliasSetRetriever
    implements ITransformer<MethodContext, AliasSet> {
        private final int position;

        ArgParamAliasSetRetriever(int pos) {
            this.position = pos;
        }

        public AliasSet transform(MethodContext input) {
            return input.getParamAS(this.position);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SiteContextRetriever
    implements ITransformer<SootMethod, MethodContext> {
        final ICallGraphInfo.CallTriple callerTriple;

        SiteContextRetriever(ICallGraphInfo.CallTriple triple) {
            this.callerTriple = triple;
        }

        public MethodContext transform(SootMethod input) {
            Triple<MethodContext, Map<Local, AliasSet>, Map<ICallGraphInfo.CallTriple, MethodContext>> _t = EquivalenceClassBasedEscapeAnalysis.this.method2Triple.get(input);
            return _t != null ? (MethodContext)((Map)_t.getThird()).get(this.callerTriple) : null;
        }
    }
}

