/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.AbstractCallingContextRetriever;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.impl.DataAliasBasedCallingContextRetriever;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAliasBasedCallingContextRetrieverV2
extends DataAliasBasedCallingContextRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAliasBasedCallingContextRetrieverV2.class);
    protected EquivalenceClassBasedEscapeAnalysis ecba;

    public DataAliasBasedCallingContextRetrieverV2(int callingContextLengthLimit) {
        super(callingContextLengthLimit);
    }

    public void setECBA(EquivalenceClassBasedEscapeAnalysis oracle) {
        this.ecba = oracle;
    }

    @Override
    protected final boolean considerProgramPoint(Context programPointContext) {
        boolean _result;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("considerProgramPoint(Context programPointContext = " + programPointContext + ") - BEGIN");
        }
        if (_result = super.considerProgramPoint(programPointContext)) {
            Value _value = programPointContext.getProgramPoint().getValue();
            AliasSet _as = this.ecba.queryAliasSetFor(_value, programPointContext.getCurrentMethod());
            if (_as != null) {
                Collection<Object> _o = _as.getIntraProcRefEntities();
                if (_o != null) {
                    _result = this.shouldConsiderCallerSideToken(_o);
                }
            } else {
                boolean bl = _result = !EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(_value.getType());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("considerProgramPoint() - END - return value = " + _result);
        }
        return _result;
    }

    @Override
    protected Object getCallerSideToken(Object token, SootMethod callee, ICallGraphInfo.CallTriple callsite, Stack<ICallGraphInfo.CallTriple> calleeCallStack) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getCallerSideToken(Object token = " + token + ", SootMethod callee = " + callee + ", CallTriple callsite = " + callsite + ") - BEGIN");
        }
        Object _result = AbstractCallingContextRetriever.Tokens.DISCARD_CONTEXT_TOKEN;
        if (!Util.isStartMethod((SootMethod)callee)) {
            AliasSet _as = this.ecba.getCallerSideAliasSet((AliasSet)token, callee, callsite);
            if (_as != null) {
                Collection<Object> _c1 = ((AliasSet)token).getIntraProcRefEntities();
                Collection<Object> _c2 = _as.getIntraProcRefEntities();
                if (_c1 != null && _c2 != null && CollectionUtils.containsAny(_c1, _c2) && this.shouldConsiderCallerSideToken(_c2) && this.getCallSitesThatCanReachSource(callsite, true)) {
                    _result = _as;
                }
            } else {
                _result = AbstractCallingContextRetriever.Tokens.ACCEPT_TERMINAL_CONTEXT_TOKEN;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getCallerSideToken() - END - return value = " + _result);
        }
        return _result;
    }

    @Override
    protected Object getTokenForProgramPoint(Context programPointContext) {
        Value _value;
        AliasSet _as;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTokenForProgramPoint(Context programPointContext = " + programPointContext + ") - BEGIN");
        }
        AliasSet _result = (_as = this.ecba.queryAliasSetFor(_value = programPointContext.getProgramPoint().getValue(), programPointContext.getCurrentMethod())) != null ? _as : (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(_value.getType()) ? AbstractCallingContextRetriever.Tokens.DISCARD_CONTEXT_TOKEN : AbstractCallingContextRetriever.Tokens.CONSIDER_ALL_CONTEXTS_TOKEN);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTokenForProgramPoint() - END - return value = " + _result);
        }
        return _result;
    }

    protected boolean shouldConsiderCallerSideToken(Collection<Object> callerSideEntities) {
        return !callerSideEntities.isEmpty();
    }
}

