/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.FastUnionFindElement;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.InvokeStmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AliasSet
extends FastUnionFindElement<AliasSet>
implements Cloneable {
    private static int lockEntityCount;
    private static long readyEntityCount;
    private static int referenceEntityCount;
    private static final ITransformer<AliasSet, AliasSet> REPRESENTATIVE_ALIAS_SET_RETRIEVER;
    private static int shareEntityCount;
    private boolean accessed = false;
    private Map<String, AliasSet> fieldMap = new HashMap<String, AliasSet>();
    private boolean global;
    private Collection<Object> intraThreadInterProcRefEntities = null;
    private boolean locked;
    private Collection<Object> lockEntities = null;
    private boolean multiThreadAccessibility = false;
    private boolean notifies;
    private Collection<String> readFields;
    private Collection<Triple<InvokeStmt, SootMethod, SootClass>> readThreads = new HashSet<Triple<InvokeStmt, SootMethod, SootClass>>();
    private Collection<Object> readwriteEntities = null;
    private Collection<Object> readyEntities = null;
    private Collection<String> sigsOfRWSharedFields = null;
    private Collection<String> sigsOfWWSharedFields = null;
    private boolean stringifying;
    private boolean waits;
    private Collection<Triple<InvokeStmt, SootMethod, SootClass>> writeThreads = new HashSet<Triple<InvokeStmt, SootMethod, SootClass>>();
    private Collection<Object> writewriteEntities = null;
    private Collection<String> writtenFields;

    static {
        REPRESENTATIVE_ALIAS_SET_RETRIEVER = new ITransformer<AliasSet, AliasSet>(){

            public AliasSet transform(AliasSet input) {
                return (AliasSet)input.find();
            }
        };
    }

    private AliasSet() {
        this.readFields = Collections.emptySet();
        this.writtenFields = Collections.emptySet();
    }

    static AliasSet createAliasSet() {
        return new AliasSet();
    }

    static AliasSet getASForType(Type type) {
        AliasSet _result = null;
        if (EquivalenceClassBasedEscapeAnalysis.canHaveAliasSet(type)) {
            _result = new AliasSet();
        }
        return _result;
    }

    static void selfUnify(AliasSet as) {
        HashSet _processed = new HashSet();
        HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(_processed);
        _wb.addWork((Object)((AliasSet)as.find()));
        while (_wb.hasWork()) {
            AliasSet _repr = (AliasSet)_wb.getWork();
            _repr.unifyThreadEscapeInfo(_repr);
            _wb.addAllWorkNoDuplicates((Collection)CollectionUtils.collect(_repr.fieldMap.values(), REPRESENTATIVE_ALIAS_SET_RETRIEVER));
        }
    }

    private static Object getNewLockEntity() {
        return "LockEntity:" + lockEntityCount++;
    }

    private static Object getNewReadyEntity() {
        return "ReadyEntity:" + readyEntityCount++;
    }

    private static Object getNewReferenceEntity() {
        return "ReferenceEntity:" + referenceEntityCount++;
    }

    private static Object getNewShareEntity() {
        return "ShareEntity:" + shareEntityCount++;
    }

    public AliasSet clone() throws CloneNotSupportedException {
        AliasSet _result;
        if (this.find() != this) {
            _result = ((AliasSet)this.find()).clone();
        } else {
            AliasSet _clone = (AliasSet)super.clone();
            _clone.fieldMap = (Map)((HashMap)this.fieldMap).clone();
            _clone.fieldMap.clear();
            if (this.readyEntities != null) {
                _clone.readyEntities = (Collection)((HashSet)this.readyEntities).clone();
            }
            if (this.readwriteEntities != null) {
                _clone.readwriteEntities = (Collection)((HashSet)this.readwriteEntities).clone();
            }
            if (this.writewriteEntities != null) {
                _clone.writewriteEntities = (Collection)((HashSet)this.writewriteEntities).clone();
            }
            _clone.intraThreadInterProcRefEntities = null;
            Collection _emptySet = Collections.emptySet();
            if (this.readFields != _emptySet) {
                _clone.readFields = (Collection)((HashSet)this.readFields).clone();
            }
            if (this.writtenFields != _emptySet) {
                _clone.writtenFields = (Collection)((HashSet)this.writtenFields).clone();
            }
            _clone.readThreads = new HashSet<Triple<InvokeStmt, SootMethod, SootClass>>(this.readThreads);
            _clone.writeThreads = new HashSet<Triple<InvokeStmt, SootMethod, SootClass>>(this.writeThreads);
            _clone.set = null;
            _result = _clone;
        }
        return _result;
    }

    public boolean equals(Object obj) {
        AliasSet _a;
        boolean _result = obj instanceof AliasSet ? (_a = (AliasSet)obj).find() == this.find() : super.equals(obj);
        return _result;
    }

    public int hashCode() {
        int _result = this.find() != this ? ((AliasSet)this.find()).hashCode() : super.hashCode();
        return _result;
    }

    public String toString() {
        String _result;
        if (this.find() != this) {
            _result = ((AliasSet)this.find()).toString();
        } else if (this.stringifying) {
            _result = Integer.toHexString(this.hashCode());
        } else {
            this.stringifying = true;
            _result = new ToStringBuilder((Object)this).append("multiThreadAccess", this.multiThreadAccessibility).append("accessed", this.accessed).append("notifies", this.notifies).append("waits", this.waits).append("locked", this.locked).append("writtenFields", this.writtenFields).append("readFields", this.readFields).append("readyEntities", this.readyEntities).append("lockEntities", this.lockEntities).append("rwEntities", this.readwriteEntities).append("wwEntities", this.writewriteEntities).append("intraProcRefEntities", this.intraThreadInterProcRefEntities).append("sigsOfSharedFields", this.sigsOfRWSharedFields).append("sigsOfWriteWriteSharedFields", this.sigsOfWWSharedFields).append("readThreads", this.readThreads).append("writeThreads", this.writeThreads).append("fieldMap", this.fieldMap).toString();
            this.stringifying = false;
        }
        return _result;
    }

    void addReadField(String fieldSig) {
        AliasSet _l = (AliasSet)this.find();
        Collection _emptySet = Collections.emptySet();
        if (_l.readFields == _emptySet) {
            _l.readFields = new HashSet<String>();
        }
        _l.readFields.add(fieldSig);
    }

    void addReadThreads(Collection<Triple<InvokeStmt, SootMethod, SootClass>> abstractThreads) {
        ((AliasSet)this.find()).readThreads.addAll(abstractThreads);
    }

    void addWriteThreads(Collection<Triple<InvokeStmt, SootMethod, SootClass>> abstractThreads) {
        ((AliasSet)this.find()).writeThreads.addAll(abstractThreads);
    }

    void addWrittenField(String fieldSig) {
        AliasSet _l = (AliasSet)this.find();
        Collection _emptySet = Collections.emptySet();
        if (_l.writtenFields == _emptySet) {
            _l.writtenFields = new HashSet<String>();
        }
        _l.writtenFields.add(fieldSig);
    }

    void eraseIntraThreadInterProcRefEntities() {
        if (this.intraThreadInterProcRefEntities != null) {
            this.intraThreadInterProcRefEntities.clear();
        }
    }

    boolean escapes() {
        return ((AliasSet)this.find()).multiThreadAccessibility;
    }

    AliasSet getAccessPathEndPoint(String[] accesspath) {
        AliasSet _result = this;
        String[] stringArray = accesspath;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String _pathElement = stringArray[n];
            AliasSet _as = _result.getFieldMap().get(_pathElement);
            if (_as == null) {
                _result = null;
                break;
            }
            _result = (AliasSet)_as.find();
            ++n;
        }
        return _result;
    }

    AliasSet getASForField(String field) {
        return ((AliasSet)this.find()).fieldMap.get(field);
    }

    Map<String, AliasSet> getFieldMap() {
        return Collections.unmodifiableMap(((AliasSet)this.find()).fieldMap);
    }

    AliasSet getImageOfRefUnderRoot(AliasSet root, AliasSet ref, Collection<Pair<AliasSet, AliasSet>> processed) {
        AliasSet _result = null;
        if (ref.find() == this.find()) {
            _result = root;
        } else {
            processed.add((Pair<AliasSet, AliasSet>)new Pair((Object)((AliasSet)this.find()), (Object)((AliasSet)root.find())));
            Set<String> _keySet = this.getFieldMap().keySet();
            Iterator<String> _i = _keySet.iterator();
            int _iEnd = _keySet.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd && _result == null) {
                Pair _pair;
                String _key = _i.next();
                AliasSet _as1 = this.getASForField(_key);
                AliasSet _as2 = root.getASForField(_key);
                if (_as1 != null && _as2 != null && !processed.contains(_pair = new Pair((Object)((AliasSet)_as1.find()), (Object)((AliasSet)_as2.find())))) {
                    _result = _as1.getImageOfRefUnderRoot(_as2, ref, processed);
                }
                ++_iIndex;
            }
        }
        return _result;
    }

    Collection<Object> getIntraProcRefEntities() {
        Collection<Object> _collection = ((AliasSet)this.find()).intraThreadInterProcRefEntities;
        Collection<Object> _result = _collection != null ? Collections.unmodifiableCollection(_collection) : null;
        return _result;
    }

    Collection<Object> getLockEntities() {
        Collection<Object> _collection = ((AliasSet)this.find()).lockEntities;
        Collection<Object> _result = _collection != null ? Collections.unmodifiableCollection(_collection) : null;
        return _result;
    }

    Collection<Triple<InvokeStmt, SootMethod, SootClass>> getReadThreads() {
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _collection = ((AliasSet)this.find()).readThreads;
        Collection _result = _collection != null ? Collections.unmodifiableCollection(_collection) : (Collection)Collections.emptySet();
        return _result;
    }

    Collection<Object> getReadWriteShareEntities() {
        Collection<Object> _collection = ((AliasSet)this.find()).readwriteEntities;
        Collection<Object> _result = _collection != null ? Collections.unmodifiableCollection(_collection) : null;
        return _result;
    }

    Collection<Object> getReadyEntities() {
        Collection<Object> _collection = ((AliasSet)this.find()).readyEntities;
        Collection<Object> _result = _collection != null ? Collections.unmodifiableCollection(_collection) : null;
        return _result;
    }

    Collection<Triple<InvokeStmt, SootMethod, SootClass>> getWriteThreads() {
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _collection = ((AliasSet)this.find()).writeThreads;
        Collection _result = _collection != null ? Collections.unmodifiableCollection(_collection) : (Collection)Collections.emptySet();
        return _result;
    }

    Collection<Object> getWriteWriteShareEntities() {
        Collection<Object> _collection = ((AliasSet)this.find()).writewriteEntities;
        Collection<Object> _result = _collection != null ? Collections.unmodifiableCollection(_collection) : null;
        return _result;
    }

    boolean isAccessed() {
        return ((AliasSet)this.find()).accessed;
    }

    boolean isGlobal() {
        return ((AliasSet)this.find()).global;
    }

    boolean isGlobalDataReachable() {
        boolean _result = false;
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(new HashSet());
        _wb.addWork((Object)((AliasSet)this.find()));
        while (!_result && _wb.hasWork()) {
            AliasSet _a = (AliasSet)_wb.getWork();
            _result |= _a.isGlobal();
            for (AliasSet _fs : _a.getFieldMap().values()) {
                _wb.addWork((Object)((AliasSet)_fs.find()));
            }
        }
        return _result;
    }

    boolean isSharedDataReachable() {
        boolean _result = false;
        HistoryAwareLIFOWorkBag _process = new HistoryAwareLIFOWorkBag(new HashSet());
        _process.addWork((Object)((AliasSet)this.find()));
        while (_process.hasWork() && !_result) {
            AliasSet _as = (AliasSet)_process.getWork();
            _result |= _as.multiThreadAccessibility;
            for (AliasSet _fs : _as.getFieldMap().values()) {
                _process.addWork((Object)((AliasSet)_fs.find()));
            }
        }
        return _result;
    }

    boolean lockUnlockShared() {
        AliasSet _rep = (AliasSet)this.find();
        return _rep.lockEntities != null && !_rep.lockEntities.isEmpty();
    }

    void markAsCrossingThreadBoundary() {
        HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(new HashSet());
        _wb.addWork((Object)((AliasSet)this.find()));
        while (_wb.hasWork()) {
            AliasSet _as = (AliasSet)_wb.getWork();
            _as.multiThreadAccessibility = true;
            Iterator<AliasSet> _i = _as.fieldMap.values().iterator();
            while (_i.hasNext()) {
                _wb.addWork((Object)((AliasSet)_i.next().find()));
            }
        }
    }

    boolean methodShared() {
        AliasSet _rep = (AliasSet)this.find();
        return _rep.intraThreadInterProcRefEntities != null && !_rep.intraThreadInterProcRefEntities.isEmpty();
    }

    void propogateInfoFromTo(AliasSet to) {
        HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(new HashSet());
        _wb.addWork((Object)new Pair((Object)this, (Object)to));
        while (_wb.hasWork()) {
            AliasSet _toRep;
            Pair _pair = (Pair)_wb.getWork();
            AliasSet _fromRep = (AliasSet)((AliasSet)_pair.getFirst()).find();
            if (_fromRep == (_toRep = (AliasSet)((AliasSet)_pair.getSecond()).find())) continue;
            _toRep.multiThreadAccessibility |= _fromRep.multiThreadAccessibility;
            if (_fromRep.readyEntities != null) {
                if (_toRep.readyEntities == null) {
                    _toRep.readyEntities = new HashSet<Object>();
                }
                _toRep.readyEntities.addAll(_fromRep.readyEntities);
            }
            if (_fromRep.readwriteEntities != null) {
                if (_toRep.readwriteEntities == null) {
                    _toRep.readwriteEntities = new HashSet<Object>();
                }
                _toRep.readwriteEntities.addAll(_fromRep.readwriteEntities);
            }
            if (_fromRep.writewriteEntities != null) {
                if (_toRep.writewriteEntities == null) {
                    _toRep.writewriteEntities = new HashSet<Object>();
                }
                _toRep.writewriteEntities.addAll(_fromRep.writewriteEntities);
            }
            if (_fromRep.lockEntities != null) {
                if (_toRep.lockEntities == null) {
                    _toRep.lockEntities = new HashSet<Object>();
                }
                _toRep.lockEntities.addAll(_fromRep.lockEntities);
            }
            if (_fromRep.intraThreadInterProcRefEntities != null) {
                if (_toRep.intraThreadInterProcRefEntities == null) {
                    _toRep.intraThreadInterProcRefEntities = new HashSet<Object>();
                }
                _toRep.intraThreadInterProcRefEntities.addAll(_fromRep.intraThreadInterProcRefEntities);
            }
            if (_fromRep.sigsOfRWSharedFields != null) {
                if (_toRep.sigsOfRWSharedFields == null) {
                    _toRep.sigsOfRWSharedFields = new HashSet<String>();
                }
                _toRep.sigsOfRWSharedFields.addAll(_fromRep.sigsOfRWSharedFields);
            }
            if (_fromRep.sigsOfWWSharedFields != null) {
                if (_toRep.sigsOfWWSharedFields == null) {
                    _toRep.sigsOfWWSharedFields = new HashSet<String>();
                }
                _toRep.sigsOfWWSharedFields.addAll(_fromRep.sigsOfWWSharedFields);
            }
            for (String _field : _toRep.getFieldMap().keySet()) {
                AliasSet _to = _toRep.getASForField(_field);
                AliasSet _from = _fromRep.getASForField(_field);
                if (_to == null || _from == null) continue;
                _wb.addWork((Object)new Pair((Object)_from, (Object)_to));
            }
        }
    }

    void putASForField(String field, AliasSet as) {
        ((AliasSet)this.find()).fieldMap.put(field, as);
    }

    boolean readWriteShared() {
        AliasSet _rep = (AliasSet)this.find();
        return _rep.readwriteEntities != null && !_rep.readwriteEntities.isEmpty();
    }

    boolean readWriteShared(String fieldSignature) {
        AliasSet _rep = (AliasSet)this.find();
        return this.readWriteShared() && _rep.sigsOfRWSharedFields.contains(fieldSignature);
    }

    void setAccessed() {
        ((AliasSet)this.find()).accessed = true;
    }

    void setGlobal() {
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(new HashSet());
        _wb.addWork((Object)((AliasSet)this.find()));
        while (_wb.hasWork()) {
            AliasSet _a = (AliasSet)_wb.getWork();
            _a.global = true;
            for (AliasSet _fs : _a.getFieldMap().values()) {
                _wb.addWork((Object)((AliasSet)_fs.find()));
            }
        }
    }

    void setLocked() {
        ((AliasSet)this.find()).locked = true;
    }

    void setNotifies() {
        ((AliasSet)this.find()).notifies = true;
    }

    void setWaits() {
        ((AliasSet)this.find()).waits = true;
    }

    void unifyAliasSet(AliasSet a) {
        this.unifyAliasSetHelper(a, true);
    }

    void unifyAliasSetHelper(AliasSet as2, boolean unifyAll) {
        AliasSet _n;
        AliasSet _m = (AliasSet)this.find();
        if (_m != (_n = (AliasSet)as2.find())) {
            _m.union(_n);
            AliasSet _representative = (AliasSet)_m.find();
            AliasSet _represented = _representative == _m ? _n : _m;
            _representative.waits |= _represented.waits;
            _representative.notifies |= _represented.notifies;
            _representative.multiThreadAccessibility |= _represented.multiThreadAccessibility;
            _representative.locked |= _represented.locked;
            _representative.accessed |= _represented.accessed;
            _representative.readThreads.addAll(_represented.readThreads);
            _represented.readThreads = null;
            _representative.writeThreads.addAll(_represented.writeThreads);
            _represented.writeThreads = null;
            if (unifyAll && _representative.multiThreadAccessibility) {
                _representative.unifyThreadEscapeInfo(_represented);
            }
            _representative.handleInfoUnification(_represented);
            _representative.unifyFields(_represented, unifyAll);
        } else if (unifyAll && _m.multiThreadAccessibility) {
            _m.unifyThreadEscapeInfo(_n);
        }
    }

    boolean waitNotifyShared() {
        AliasSet _rep = (AliasSet)this.find();
        return _rep.readyEntities != null && !_rep.readyEntities.isEmpty();
    }

    boolean wasAnyFieldRead() {
        return !((AliasSet)this.find()).readFields.isEmpty();
    }

    boolean wasAnyFieldWritten() {
        return !((AliasSet)this.find()).writtenFields.isEmpty();
    }

    boolean wasFieldRead(String fieldSig) {
        return ((AliasSet)this.find()).readFields.contains(fieldSig);
    }

    boolean wasFieldRead(String fieldSig, boolean recurse) {
        boolean _result = this.wasFieldRead(fieldSig);
        if (!_result && recurse) {
            _result = this.recursiveBooleanPropertyDiscovery(fieldSig, new ITransformer<AliasSet, Boolean>(){

                public Boolean transform(AliasSet input) {
                    return input.wasAnyFieldRead();
                }
            });
        }
        return _result;
    }

    boolean wasFieldWritten(String fieldSig) {
        return ((AliasSet)this.find()).writtenFields.contains(fieldSig);
    }

    boolean wasFieldWritten(String fieldSig, boolean recurse) {
        boolean _result = this.wasFieldWritten(fieldSig);
        if (!_result && recurse) {
            _result = this.recursiveBooleanPropertyDiscovery(fieldSig, new ITransformer<AliasSet, Boolean>(){

                public Boolean transform(AliasSet input) {
                    return input.wasAnyFieldWritten();
                }
            });
        }
        return _result;
    }

    boolean writeWriteShared() {
        AliasSet _rep = (AliasSet)this.find();
        return _rep.writewriteEntities != null && !_rep.writewriteEntities.isEmpty();
    }

    boolean writeWriteShared(String fieldSignature) {
        AliasSet _rep = (AliasSet)this.find();
        return this.writeWriteShared() && _rep.sigsOfWWSharedFields.contains(fieldSignature);
    }

    private void handleInfoUnification(AliasSet represented) {
        if (this.lockEntities == null) {
            this.lockEntities = represented.lockEntities;
        } else if (represented.lockEntities != null) {
            this.lockEntities.addAll(represented.lockEntities);
        }
        represented.lockEntities = null;
        if (this.intraThreadInterProcRefEntities == null) {
            this.intraThreadInterProcRefEntities = represented.intraThreadInterProcRefEntities;
            if (this.intraThreadInterProcRefEntities == null) {
                this.intraThreadInterProcRefEntities = new HashSet<Object>();
                this.intraThreadInterProcRefEntities.add(AliasSet.getNewReferenceEntity());
            }
        } else if (represented.intraThreadInterProcRefEntities != null) {
            this.intraThreadInterProcRefEntities.addAll(represented.intraThreadInterProcRefEntities);
        }
        represented.intraThreadInterProcRefEntities = null;
        if (this.readyEntities == null) {
            this.readyEntities = represented.readyEntities;
        } else if (represented.readyEntities != null) {
            this.readyEntities.addAll(represented.readyEntities);
        }
        represented.readyEntities = null;
        if (this.readwriteEntities == null) {
            this.readwriteEntities = represented.readwriteEntities;
        } else if (represented.readwriteEntities != null) {
            this.readwriteEntities.addAll(represented.readwriteEntities);
        }
        represented.readwriteEntities = null;
        if (this.writewriteEntities == null) {
            this.writewriteEntities = represented.writewriteEntities;
        } else if (represented.writewriteEntities != null) {
            this.writewriteEntities.addAll(represented.writewriteEntities);
        }
        represented.writewriteEntities = null;
        if (this.sigsOfRWSharedFields == null) {
            this.sigsOfRWSharedFields = represented.sigsOfRWSharedFields;
        } else if (represented.sigsOfRWSharedFields != null) {
            this.sigsOfRWSharedFields.addAll(represented.sigsOfRWSharedFields);
        }
        represented.sigsOfRWSharedFields = null;
        if (this.sigsOfWWSharedFields == null) {
            this.sigsOfWWSharedFields = represented.sigsOfWWSharedFields;
        } else if (represented.sigsOfWWSharedFields != null) {
            this.sigsOfWWSharedFields.addAll(represented.sigsOfWWSharedFields);
        }
        represented.sigsOfWWSharedFields = null;
        Collection _emptySet = Collections.emptySet();
        if (this.readFields == _emptySet) {
            this.readFields = represented.readFields;
        } else {
            this.readFields.addAll(represented.readFields);
        }
        represented.readFields = null;
        if (this.writtenFields == _emptySet) {
            this.writtenFields = represented.writtenFields;
        } else {
            this.writtenFields.addAll(represented.writtenFields);
        }
        represented.writtenFields = null;
    }

    private boolean recursiveBooleanPropertyDiscovery(String fieldSig, ITransformer<AliasSet, Boolean> transformer) {
        boolean _result = false;
        AliasSet _fieldAS = ((AliasSet)this.find()).fieldMap.get(fieldSig);
        if (_fieldAS != null) {
            HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(new HashSet());
            _wb.addWork((Object)_fieldAS);
            while (_wb.hasWork() && !_result) {
                AliasSet _rep = (AliasSet)_wb.getWork();
                if (_result |= ((Boolean)transformer.transform((Object)_rep)).booleanValue()) continue;
                Collection<AliasSet> _values = _rep.getFieldMap().values();
                _wb.addAllWorkNoDuplicates((Collection)CollectionUtils.collect(_values, REPRESENTATIVE_ALIAS_SET_RETRIEVER));
            }
        }
        return _result;
    }

    private void unifyFields(AliasSet aliasSet, boolean unifyAll) {
        for (Map.Entry<String, AliasSet> _entry : aliasSet.fieldMap.entrySet()) {
            String _field = _entry.getKey();
            AliasSet _fieldAS = _entry.getValue();
            AliasSet _repAS = this.getASForField(_field);
            if (_repAS != null) {
                _repAS.unifyAliasSetHelper(_fieldAS, unifyAll);
                continue;
            }
            this.putASForField(_field, _fieldAS);
        }
    }

    private void unifyThreadEscapeInfo(AliasSet represented) {
        if (this.waits && represented.notifies || this.notifies && represented.waits) {
            if (this.readyEntities == null) {
                this.readyEntities = new HashSet<Object>();
            }
            if (this.readyEntities.isEmpty()) {
                if (represented.readyEntities != null && !represented.readyEntities.isEmpty()) {
                    this.readyEntities.addAll(represented.readyEntities);
                } else {
                    this.readyEntities.add(AliasSet.getNewReadyEntity());
                }
            }
        }
        if (this.locked && represented.locked) {
            if (this.lockEntities == null) {
                this.lockEntities = new HashSet<Object>();
            }
            if (this.lockEntities.isEmpty()) {
                if (represented.lockEntities != null && !represented.lockEntities.isEmpty()) {
                    this.lockEntities.addAll(represented.lockEntities);
                } else {
                    this.lockEntities.add(AliasSet.getNewLockEntity());
                }
            }
        }
        if (CollectionUtils.containsAny(this.readFields, represented.writtenFields) || CollectionUtils.containsAny(this.writtenFields, represented.readFields)) {
            if (this.readwriteEntities == null) {
                this.readwriteEntities = new HashSet<Object>();
                this.sigsOfRWSharedFields = new HashSet<String>();
            }
            if (this.readwriteEntities.isEmpty()) {
                if (represented.readwriteEntities != null && !represented.readwriteEntities.isEmpty()) {
                    this.readwriteEntities.addAll(represented.readwriteEntities);
                } else {
                    this.readwriteEntities.add(AliasSet.getNewShareEntity());
                }
            }
            this.sigsOfRWSharedFields.addAll(SetUtils.intersection(this.readFields, represented.writtenFields));
            this.sigsOfRWSharedFields.addAll(SetUtils.intersection(this.writtenFields, represented.readFields));
        }
        if (CollectionUtils.containsAny(this.writtenFields, represented.writtenFields)) {
            if (this.writewriteEntities == null) {
                this.writewriteEntities = new HashSet<Object>();
                this.sigsOfWWSharedFields = new HashSet<String>();
            }
            if (this.writewriteEntities.isEmpty()) {
                if (represented.writewriteEntities != null && !represented.writewriteEntities.isEmpty()) {
                    this.writewriteEntities.addAll(represented.writewriteEntities);
                } else {
                    this.writewriteEntities.add(AliasSet.getNewShareEntity());
                }
            }
            this.sigsOfWWSharedFields.addAll(SetUtils.intersection(this.writtenFields, represented.writtenFields));
        }
    }
}

