/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.graph.AbstractDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.IObjectNode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.SootPredicatesAndTransformers;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.interfaces.AbstractAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeLockAnalysis
extends AbstractAnalysis {
    public static final Comparable<String> ID = "Safe Lock Analysis";
    static final Logger LOGGER = LoggerFactory.getLogger(SafeLockAnalysis.class);
    ICallGraphInfo callgraphInfo;
    IMonitorInfo<? extends IObjectNode<?, Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> monitorInfo;
    Pair.PairManager pairMgr;
    final Map<InvokeStmt, SootMethod> waitStmt2method = new HashMap<InvokeStmt, SootMethod>();
    private IValueAnalyzer<Value> iva;
    private Map<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> monitor2relatedMonitors = new HashMap<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>>(500);
    private final Map<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Pair<InvokeStmt, SootMethod>>> monitor2waits = new HashMap<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Pair<InvokeStmt, SootMethod>>>(500);
    private final Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> unsafeMonitors = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>(500);

    public SafeLockAnalysis() {
        this.preprocessor = new WaitInvocationCollectingProcessor();
    }

    @Override
    public void analyze() {
        this.unstable();
        if (this.monitorInfo.isStable() && this.callgraphInfo.isStable()) {
            IMonitorInfo.IMonitorGraph _monitorGraph = this.monitorInfo.getMonitorGraph(this.callgraphInfo);
            this.processMonitorAndWaitsForLockBasedRelation();
            this.processMonitorsAndWaitsForEnclosureBaseRelation(_monitorGraph);
            Collection _monitors = this.monitorInfo.getMonitorTriples();
            HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _seedUnsafeMonitors = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
            Iterator _i = _monitors.iterator();
            int _iEnd = _monitors.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Triple _monitor = (Triple)_i.next();
                if (!(_seedUnsafeMonitors.contains(_monitor) || this.safeByCondition2((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)_monitor) && this.safeByCondition1((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)_monitor, _monitorGraph))) {
                    _seedUnsafeMonitors.addAll(this.monitorInfo.getMonitorTriplesOf(_monitor));
                }
                ++_iIndex;
            }
            this.propagateSafetyInformation(_seedUnsafeMonitors, _monitorGraph);
            this.stable();
            if (LOGGER.isDebugEnabled()) {
                Collection _safeMonitors = SetUtils.difference((Collection)this.monitorInfo.getMonitorTriples(), this.unsafeMonitors);
                LOGGER.debug("Unsafe Monitors: \n" + CollectionUtils.prettyPrint(this.unsafeMonitors));
                LOGGER.debug("Safe Monitors: \n" + CollectionUtils.prettyPrint((Collection)_safeMonitors));
                Collection _temp = SetUtils.difference((Collection)this.monitorInfo.getMonitorTriples(), (Collection)_safeMonitors);
                _temp.removeAll(this.unsafeMonitors);
                LOGGER.debug("Unaccounted Monitors: \n" + CollectionUtils.prettyPrint((Collection)_temp));
                LOGGER.debug("Overlapping Monitors: \n" + CollectionUtils.prettyPrint((Collection)SetUtils.intersection((Collection)_safeMonitors, this.unsafeMonitors)));
            }
        }
    }

    public boolean isLockSafe(SootMethod method) {
        return !this.unsafeMonitors.contains(new Triple(null, null, (Object)method));
    }

    public boolean isLockSafe(MonitorStmt stmt, SootMethod method) {
        return !CollectionUtils.containsAny(this.unsafeMonitors, (Collection)this.monitorInfo.getMonitorTriplesFor(stmt, method));
    }

    @Override
    public void reset() {
        super.reset();
        this.unsafeMonitors.clear();
        this.monitor2relatedMonitors.clear();
        this.monitor2waits.clear();
        this.waitStmt2method.clear();
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.monitorInfo = (IMonitorInfo)this.info.get(IMonitorInfo.ID);
        if (this.monitorInfo == null) {
            String _msg = "An interface with id, " + IMonitorInfo.ID + ", was not provided.";
            LOGGER.error(_msg);
            throw new InitializationException(_msg);
        }
        this.callgraphInfo = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.monitorInfo == null) {
            String _msg = "An interface with id, " + ICallGraphInfo.ID + ", was not provided.";
            LOGGER.error(_msg);
            throw new InitializationException(_msg);
        }
        this.iva = (IValueAnalyzer)this.info.get(IValueAnalyzer.ID);
        if (this.iva == null) {
            String _msg = "An interface with id, " + IValueAnalyzer.ID + ", was not provided.";
            LOGGER.error(_msg);
            throw new InitializationException(_msg);
        }
        this.pairMgr = (Pair.PairManager)this.info.get(Pair.PairManager.ID);
        if (this.pairMgr == null) {
            String _msg = "An interface with id, " + Pair.PairManager.ID + ", was not provided.";
            LOGGER.error(_msg);
            throw new InitializationException(_msg);
        }
    }

    private boolean isMonitorSafeByCond1InTheseBasicBlocks(BasicBlockGraph bbg, Collection<BasicBlockGraph.BasicBlock> basicBlocks, SootMethod method, Collection<SootMethod> waitMethods) {
        boolean _result = true;
        Collection _t = AbstractDirectedGraph.findCycles(basicBlocks, (Collection)bbg.getBackEdges());
        Iterator _j = _t.iterator();
        int _jEnd = _t.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd && _result) {
            Collection _cycle = (Collection)_j.next();
            boolean _cycleIsUnsafe = true;
            List _invocationStmts = bbg.getEnclosedStmts(_cycle);
            Iterator _filteredIterator = IteratorUtils.filteredIterator(_invocationStmts.iterator(), (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE);
            while (_filteredIterator.hasNext() && _cycleIsUnsafe) {
                boolean bl = _cycleIsUnsafe = !this.callgraphInfo.areAnyMethodsReachableFrom(waitMethods, (Stmt)_filteredIterator.next(), method);
            }
            _result &= !_cycleIsUnsafe;
            ++_jIndex;
        }
        return _result;
    }

    private void processMonitorAndWaitsForLockBasedRelation() {
        Collection _monitorTriples = this.monitorInfo.getMonitorTriples();
        HashSet _temp = new HashSet(_monitorTriples);
        Context _context = new Context();
        Iterator _i = _monitorTriples.iterator();
        int _iEnd = _monitorTriples.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Collection _mons;
            Collection<Value> _c1;
            Triple _monitor1 = (Triple)_i.next();
            EnterMonitorStmt _enter1 = (EnterMonitorStmt)_monitor1.getFirst();
            SootMethod _sm1 = (SootMethod)_monitor1.getThird();
            _context.setRootMethod(_sm1);
            _context.setStmt((Stmt)_enter1);
            if (_enter1 != null) {
                _context.setProgramPoint(_enter1.getOpBox());
                _c1 = this.iva.getValues(_enter1.getOp(), _context);
                _mons = this.monitorInfo.getMonitorTriplesFor((MonitorStmt)_enter1, _sm1);
            } else {
                _c1 = _sm1.isStatic() ? (Collection<Value>)Collections.singleton(_sm1.getDeclaringClass()) : this.iva.getValuesForThis(_context);
                _mons = Collections.singleton(_monitor1);
            }
            _temp.removeAll(_mons);
            Iterator _j = _temp.iterator();
            int _jEnd = _temp.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Collection<Value> _c2;
                Triple _monitor2 = (Triple)_j.next();
                EnterMonitorStmt _enter2 = (EnterMonitorStmt)_monitor2.getFirst();
                SootMethod _sm2 = (SootMethod)_monitor2.getThird();
                _context.setRootMethod(_sm2);
                _context.setStmt((Stmt)_enter2);
                if (_enter2 != null) {
                    _context.setProgramPoint(_enter2.getOpBox());
                    _c2 = this.iva.getValues(_enter2.getOp(), _context);
                } else {
                    _c2 = _sm2.isStatic() ? (Collection<Value>)Collections.singleton(_sm2.getDeclaringClass()) : this.iva.getValuesForThis(_context);
                }
                if (CollectionUtils.containsAny(_c1, _c2)) {
                    MapUtils.putIntoSetInMap(this.monitor2relatedMonitors, (Object)_monitor1, (Object)_monitor2);
                }
                ++_jIndex;
            }
            _temp.addAll(_mons);
            ++_iIndex;
        }
    }

    private void processMonitorsAndWaitsForEnclosureBaseRelation(IMonitorInfo.IMonitorGraph<?> monitorGraph) {
        Set<InvokeStmt> _keySet = this.waitStmt2method.keySet();
        Iterator<InvokeStmt> _i = _keySet.iterator();
        int _iEnd = _keySet.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            InvokeStmt _waitStmt = _i.next();
            SootMethod _method = this.waitStmt2method.get(_waitStmt);
            Collection _enclosingMonitors = monitorGraph.getInterProcedurallyEnclosingMonitorTriples((Stmt)_waitStmt, _method, false).values();
            Iterator _j = _enclosingMonitors.iterator();
            int _jEnd = _enclosingMonitors.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Collection _monitors = (Collection)_j.next();
                Iterator _k = _monitors.iterator();
                int _kEnd = _monitors.size();
                int _kIndex = 0;
                while (_kIndex < _kEnd) {
                    Triple _monitor = (Triple)_k.next();
                    MapUtils.putIntoCollectionInMap(this.monitor2waits, (Object)_monitor, (Object)this.pairMgr.getPair((Object)_waitStmt, (Object)_method));
                    ++_kIndex;
                }
                ++_jIndex;
            }
            ++_iIndex;
        }
    }

    private <N extends IObjectNode<N, Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> void propagateSafetyInformation(Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> collectedUnsafeMonitors, IMonitorInfo.IMonitorGraph<N> monitorGraph) {
        HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(this.unsafeMonitors);
        _wb.addAllWork(collectedUnsafeMonitors);
        while (_wb.hasWork()) {
            Triple _monitor = (Triple)_wb.getWork();
            _wb.addAllWork(MapUtils.queryCollection(this.monitor2relatedMonitors, (Object)_monitor));
            IObjectNode _node = monitorGraph.queryNode((Object)_monitor);
            _wb.addAllWork((Collection)CollectionUtils.collect((Collection)monitorGraph.getReachablesFrom((INode)_node, false), (ITransformer)monitorGraph.getObjectExtractor()));
        }
    }

    private boolean safeByCondition1(Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> monitor, IMonitorInfo.IMonitorGraph<?> monitorGraph) {
        HashSet<SootMethod> _waitMethods = new HashSet<SootMethod>();
        Collection _waits = MapUtils.queryCollection(this.monitor2waits, monitor);
        for (Pair _pair : _waits) {
            _waitMethods.add((SootMethod)_pair.getSecond());
        }
        boolean _monitorIsSafe = true;
        SootMethod _method = (SootMethod)monitor.getThird();
        Map _method2enclosedStmts = monitorGraph.getInterProcedurallyEnclosedStmts(monitor, false);
        BasicBlockGraph _bbg = this.getBasicBlockGraph(_method);
        Collection _stmts = (Collection)_method2enclosedStmts.remove(_method);
        List _basicBlocks = _bbg.getEnclosingBasicBlocks(_stmts);
        if (monitor.getFirst() != null) {
            _basicBlocks.remove(_bbg.getEnclosingBlock((Stmt)monitor.getFirst()));
            _basicBlocks.remove(_bbg.getEnclosingBlock((Stmt)monitor.getSecond()));
        }
        _monitorIsSafe = this.isMonitorSafeByCond1InTheseBasicBlocks(_bbg, _basicBlocks, _method, _waitMethods);
        Set _entrySet = _method2enclosedStmts.entrySet();
        Iterator _i = _entrySet.iterator();
        int _iEnd = _entrySet.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd && _monitorIsSafe) {
            Map.Entry _entry = _i.next();
            _method = (SootMethod)_entry.getKey();
            _bbg = this.getBasicBlockGraph(_method);
            _stmts = (Collection)_entry.getValue();
            _monitorIsSafe &= this.isMonitorSafeByCond1InTheseBasicBlocks(_bbg, _bbg.getEnclosingBasicBlocks(_stmts), _method, _waitMethods);
            ++_iIndex;
        }
        return _monitorIsSafe;
    }

    private boolean safeByCondition2(Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> monitor) {
        Collection<Value> _c1;
        boolean _safe = true;
        EnterMonitorStmt _monitorStmt = (EnterMonitorStmt)monitor.getFirst();
        SootMethod _monitorMethod = (SootMethod)monitor.getThird();
        Context _context = new Context();
        _context.setRootMethod(_monitorMethod);
        _context.setStmt((Stmt)_monitorStmt);
        if (_monitorStmt != null) {
            _context.setProgramPoint(_monitorStmt.getOpBox());
            _c1 = this.iva.getValues(_monitorStmt.getOp(), _context);
        } else {
            _c1 = _monitorMethod.isStatic() ? (Collection<Value>)Collections.singleton(_monitorMethod.getDeclaringClass()) : this.iva.getValuesForThis(_context);
        }
        Collection _waits = MapUtils.queryCollection(this.monitor2waits, monitor);
        Iterator _j = _waits.iterator();
        int _jEnd = _waits.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd && _safe) {
            Pair _pair = (Pair)_j.next();
            InvokeStmt _waitStmt = (InvokeStmt)_pair.getFirst();
            SootMethod _waitMethod = (SootMethod)_pair.getSecond();
            VirtualInvokeExpr _invokeExpr = (VirtualInvokeExpr)_waitStmt.getInvokeExpr();
            _context.setRootMethod(_waitMethod);
            _context.setStmt((Stmt)_waitStmt);
            _context.setProgramPoint(_invokeExpr.getBaseBox());
            Collection<Value> _c2 = this.iva.getValues(_invokeExpr.getBase(), _context);
            _safe = _c1.size() == 1 && _c1.equals(_c2);
            ++_jIndex;
        }
        return _safe;
    }

    private final class WaitInvocationCollectingProcessor
    extends AbstractProcessor {
        private WaitInvocationCollectingProcessor() {
        }

        public void callback(Stmt stmt, Context context) {
            InvokeStmt _invokeStmt = (InvokeStmt)stmt;
            SootMethod _currentMethod = context.getCurrentMethod();
            if (Util.isWaitInvocation((InvokeStmt)_invokeStmt, (SootMethod)_currentMethod, (ICallGraphInfo)SafeLockAnalysis.this.callgraphInfo)) {
                SafeLockAnalysis.this.waitStmt2method.put(_invokeStmt, _currentMethod);
            }
        }

        public void hookup(ProcessingController ppc) {
            ppc.register(InvokeStmt.class, (IProcessor)this);
        }

        public void unhook(ProcessingController ppc) {
            ppc.unregister(InvokeStmt.class, (IProcessor)this);
        }
    }
}

