/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Quadraple;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.graph.IMutableNode;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.common.soot.SootPredicatesAndTransformers;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.interfaces.AbstractAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MonitorAnalysis
extends AbstractAnalysis
implements IMonitorInfo<SimpleNode<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> {
    static final Logger LOGGER = LoggerFactory.getLogger(MonitorAnalysis.class);
    static final int NUM_OF_MONITORS_IN_APPLICATION = 500;
    static final int NUM_OF_SYNCED_METHODS_IN_APPLICATION = 50;
    final Map<SootMethod, Map<Stmt, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>>> method2enclosedStmts2monitors = new HashMap<SootMethod, Map<Stmt, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>>>(Constants.getNumOfMethodsInApplication());
    final Map<SootMethod, Collection<EnterMonitorStmt>> method2enterMonitors = new HashMap<SootMethod, Collection<EnterMonitorStmt>>(Constants.getNumOfMethodsInApplication());
    final Map<SootMethod, Map<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Stmt>>> method2monitor2enclosedStmts = new HashMap<SootMethod, Map<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Stmt>>>(Constants.getNumOfMethodsInApplication());
    final Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> monitorTriples = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>(500);
    Pair.PairManager pairMgr;
    final Collection<SootMethod> syncedMethods = new HashSet<SootMethod>(50);
    private IValueAnalyzer<Value> ofa;
    private final Map<SootMethod, Collection<Stmt>> syncedMethod2enclosedStmts = new HashMap<SootMethod, Collection<Stmt>>(50);

    public MonitorAnalysis() {
        this.preprocessor = new PreProcessor();
    }

    @Override
    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Monitor Analysis processing");
        }
        HashMap<EnterMonitorStmt, Collection<ExitMonitorStmt>> _enter2exits = new HashMap<EnterMonitorStmt, Collection<ExitMonitorStmt>>();
        HashSet<EnterMonitorStmt> _processedMonitors = new HashSet<EnterMonitorStmt>();
        for (Map.Entry<SootMethod, Collection<EnterMonitorStmt>> _entry : this.method2enterMonitors.entrySet()) {
            SootMethod _method = _entry.getKey();
            _enter2exits.clear();
            for (EnterMonitorStmt _enterMonitor : _entry.getValue()) {
                Map _monitor2enclosedStmts = MapUtils.getMapFromMap(this.method2monitor2enclosedStmts, (Object)_method);
                if (_processedMonitors.contains(_enterMonitor) || _monitor2enclosedStmts.get(_enterMonitor) != null) continue;
                _processedMonitors.addAll(this.processMonitor(_processedMonitors, _enterMonitor, _method, _enter2exits));
            }
        }
        this.method2enterMonitors.clear();
        this.stable();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("analyze() - " + this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Monitor Analysis processing");
        }
    }

    public Collection<Stmt> getEnclosedStmts(Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> monitorTriple, boolean transitive) {
        HashSet<Stmt> _result = new HashSet<Stmt>();
        EnterMonitorStmt _enterMonitorStmt = (EnterMonitorStmt)monitorTriple.getFirst();
        SootMethod _sm = (SootMethod)monitorTriple.getThird();
        if (_enterMonitorStmt == null) {
            if (!this.syncedMethods.isEmpty()) {
                this.processSyncedMethods();
            }
            _result.addAll(MapUtils.getEmptyCollectionFromMap(this.syncedMethod2enclosedStmts, (Object)_sm));
            if (transitive && !_result.isEmpty()) {
                Map<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Stmt>> _monitor2enclosedStmts = this.method2monitor2enclosedStmts.get(_sm);
                HashSet<Stmt> _temp = new HashSet<Stmt>();
                _temp.addAll(_result);
                CollectionUtils.filter(_temp, (IPredicate)SootPredicatesAndTransformers.ENTER_MONITOR_STMT_PREDICATE);
                Iterator _i = _temp.iterator();
                int _iEnd = _temp.size();
                int _iIndex = 0;
                while (_iIndex < _iEnd) {
                    EnterMonitorStmt _monitorStmt = (EnterMonitorStmt)_i.next();
                    Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _monitorTriplesFor = this.getMonitorTriplesFor((MonitorStmt)_monitorStmt, _sm);
                    Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _j = _monitorTriplesFor.iterator();
                    int _jEnd = _monitorTriplesFor.size();
                    int _jIndex = 0;
                    while (_jIndex < _jEnd) {
                        Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _monitor = _j.next();
                        _result.addAll(this.calculateTransitiveClosureOfEnclosedStmts(_monitor2enclosedStmts, _monitor, _sm));
                        ++_jIndex;
                    }
                    ++_iIndex;
                }
            }
        } else {
            Map _monitor2enclosedStmts = MapUtils.getEmptyMapFromMap(this.method2monitor2enclosedStmts, (Object)_sm);
            if (!_monitor2enclosedStmts.isEmpty()) {
                if (transitive) {
                    _result.addAll(this.calculateTransitiveClosureOfEnclosedStmts(_monitor2enclosedStmts, monitorTriple, _sm));
                } else {
                    _result.addAll((Collection)MapUtils.getFromMap((Map)_monitor2enclosedStmts, monitorTriple, Collections.emptyList()));
                }
            }
        }
        return _result;
    }

    public Collection<MonitorStmt> getEnclosingMonitorStmts(Stmt stmt, SootMethod method, boolean transitive) {
        HashSet<MonitorStmt> _result = new HashSet<MonitorStmt>();
        Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _temp = this.getEnclosingMonitorTriples(stmt, method, transitive);
        Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _i = _temp.iterator();
        int _iEnd = _temp.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _monitor = _i.next();
            EnterMonitorStmt _enter = (EnterMonitorStmt)_monitor.getFirst();
            if (_enter != null) {
                _result.add((MonitorStmt)_enter);
                _result.add((MonitorStmt)_monitor.getSecond());
            }
            ++_iIndex;
        }
        return _result;
    }

    public Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> getEnclosingMonitorTriples(Stmt stmt, SootMethod method, boolean transitive) {
        HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _result = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
        Map _enclosedStmt2monitors = MapUtils.getEmptyMapFromMap(this.method2enclosedStmts2monitors, (Object)method);
        if (_enclosedStmt2monitors.size() > 0) {
            if (transitive) {
                _result.addAll(this.calculateTransitiveClosureOfEnclosingMonitor(_enclosedStmt2monitors, stmt));
            } else {
                _result.addAll(MapUtils.getEmptyCollectionFromMap((Map)_enclosedStmt2monitors, (Object)stmt));
            }
        } else if (method.isSynchronized()) {
            _result.add((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)new Triple(null, null, (Object)method));
        }
        return _result;
    }

    public Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(IMonitorInfo.ID);
    }

    public IMonitorInfo.IMonitorGraph<SimpleNode<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> getMonitorGraph(ICallGraphInfo callgraphInfo) {
        MonitorGraph _result = new MonitorGraph(callgraphInfo);
        HashSet _temp = new HashSet();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_temp);
        HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _considered = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
        HashSet<SimpleNode<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> _dests = new HashSet<SimpleNode<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>>();
        Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _i = this.monitorTriples.iterator();
        int _iEnd = this.monitorTriples.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _monitor = _i.next();
            if (!_considered.contains(_monitor)) {
                Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _monitorTriplesOf = this.getMonitorTriplesOf(_monitor);
                _considered.addAll(_monitorTriplesOf);
                _dests.clear();
                Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _j = _monitorTriplesOf.iterator();
                int _jEnd = _monitorTriplesOf.size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    _dests.add(_result.getNode(_j.next()));
                    ++_jIndex;
                }
                EnterMonitorStmt _stmt = (EnterMonitorStmt)_monitor.getFirst();
                SootMethod _method = (SootMethod)_monitor.getThird();
                HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _enclosingMonitors = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
                if (_stmt != null) {
                    _enclosingMonitors.addAll(this.getEnclosingMonitorTriples((Stmt)_stmt, _method, false));
                }
                if (!_enclosingMonitors.isEmpty()) {
                    this.addEdgesFromToIn(_enclosingMonitors, _dests, _result);
                } else {
                    _temp.clear();
                    _wb.clear();
                    _wb.addAllWork(callgraphInfo.getCallers(_method));
                    while (_wb.hasWork()) {
                        ICallGraphInfo.CallTriple _ctrp = (ICallGraphInfo.CallTriple)_wb.getWork();
                        SootMethod _sm = _ctrp.getMethod();
                        Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _mons = this.getEnclosingMonitorTriples(_ctrp.getStmt(), _sm, false);
                        if (_mons.isEmpty()) {
                            _wb.addAllWorkNoDuplicates(callgraphInfo.getCallers(_sm));
                            continue;
                        }
                        _enclosingMonitors.addAll(_mons);
                    }
                    if (!_enclosingMonitors.isEmpty()) {
                        this.addEdgesFromToIn(_enclosingMonitors, _dests, _result);
                    }
                }
                _considered.addAll(_monitorTriplesOf);
            }
            ++_iIndex;
        }
        return _result;
    }

    public Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> getMonitorTriples() {
        return Collections.unmodifiableCollection(this.monitorTriples);
    }

    public Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> getMonitorTriplesFor(MonitorStmt monitorStmt, SootMethod method) {
        HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _result = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
        Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _monitorTriplesInMethod = this.getMonitorTriplesIn(method);
        Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _i = _monitorTriplesInMethod.iterator();
        int _iEnd = _monitorTriplesInMethod.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _triple = _i.next();
            EnterMonitorStmt _enter = (EnterMonitorStmt)_triple.getFirst();
            ExitMonitorStmt _exit = (ExitMonitorStmt)_triple.getSecond();
            if (_enter != null && _enter.equals(monitorStmt) || _exit != null && _exit.equals(monitorStmt)) {
                _result.add(_triple);
            }
            ++_iIndex;
        }
        return _result;
    }

    public Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> getMonitorTriplesIn(SootMethod method) {
        HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _result = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
        Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _i = this.monitorTriples.iterator();
        int _iEnd = this.monitorTriples.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _triple = _i.next();
            if (((SootMethod)_triple.getThird()).equals(method)) {
                _result.add(_triple);
            }
            ++_iIndex;
        }
        return _result;
    }

    public Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> getMonitorTriplesOf(Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> monitor) {
        HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _triples;
        if (monitor.getFirst() == null) {
            _triples = (HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>)Collections.singleton(monitor);
        } else {
            _triples = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
            Collection<MonitorStmt> _stmts = this.getStmtsOfMonitor(monitor);
            SootMethod _method = (SootMethod)monitor.getThird();
            Iterator<MonitorStmt> _i = _stmts.iterator();
            int _iEnd = _stmts.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                MonitorStmt _stmt = _i.next();
                _triples.addAll(this.getMonitorTriplesFor(_stmt, _method));
                ++_iIndex;
            }
        }
        return _triples;
    }

    public Collection<MonitorStmt> getStmtsOfMonitor(Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> monitor) {
        HashSet<MonitorStmt> _result;
        EnterMonitorStmt _monitorStmt = (EnterMonitorStmt)monitor.getFirst();
        if (_monitorStmt != null) {
            _result = new HashSet<MonitorStmt>();
            _result.add((MonitorStmt)_monitorStmt);
            for (Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _monitor : this.getMonitorTriplesFor((MonitorStmt)_monitorStmt, (SootMethod)monitor.getThird())) {
                _result.add((MonitorStmt)_monitor.getSecond());
            }
        } else {
            _result = (HashSet<MonitorStmt>)Collections.emptySet();
        }
        return _result;
    }

    public Collection<Stmt> getUnenclosedStmtsOf(SootMethod method) {
        final Collection _enclosedStmts = MapUtils.getEmptyMapFromMap(this.method2enclosedStmts2monitors, (Object)method).keySet();
        IPredicate<Stmt> _predicate = new IPredicate<Stmt>(){

            public boolean evaluate(Stmt o) {
                return !_enclosedStmts.contains(o);
            }
        };
        Collection _result = IteratorUtils.toList((Iterator)IteratorUtils.filteredIterator((Iterator)this.getUnitGraph(method).iterator(), (IPredicate)_predicate));
        return _result;
    }

    @Override
    public void reset() {
        super.reset();
        this.monitorTriples.clear();
        this.syncedMethods.clear();
        this.syncedMethod2enclosedStmts.clear();
        this.method2enclosedStmts2monitors.clear();
        this.method2monitor2enclosedStmts.clear();
        this.method2enterMonitors.clear();
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("Statistics for Monitor Analysis as calculated by " + this.getClass().getName() + "\n");
        int _localEdgeCount = 0;
        int _edgeCount = 0;
        StringBuffer _temp = new StringBuffer();
        for (Map.Entry<SootMethod, Map<Stmt, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>>> _entry : this.method2enclosedStmts2monitors.entrySet()) {
            _localEdgeCount = 0;
            SootMethod sootMethod = _entry.getKey();
            for (Map.Entry<Stmt, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> _entry2 : _entry.getValue().entrySet()) {
                Stmt _dependent = _entry2.getKey();
                for (Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _obj : _entry2.getValue()) {
                    _temp.append("\t\t" + _dependent + "[" + _dependent.hashCode() + "] -enclosed by- " + _obj + "[" + _obj.hashCode() + "]\n");
                }
                _localEdgeCount += _entry2.getValue().size();
            }
            _result.append("\tFor " + sootMethod + " there are " + _localEdgeCount + " enclosures.\n");
            _result.append(_temp);
            _temp.delete(0, _temp.length());
            _edgeCount += _localEdgeCount;
        }
        int _edgeCount2 = 0;
        Iterator<Map<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Stmt>>> _i = this.method2monitor2enclosedStmts.values().iterator();
        while (_i.hasNext()) {
            Iterator<Collection<Stmt>> iterator = _i.next().values().iterator();
            while (iterator.hasNext()) {
                _edgeCount2 += iterator.next().size();
            }
        }
        _result.append("A total of " + _edgeCount + "/" + _edgeCount2 + " enclosures exist.\n");
        _result.append("MonitorInfo follows:\n");
        for (Triple triple : this.monitorTriples) {
            if (triple.getFirst() != null) {
                _result.append("[" + triple.getFirst() + " " + ((EnterMonitorStmt)triple.getFirst()).hashCode() + ", " + triple.getSecond() + " " + ((ExitMonitorStmt)triple.getSecond()).hashCode() + "] occurs in " + triple.getThird() + "\n");
                continue;
            }
            _result.append(triple.getThird() + " is synchronized.\n");
        }
        return _result.toString();
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.ofa = (IValueAnalyzer)this.info.get(IValueAnalyzer.ID);
        if (this.ofa == null) {
            throw new InitializationException(IValueAnalyzer.ID + " was not provided in the info.");
        }
        this.pairMgr = (Pair.PairManager)this.info.get(Pair.PairManager.ID);
        if (this.pairMgr == null) {
            throw new InitializationException(Pair.PairManager.ID + " was not provided in the info.");
        }
    }

    private void addEdgesFromToIn(Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> srcs, Collection<SimpleNode<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> dests, MonitorGraph graph) {
        Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _k = srcs.iterator();
        int _kEnd = srcs.size();
        int _kIndex = 0;
        while (_kIndex < _kEnd) {
            Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _t = _k.next();
            SimpleNode _src = graph.getNode(_t);
            Iterator<SimpleNode<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> _l = dests.iterator();
            int _lEnd = dests.size();
            int _lIndex = 0;
            while (_lIndex < _lEnd) {
                graph.addEdgeFromTo((IMutableNode)_src, (IMutableNode)_l.next());
                ++_lIndex;
            }
            ++_kIndex;
        }
    }

    private Collection<Stmt> calculateTransitiveClosureOfEnclosedStmts(Map<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>, Collection<Stmt>> monitor2stmts, Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> monitor, SootMethod method) {
        HashSet<Stmt> _result = new HashSet<Stmt>();
        HashSet _temp = new HashSet();
        LIFOWorkBag _wb = new LIFOWorkBag();
        _wb.addWork(monitor);
        while (_wb.hasWork()) {
            Triple _monitor = (Triple)_wb.getWork();
            _temp.clear();
            _temp.addAll(MapUtils.getEmptyCollectionFromMap(monitor2stmts, (Object)_monitor));
            _result.addAll(_temp);
            CollectionUtils.filter(_temp, (IPredicate)SootPredicatesAndTransformers.ENTER_MONITOR_STMT_PREDICATE);
            Iterator _i = _temp.iterator();
            int _iEnd = _temp.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                EnterMonitorStmt _monitorStmt = (EnterMonitorStmt)_i.next();
                _wb.addAllWorkNoDuplicates(this.getMonitorTriplesFor((MonitorStmt)_monitorStmt, method));
                ++_iIndex;
            }
        }
        return _result;
    }

    private Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> calculateTransitiveClosureOfEnclosingMonitor(Map<Stmt, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> stmt2monitors, Stmt stmt) {
        HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _result = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
        LIFOWorkBag _wb = new LIFOWorkBag();
        _wb.addWork((Object)stmt);
        while (_wb.hasWork()) {
            Stmt _s = (Stmt)_wb.getWork();
            Collection _monitors = MapUtils.getEmptyCollectionFromMap(stmt2monitors, (Object)_s);
            _result.addAll(_monitors);
            Iterator _i = _monitors.iterator();
            int _iEnd = _monitors.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Triple _monitor = (Triple)_i.next();
                _wb.addAllWorkNoDuplicates(this.getStmtsOfMonitor((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)_monitor));
                ++_iIndex;
            }
        }
        return _result;
    }

    private void populateWorkBagToProcessSuccessors(IWorkBag<Quadraple<BasicBlockGraph.BasicBlock, Stmt, Stack<Pair<EnterMonitorStmt, Collection<Stmt>>>, Collection<Stmt>>> workbag, BasicBlockGraph.BasicBlock exitBasicBlock, Stack<Pair<EnterMonitorStmt, Collection<Stmt>>> enterStack, Collection<Stmt> currStmts) {
        Collection _succs = exitBasicBlock.getSuccsOf();
        if (_succs.size() == 1) {
            BasicBlockGraph.BasicBlock _succ = (BasicBlockGraph.BasicBlock)_succs.iterator().next();
            workbag.addWork((Object)new Quadraple((Object)_succ, (Object)_succ.getLeaderStmt(), enterStack, currStmts));
        } else {
            for (BasicBlockGraph.BasicBlock _succ : _succs) {
                Stack<Pair> _clone = new Stack<Pair>();
                for (Pair pair : enterStack) {
                    HashSet _hashSet = new HashSet((Collection)pair.getSecond());
                    _clone.add(new Pair((Object)((EnterMonitorStmt)pair.getFirst()), _hashSet));
                }
                Quadraple _quadraple = new Quadraple((Object)_succ, (Object)_succ.getLeaderStmt(), _clone, new HashSet<Stmt>(currStmts));
                workbag.addWork((Object)_quadraple);
            }
        }
    }

    private void populateWorkBagWithSuccessorsOfNestedMonitor(IWorkBag<Quadraple<BasicBlockGraph.BasicBlock, Stmt, Stack<Pair<EnterMonitorStmt, Collection<Stmt>>>, Collection<Stmt>>> workbag, Collection<ExitMonitorStmt> exitMonitors, Stack<Pair<EnterMonitorStmt, Collection<Stmt>>> enterStack, Collection<Stmt> currStmts, BasicBlockGraph graph) {
        for (ExitMonitorStmt _exit : exitMonitors) {
            BasicBlockGraph.BasicBlock _exitBlock = graph.getEnclosingBlock((Stmt)_exit);
            HashSet<Stmt> _currStmtsClone = new HashSet<Stmt>(currStmts);
            _currStmtsClone.add((Stmt)_exit);
            if (_exit == _exitBlock.getTrailerStmt()) {
                this.populateWorkBagToProcessSuccessors(workbag, _exitBlock, enterStack, _currStmtsClone);
                continue;
            }
            List _stmts = _exitBlock.getStmtsOf();
            Stack<Pair<EnterMonitorStmt, Collection<Stmt>>> _clone = new Stack<Pair<EnterMonitorStmt, Collection<Stmt>>>();
            _clone.addAll(enterStack);
            workbag.addWork((Object)new Quadraple((Object)_exitBlock, (Object)((Stmt)_stmts.get(_stmts.indexOf(_exit) + 1)), _clone, _currStmtsClone));
        }
    }

    private Collection<Stmt> processExitMonitor(SootMethod method, Map<EnterMonitorStmt, Collection<ExitMonitorStmt>> enter2exits, Stack<Pair<EnterMonitorStmt, Collection<Stmt>>> enterStack, Collection<Stmt> currStmts, ExitMonitorStmt exitMonitor) {
        Pair<EnterMonitorStmt, Collection<Stmt>> _pair = enterStack.pop();
        EnterMonitorStmt _enter = (EnterMonitorStmt)_pair.getFirst();
        ExitMonitorStmt _exit = exitMonitor;
        Collection _result = currStmts;
        if (this.shouldCollectInfo(method, _enter, _exit)) {
            Map _dent2ddees = MapUtils.getMapFromMap(this.method2enclosedStmts2monitors, (Object)method);
            Map _ddee2ddents = MapUtils.getMapFromMap(this.method2monitor2enclosedStmts, (Object)method);
            Triple _dependee = new Triple((Object)_enter, (Object)_exit, (Object)method);
            this.monitorTriples.add((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)_dependee);
            for (Stmt _curr : currStmts) {
                MapUtils.putIntoCollectionInMap((Map)_dent2ddees, (Object)_curr, (Object)_dependee);
            }
            MapUtils.putAllIntoCollectionInMap((Map)_ddee2ddents, (Object)_dependee, currStmts);
            MapUtils.putIntoCollectionInMap(enter2exits, (Object)_enter, (Object)_exit);
            _result = (Collection)_pair.getSecond();
            _result.add(_exit);
        }
        return _result;
    }

    private Collection<EnterMonitorStmt> processMonitor(Collection<EnterMonitorStmt> processedMonitors, EnterMonitorStmt enterMonitor, SootMethod method, Map<EnterMonitorStmt, Collection<ExitMonitorStmt>> enter2exits) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing stmt " + enterMonitor + " in method " + method);
        }
        HistoryAwareLIFOWorkBag _workbag = new HistoryAwareLIFOWorkBag(new HashSet());
        BasicBlockGraph _bbGraph = this.getBasicBlockGraph(method);
        HashSet<EnterMonitorStmt> _enterMonitors = new HashSet<EnterMonitorStmt>();
        _enterMonitors.add(enterMonitor);
        _workbag.addWork((Object)new Quadraple((Object)_bbGraph.getEnclosingBlock((Stmt)enterMonitor), (Object)enterMonitor, new Stack(), new HashSet()));
        block0: do {
            Quadraple _work = (Quadraple)_workbag.getWork();
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_work.getFirst();
            Stmt _leadStmt = (Stmt)_work.getSecond();
            Stack _enterStack = (Stack)_work.getThird();
            Collection<Stmt> _currStmts = (Collection<Stmt>)_work.getFourth();
            boolean _skippingSuccs = false;
            for (Stmt _stmt : _bb.getStmtsFrom(_leadStmt)) {
                if (_stmt instanceof EnterMonitorStmt) {
                    EnterMonitorStmt _enter = (EnterMonitorStmt)_stmt;
                    if (!processedMonitors.contains(_enter)) {
                        _currStmts.add((Stmt)_enter);
                        _enterStack.push(new Pair((Object)_enter, _currStmts));
                        _currStmts = new HashSet<Stmt>();
                        _enterMonitors.add(_enter);
                        continue;
                    }
                    Collection _exits = MapUtils.getCollectionFromMap(enter2exits, (Object)_enter);
                    _currStmts.add(_stmt);
                    this.populateWorkBagWithSuccessorsOfNestedMonitor((IWorkBag<Quadraple<BasicBlockGraph.BasicBlock, Stmt, Stack<Pair<EnterMonitorStmt, Collection<Stmt>>>, Collection<Stmt>>>)_workbag, _exits, _enterStack, _currStmts, _bbGraph);
                    _skippingSuccs = true;
                    break;
                }
                if (_stmt instanceof ExitMonitorStmt) {
                    _currStmts = this.processExitMonitor(method, enter2exits, _enterStack, _currStmts, (ExitMonitorStmt)_stmt);
                    if (!_enterStack.isEmpty()) continue;
                    continue block0;
                }
                if (_currStmts.add(_stmt) && (_enterStack.isEmpty() || !((Collection)((Pair)_enterStack.peek()).getSecond()).contains(_stmt))) continue;
                _skippingSuccs = true;
                break;
            }
            if (_skippingSuccs || _enterStack.isEmpty()) continue;
            this.populateWorkBagToProcessSuccessors((IWorkBag<Quadraple<BasicBlockGraph.BasicBlock, Stmt, Stack<Pair<EnterMonitorStmt, Collection<Stmt>>>, Collection<Stmt>>>)_workbag, _bb, _enterStack, _currStmts);
        } while (_workbag.hasWork());
        return _enterMonitors;
    }

    private void processSyncedMethods() {
        for (SootMethod _sm : this.syncedMethods) {
            Collection<Stmt> _temp = this.getUnenclosedStmtsOf(_sm);
            if (_temp.isEmpty()) continue;
            this.syncedMethod2enclosedStmts.put(_sm, new ArrayList<Stmt>(_temp));
        }
        this.syncedMethods.clear();
    }

    private boolean shouldCollectInfo(SootMethod method, EnterMonitorStmt enter, ExitMonitorStmt exit) {
        Type _exitType;
        Type _enterType = enter.getOp().getType();
        boolean _result = _enterType.equals(_exitType = exit.getOp().getType());
        if (_result) {
            Context _context = new Context();
            _context.setRootMethod(method);
            _context.setProgramPoint(enter.getOpBox());
            _context.setStmt((Stmt)enter);
            Collection<Value> _nValues = this.ofa.getValues(enter.getOp(), _context);
            _context.setProgramPoint(exit.getOpBox());
            _context.setStmt((Stmt)exit);
            Collection<Value> _xValues = this.ofa.getValues(exit.getOp(), _context);
            if (!_xValues.isEmpty() && !_nValues.isEmpty()) {
                _result = !SetUtils.intersection(_xValues, _nValues).isEmpty();
            }
        }
        return _result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MonitorGraph
    extends SimpleNodeGraph<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>
    implements IMonitorInfo.IMonitorGraph<SimpleNode<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> {
        private final ICallGraphInfo cgi;

        public MonitorGraph(ICallGraphInfo callgraphInfo) {
            this.cgi = callgraphInfo;
        }

        public Map<SootMethod, Collection<Stmt>> getInterProcedurallyEnclosedStmts(Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> monitorTriple, boolean transitive) {
            EnterMonitorStmt _stmt = (EnterMonitorStmt)monitorTriple.getFirst();
            SootMethod _sootMethod = (SootMethod)monitorTriple.getThird();
            Map<SootMethod, Collection<Stmt>> _result = _stmt == null ? this.getInterProcedurallyEnclosedStmts(_sootMethod, transitive) : this.getInterProcedurallyEnclosedStmts((MonitorStmt)_stmt, _sootMethod, transitive);
            return _result;
        }

        public Map<SootMethod, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> getInterProcedurallyEnclosingMonitorTriples(Stmt stmt, SootMethod method, boolean transitive) {
            HashMap<SootMethod, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>> _result = new HashMap<SootMethod, Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>>();
            HashSet _monitorNodes = new HashSet();
            Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _immediateMonitors = MonitorAnalysis.this.getEnclosingMonitorTriples(stmt, method, false);
            if (_immediateMonitors.isEmpty()) {
                _immediateMonitors.addAll(this.calculateImmediateInterprocedurallyEnclosingMonitorTriples(method));
            }
            _result.put(method, _immediateMonitors);
            if (transitive && !_immediateMonitors.isEmpty()) {
                Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _i = _immediateMonitors.iterator();
                int _iEnd = _immediateMonitors.size();
                int _iIndex = 0;
                while (_iIndex < _iEnd) {
                    Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _monitor = _i.next();
                    _monitorNodes.addAll(this.getReachablesFrom((INode)this.queryNode(_monitor), false));
                    ++_iIndex;
                }
            }
            HashSet _monitors = new HashSet();
            CollectionUtils.transform(_monitorNodes, (ITransformer)this.getObjectExtractor(), _monitors);
            Iterator _i = _monitors.iterator();
            int _iEnd = _monitors.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Triple _monitor = (Triple)_i.next();
                MapUtils.putIntoSetInMap(_result, (Object)((SootMethod)_monitor.getThird()), (Object)_monitor);
                ++_iIndex;
            }
            return _result;
        }

        private Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> calculateImmediateInterprocedurallyEnclosingMonitorTriples(SootMethod method) {
            HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(new HashSet());
            HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _result = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
            for (ICallGraphInfo.CallTriple _ctrp : this.cgi.getCallers(method)) {
                _wb.addWork((Object)new Pair((Object)_ctrp.getStmt(), (Object)_ctrp.getMethod()));
            }
            while (_wb.hasWork()) {
                SootMethod _sm;
                Pair _pair = (Pair)_wb.getWork();
                Stmt _stmt = (Stmt)_pair.getFirst();
                Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _immMon = MonitorAnalysis.this.getEnclosingMonitorTriples(_stmt, _sm = (SootMethod)_pair.getSecond(), false);
                if (_immMon.isEmpty()) {
                    for (ICallGraphInfo.CallTriple _ctrp : this.cgi.getCallers(_sm)) {
                        _wb.addWork((Object)new Pair((Object)_ctrp.getStmt(), (Object)_ctrp.getMethod()));
                    }
                    continue;
                }
                _result.addAll(_immMon);
            }
            return _result;
        }

        private void calculateInterprocedurallyEnclosedStmts(SootMethod method, boolean transitive, Map<SootMethod, Collection<Stmt>> method2stmts, Iterator<Stmt> stmtsWithInvokeExpr) {
            Stmt _stmt;
            Context _context = new Context();
            HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(new HashSet());
            Iterator<Stmt> _i = stmtsWithInvokeExpr;
            while (_i.hasNext()) {
                _stmt = _i.next();
                _wb.addWork((Object)MonitorAnalysis.this.pairMgr.getPair((Object)_stmt, (Object)method));
            }
            while (_wb.hasWork()) {
                Pair _pair = (Pair)_wb.getWork();
                _stmt = (Stmt)_pair.getFirst();
                SootMethod _caller = (SootMethod)_pair.getSecond();
                _context.setStmt(_stmt);
                _context.setRootMethod(_caller);
                Collection _callees = this.cgi.getCallees(_stmt.getInvokeExpr(), _context);
                Iterator _i2 = _callees.iterator();
                int _iEnd = _callees.size();
                int _iIndex = 0;
                while (_iIndex < _iEnd) {
                    SootMethod _callee = (SootMethod)_i2.next();
                    if (!_callee.isSynchronized() || _callee.isSynchronized() && transitive) {
                        Collection<Stmt> _stmts = MonitorAnalysis.this.getUnenclosedStmtsOf(_callee);
                        MapUtils.putAllIntoCollectionInMap(method2stmts, (Object)_callee, _stmts);
                        for (Stmt _s : IteratorUtils.filteredIterable(_stmts, (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE)) {
                            _wb.addWork((Object)MonitorAnalysis.this.pairMgr.getPair((Object)_s, (Object)_callee));
                        }
                    }
                    ++_iIndex;
                }
            }
        }

        private Map<SootMethod, Collection<Stmt>> getInterProcedurallyEnclosedStmts(MonitorStmt monitorStmt, SootMethod method, boolean transitive) {
            HashSet<Stmt> _intraStmts = new HashSet<Stmt>();
            Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _monitorTriplesFor = MonitorAnalysis.this.getMonitorTriplesFor(monitorStmt, method);
            Iterator<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _i = _monitorTriplesFor.iterator();
            int _iEnd = _intraStmts.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _monitor = _i.next();
                _intraStmts.addAll(MonitorAnalysis.this.getEnclosedStmts(_monitor, transitive));
                ++_iIndex;
            }
            HashMap<SootMethod, Collection<Stmt>> _method2stmts = new HashMap<SootMethod, Collection<Stmt>>();
            _method2stmts.put(method, _intraStmts);
            Iterator _stmtsWithInvokeExpr = IteratorUtils.filteredIterator(_intraStmts.iterator(), (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE);
            this.calculateInterprocedurallyEnclosedStmts(method, transitive, _method2stmts, _stmtsWithInvokeExpr);
            return _method2stmts;
        }

        private Map<SootMethod, Collection<Stmt>> getInterProcedurallyEnclosedStmts(SootMethod method, boolean transitive) {
            Collection<Stmt> _intraStmts = MonitorAnalysis.this.getEnclosedStmts((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)new Triple(null, null, (Object)method), transitive);
            HashMap<SootMethod, Collection<Stmt>> _method2stmts = new HashMap<SootMethod, Collection<Stmt>>();
            _method2stmts.put(method, _intraStmts);
            Iterator _stmtsWithInvokeExpr = IteratorUtils.filteredIterator(_intraStmts.iterator(), (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE);
            this.calculateInterprocedurallyEnclosedStmts(method, transitive, _method2stmts, _stmtsWithInvokeExpr);
            return _method2stmts;
        }
    }

    private final class PreProcessor
    extends AbstractProcessor {
        private PreProcessor() {
        }

        public void callback(SootMethod method) {
            if (method.isSynchronized()) {
                Triple _triple = new Triple(null, null, (Object)method);
                _triple.optimize();
                MonitorAnalysis.this.monitorTriples.add((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)_triple);
                MonitorAnalysis.this.syncedMethods.add(method);
            }
        }

        public void callback(Stmt stmt, Context context) {
            if (stmt instanceof EnterMonitorStmt) {
                MapUtils.putIntoSetInMap(MonitorAnalysis.this.method2enterMonitors, (Object)context.getCurrentMethod(), (Object)((EnterMonitorStmt)stmt));
            }
        }

        public void hookup(ProcessingController ppc) {
            ppc.register(EnterMonitorStmt.class, (IProcessor)this);
            ppc.register((IProcessor)this);
        }

        public void unhook(ProcessingController ppc) {
            ppc.unregister(EnterMonitorStmt.class, (IProcessor)this);
            ppc.unregister((IProcessor)this);
        }
    }
}

