/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.DeadlockAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.MonitorAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.LockAcquisitionBasedEquivalence;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeadlockAnalysisCLI
extends SootBasedDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeadlockAnalysisCLI.class);

    public static void main(String[] args) {
        Options _options = new Options();
        Option _option = new Option("h", "help", false, "Display message.");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("p", "soot-classpath", false, "Prepend this to soot class path.");
        _option.setArgs(1);
        _option.setArgName("classpath");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("S", "scope", true, "The scope that should be analyzed.");
        _option.setArgs(1);
        _option.setArgName("scope");
        _option.setRequired(false);
        _options.addOption(_option);
        GnuParser _parser = new GnuParser();
        try {
            CommandLine _cl = _parser.parse(_options, args);
            if (_cl.hasOption("h")) {
                String _cmdLineSyn = "java " + DeadlockAnalysisCLI.class.getName() + " <options> <classnames>";
                new HelpFormatter().printHelp(_cmdLineSyn, _options);
                System.exit(1);
            }
            if (_cl.getArgList().isEmpty()) {
                throw new MissingArgumentException("Please specify atleast one class.");
            }
            DeadlockAnalysisCLI _cli = new DeadlockAnalysisCLI();
            if (_cl.hasOption('p')) {
                _cli.addToSootClassPath(_cl.getOptionValue('p'));
            }
            if (_cl.hasOption('S')) {
                _cli.setScopeSpecFile(_cl.getOptionValue('S'));
            }
            _cli.setClassNames(_cl.getArgList());
            _cli.execute();
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            System.out.println("Error while parsing command line." + (Object)((Object)_e));
            String _cmdLineSyn = "java " + DeadlockAnalysisCLI.class.getName() + " <options> <classnames>";
            new HelpFormatter().printHelp(_cmdLineSyn, "Options are:", _options, "");
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    private <T extends ITokens<T, Value>> void execute() {
        this.setInfoLogger(LOGGER);
        IValueAnalyzer _aa = OFAnalyzer.getFSOSAnalyzer("SideEffect:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList<IProcessor> _processors = new ArrayList<IProcessor>();
        Pair.PairManager _pairManager = new Pair.PairManager(false, true);
        CallGraphInfo _cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        MonitorAnalysis _monitorInfo = new MonitorAnalysis();
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        ThreadGraph _tgi = new ThreadGraph(_cgi, new CFGAnalysis(_cgi, this.getBbm()), _pairManager);
        ValueAnalyzerBasedProcessingController _cgipc = new ValueAnalyzerBasedProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(_aa);
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("SideEffect:FA"));
        _cgipc.setAnalyzer(_aa);
        _cgipc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(_cgi));
        _cgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        HashMap _info = new HashMap();
        _info.put(ICallGraphInfo.ID, (Object)((Object)_cgi));
        _info.put(IThreadGraphInfo.ID, _tgi);
        _info.put(Pair.PairManager.ID, _pairManager);
        _info.put(IEnvironment.ID, _aa.getEnvironment());
        _info.put(IValueAnalyzer.ID, _aa);
        this.initialize();
        _aa.analyze(this.getEnvironment(), this.getRootMethods());
        _processors.clear();
        _processors.add(_callGraphInfoCollector);
        _pc.reset();
        _pc.driveProcessors(_processors);
        _cgi.reset();
        _cgi.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
        this.writeInfo("CALL GRAPH:\n" + _cgi.toString());
        _processors.clear();
        _tgi.reset();
        _processors.add(_tgi);
        _cgipc.reset();
        _cgipc.driveProcessors(_processors);
        this.writeInfo("THREAD GRAPH:\n" + _tgi.toString());
        EquivalenceClassBasedEscapeAnalysis _ecba = new EquivalenceClassBasedEscapeAnalysis(_cgi, _tgi, this.getBbm());
        IEscapeInfo _escapeInfo = _ecba.getEscapeInfo();
        AnalysesController _ac = new AnalysesController(_info, _cgipc, this.getBbm());
        _ac.addAnalyses(EquivalenceClassBasedEscapeAnalysis.ID, (Collection<? extends IAnalysis>)Collections.singleton(_ecba));
        _ac.addAnalyses(IMonitorInfo.ID, (Collection<? extends IAnalysis>)Collections.singleton(_monitorInfo));
        _ac.initialize();
        _ac.execute();
        this.writeInfo("END: Escape analysis");
        LockAcquisitionBasedEquivalence _lbe = new LockAcquisitionBasedEquivalence(_escapeInfo, _cgi);
        _lbe.hookup(_cgipc);
        _cgipc.process();
        _lbe.unhook(_cgipc);
        System.out.println("Deadlock Analysis:");
        System.out.println("Total number of monitors: " + _monitorInfo.getMonitorTriples().size());
        this.calculateDeadlockInfo(_aa, _monitorInfo, null, null);
        this.calculateDeadlockInfo(_aa, _monitorInfo, _escapeInfo, null);
        this.calculateDeadlockInfo(_aa, _monitorInfo, null, _lbe);
        this.calculateDeadlockInfo(_aa, _monitorInfo, _escapeInfo, _lbe);
    }

    private void calculateDeadlockInfo(IValueAnalyzer<Value> aa, MonitorAnalysis monitorInfo, IEscapeInfo escapeInfo, LockAcquisitionBasedEquivalence lbe) {
        DeadlockAnalysis _dla = new DeadlockAnalysis(monitorInfo, aa, lbe, escapeInfo);
        Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _deadlockingMonitors = _dla.getDeadlockingMonitors();
        System.out.println("Deadlocking Monitors: " + _deadlockingMonitors.size() + " -- using escapeInfo :" + (escapeInfo != null) + " -- using locking based equiv : " + (lbe != null));
        for (Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> _m : _deadlockingMonitors) {
            System.out.println("\t" + _m);
        }
    }
}

