/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraphBuilder;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.LockAcquisitionBasedEquivalence;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import soot.SootMethod;
import soot.Value;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeadlockAnalysis {
    private final IMonitorInfo<?> monitorInfo;
    private final IValueAnalyzer<Value> ofa;
    private final LockAcquisitionBasedEquivalence lbe;
    private final IEscapeInfo escapeInfo;

    public DeadlockAnalysis(IMonitorInfo<?> m, IValueAnalyzer<Value> va, LockAcquisitionBasedEquivalence l, IEscapeInfo e) {
        this.monitorInfo = m;
        this.ofa = va;
        this.lbe = l;
        this.escapeInfo = e;
    }

    public Collection<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> getDeadlockingMonitors() {
        SimpleNodeGraphBuilder _sng = new SimpleNodeGraphBuilder();
        HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> _result = new HashSet<Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>>();
        Collection _monitors = this.monitorInfo.getMonitorTriples();
        ArrayList _processed = new ArrayList();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_processed);
        _sng.createGraph();
        for (Triple _m : _monitors) {
            _wb.addWork((Object)_m);
            while (_wb.hasWork()) {
                Triple _e = (Triple)_wb.getWork();
                Collection _enclosingMonitorTriples = this.monitorInfo.getEnclosingMonitorTriples((Stmt)_m.getFirst(), (SootMethod)_m.getThird(), false);
                _sng.addEdgeFromTo((Object)_e, _enclosingMonitorTriples);
                _wb.addAllWork(_enclosingMonitorTriples);
            }
        }
        for (Triple _m1 : _processed) {
            for (Triple _m2 : _processed) {
                if (_m1 == _m2 || !this.areMonitorsRelated((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)_m1, (Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)_m2)) continue;
                _sng.addEdgeFromTo((Object)_m1, (Object)_m2);
            }
        }
        _sng.finishBuilding();
        SimpleNodeGraph _sn = (SimpleNodeGraph)_sng.getBuiltGraph();
        for (List _nodes : _sn.getSCCs(true)) {
            for (SimpleNode _node : _nodes) {
                _result.add((Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>)((Triple)_sn.getObjectExtractor().transform((Object)_node)));
            }
        }
        return _result;
    }

    private boolean areMonitorsRelated(Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> m1, Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod> m2) {
        boolean _result = false;
        SootMethod _sm1 = (SootMethod)m1.getThird();
        SootMethod _sm2 = (SootMethod)m2.getThird();
        Pair _p1 = new Pair((Object)((Stmt)m1.getSecond()), (Object)((SootMethod)m1.getThird()));
        Pair _p2 = new Pair((Object)((Stmt)m2.getSecond()), (Object)((SootMethod)m2.getThird()));
        if (this.lbe == null || this.lbe.getLockAcquisitionsInEquivalenceClassOf((Pair<Stmt, SootMethod>)_p1).contains(_p2)) {
            Context _ctxt = new Context();
            if (m1.getFirst() == null && m2.getFirst() == null) {
                if (_sm1.isStatic() && _sm2.isStatic()) {
                    _result = _sm1.getDeclaringClass().equals(_sm2.getDeclaringClass());
                } else if (!_sm1.isStatic() && !_sm2.isStatic()) {
                    _ctxt.setRootMethod(_sm1);
                    Collection<Value> _c1 = this.ofa.getValuesForThis(_ctxt);
                    _ctxt.setRootMethod(_sm2);
                    Collection<Value> _c2 = this.ofa.getValuesForThis(_ctxt);
                    _result = CollectionUtils.containsAny(_c1, _c2) && (this.escapeInfo == null || this.escapeInfo.escapes(_sm2.getDeclaringClass(), _sm2) && this.escapeInfo.escapes(_sm1.getDeclaringClass(), _sm1));
                }
            } else {
                Collection<Value> _c2;
                Collection<Value> _c1;
                boolean _flag1 = true;
                boolean _flag2 = true;
                if (m1.getFirst() == null) {
                    if (_sm1.isStatic()) {
                        _c1 = Collections.emptySet();
                    } else {
                        _ctxt.setRootMethod(_sm1);
                        _c1 = this.ofa.getValuesForThis(_ctxt);
                        _flag1 = this.escapeInfo == null || this.escapeInfo.escapes(_sm1.getDeclaringClass(), _sm1);
                    }
                } else {
                    _ctxt.setRootMethod(_sm1);
                    _ctxt.setStmt((Stmt)m1.getFirst());
                    _ctxt.setProgramPoint(((EnterMonitorStmt)m1.getFirst()).getOpBox());
                    _c1 = this.ofa.getValues(((EnterMonitorStmt)m1.getFirst()).getOp(), _ctxt);
                    boolean bl = _flag1 = this.escapeInfo == null || this.escapeInfo.escapes(((EnterMonitorStmt)m1.getFirst()).getOp(), _sm1);
                }
                if (m2.getFirst() == null) {
                    if (_sm2.isStatic()) {
                        _c2 = Collections.emptySet();
                    } else {
                        _ctxt.setRootMethod(_sm2);
                        _c2 = this.ofa.getValuesForThis(_ctxt);
                        _flag2 = this.escapeInfo == null || this.escapeInfo.escapes(_sm2.getDeclaringClass(), _sm2);
                    }
                } else {
                    _ctxt.setRootMethod(_sm2);
                    _ctxt.setStmt((Stmt)m2.getFirst());
                    _ctxt.setProgramPoint(((EnterMonitorStmt)m2.getFirst()).getOpBox());
                    _c2 = this.ofa.getValues(((EnterMonitorStmt)m2.getFirst()).getOp(), _ctxt);
                    _flag2 = this.escapeInfo == null || this.escapeInfo.escapes(((EnterMonitorStmt)m2.getFirst()).getOp(), _sm2);
                }
                _result = _flag1 && _flag2 && CollectionUtils.containsAny(_c1, _c2);
            }
        }
        return _result;
    }
}

