/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.cfg;

import edu.ksu.cis.indus.common.collections.FactoryBasedLazyMap;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticFieldUseDefInfo
extends AbstractProcessor
implements IUseDefInfo<Pair<DefinitionStmt, SootMethod>, Pair<Stmt, SootMethod>> {
    private final Map<SootField, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<Stmt, SootMethod>>>> def2usesMap = new HashMap<SootField, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<Stmt, SootMethod>>>>();
    private final Map<SootField, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<Stmt, SootMethod>>>> def2usesMapShadow = new FactoryBasedLazyMap(this.def2usesMap, MapUtils.getFactory());
    private final Map<SootField, Map<Pair<Stmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>> use2defsMap = new HashMap<SootField, Map<Pair<Stmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>>();
    private final Map<SootField, Map<Pair<Stmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>> use2defsMapShadow = new FactoryBasedLazyMap(this.use2defsMap, MapUtils.getFactory());

    public StaticFieldUseDefInfo() {
        this.unstable();
    }

    public void callback(ValueBox vBox, Context context) {
        StaticFieldRef _value = (StaticFieldRef)vBox.getValue();
        Stmt _stmt = context.getStmt();
        SootMethod _currentMethod = context.getCurrentMethod();
        SootField _field = _value.getField();
        if (_stmt.getUseBoxes().contains(vBox)) {
            Map<Pair<Stmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>> _temp = this.use2defsMapShadow.get(_field);
            _temp.put((Pair<Stmt, SootMethod>)new Pair((Object)_stmt, (Object)_currentMethod), null);
        } else {
            Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<Stmt, SootMethod>>> _temp = this.def2usesMapShadow.get(_field);
            _temp.put((Pair<DefinitionStmt, SootMethod>)new Pair((Object)((DefinitionStmt)_stmt), (Object)_currentMethod), null);
        }
    }

    public void consolidate() {
        Collection _keySet = SetUtils.intersection((Collection)this.def2usesMap.keySet(), (Collection)this.use2defsMap.keySet());
        Iterator _i = _keySet.iterator();
        int _iEnd = _keySet.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootField _field = (SootField)_i.next();
            Map _defsite2uses = MapUtils.getMapFromMap(this.def2usesMap, (Object)_field);
            Map _usesite2defs = MapUtils.getMapFromMap(this.use2defsMap, (Object)_field);
            Set _usesiteKeySet = _usesite2defs.keySet();
            Set _defsiteKeySet = _defsite2uses.keySet();
            if (!_defsiteKeySet.isEmpty() && !_usesiteKeySet.isEmpty()) {
                Iterator _j = _usesiteKeySet.iterator();
                int _jEnd = _usesiteKeySet.size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    _usesite2defs.put((Pair)_j.next(), _defsiteKeySet);
                    ++_jIndex;
                }
                Iterator _k = _defsiteKeySet.iterator();
                int _kEnd = _defsiteKeySet.size();
                int _kIndex = 0;
                while (_kIndex < _kEnd) {
                    _defsite2uses.put((Pair)_k.next(), _usesiteKeySet);
                    ++_kIndex;
                }
            }
            ++_iIndex;
        }
    }

    public Collection<Pair<DefinitionStmt, SootMethod>> getDefs(Local local, Stmt useStmt, SootMethod method) {
        return Collections.emptySet();
    }

    public Collection<Pair<DefinitionStmt, SootMethod>> getDefs(Stmt useStmt, SootMethod method) {
        Collection _result;
        if (useStmt.containsFieldRef()) {
            FieldRef _fieldRef = useStmt.getFieldRef();
            Map _temp = MapUtils.queryMap(this.use2defsMap, (Object)_fieldRef.getField());
            _result = MapUtils.queryCollection((Map)_temp, (Object)new Pair((Object)useStmt, (Object)method));
        } else {
            _result = Collections.emptySet();
        }
        return _result;
    }

    public Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(GLOBAL_USE_DEF_ID);
    }

    public Collection<Pair<Stmt, SootMethod>> getUses(DefinitionStmt defStmt, SootMethod method) {
        Collection _result;
        if (defStmt.containsFieldRef()) {
            FieldRef _fieldRef = defStmt.getFieldRef();
            Map _temp = MapUtils.queryMap(this.def2usesMap, (Object)_fieldRef.getField());
            _result = MapUtils.queryCollection((Map)_temp, (Object)new Pair((Object)defStmt, (Object)method));
        } else {
            _result = Collections.emptySet();
        }
        return _result;
    }

    public void hookup(ProcessingController ppc) {
        ppc.register(StaticFieldRef.class, (IProcessor)this);
    }

    public void processingBegins() {
        this.unstable();
    }

    public void reset() {
        this.unstable();
        this.def2usesMap.clear();
        this.use2defsMap.clear();
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("Statistics for Static Field Reference Based Use Def analysis as calculated by " + ((Object)((Object)this)).getClass().getName() + "\n");
        int _edgeCount = 0;
        StringBuffer _temp = new StringBuffer();
        for (Map.Entry<SootField, Map<Pair<Stmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>> _entry : this.use2defsMap.entrySet()) {
            SootField _entity = _entry.getKey();
            _result.append("For " + _entity + "\n ");
            for (Map.Entry<Pair<Stmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>> _entry1 : _entry.getValue().entrySet()) {
                Pair<Stmt, SootMethod> _use = _entry1.getKey();
                Collection<Pair<DefinitionStmt, SootMethod>> _defs = _entry1.getValue();
                int _localEdgeCount = 0;
                if (_defs != null) {
                    for (Pair<DefinitionStmt, SootMethod> _def : _defs) {
                        _temp.append("\t\t" + _use + " <== " + _def + "\n");
                    }
                    _localEdgeCount += _defs.size();
                }
                Pair<Stmt, SootMethod> _key = _entry1.getKey();
                _result.append("\tFor " + _key + "[");
                if (_key != null) {
                    _result.append(_key.hashCode());
                } else {
                    _result.append(0);
                }
                _result.append("] there are " + _localEdgeCount + " use-defs.\n");
                _result.append(_temp);
                _temp.delete(0, _temp.length());
                _edgeCount += _localEdgeCount;
            }
        }
        _result.append("A total of " + _edgeCount + " use-defs.");
        return _result.toString();
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister(StaticFieldRef.class, (IProcessor)this);
        this.stable();
    }
}

