/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.cfg;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.FIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalUseDefAnalysisv2
implements IUseDefInfo<DefinitionStmt, Pair<Local, Stmt>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalUseDefAnalysisv2.class);
    private BasicBlockGraph bbGraph;
    private final Map<Pair<Local, Stmt>, Collection<DefinitionStmt>> defInfo = new HashMap<Pair<Local, Stmt>, Collection<DefinitionStmt>>();
    private final Map<DefinitionStmt, Collection<Pair<Local, Stmt>>> useInfo = new HashMap<DefinitionStmt, Collection<Pair<Local, Stmt>>>();

    public LocalUseDefAnalysisv2(BasicBlockGraph graph) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Analyzing " + graph.getStmtGraph().getBody().getMethod());
        }
        Body _body = graph.getStmtGraph().getBody();
        ArrayList<Local> _listOfLocals = new ArrayList<Local>();
        _listOfLocals.addAll((Collection<Local>)_body.getLocals());
        this.bbGraph = graph;
        this.analyze(_listOfLocals);
        this.bbGraph = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Analyzing " + graph.getStmtGraph().getBody().getMethod());
        }
    }

    @Empty
    private LocalUseDefAnalysisv2() {
    }

    public Collection<DefinitionStmt> getDefs(Local local, Stmt stmt, SootMethod method) {
        return Collections.unmodifiableCollection(MapUtils.queryCollection(this.defInfo, (Object)new Pair((Object)local, (Object)stmt)));
    }

    public Collection<DefinitionStmt> getDefs(Stmt useStmt, SootMethod method) {
        HashSet<DefinitionStmt> _result = new HashSet<DefinitionStmt>();
        for (ValueBox _vb : useStmt.getUseBoxes()) {
            Value _value = _vb.getValue();
            if (!(_value instanceof Local)) continue;
            _result.addAll(this.getDefs((Local)_value, useStmt, null));
        }
        return _result;
    }

    public Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(IUseDefInfo.LOCAL_USE_DEF_ID);
    }

    public Collection<Pair<Local, Stmt>> getUses(DefinitionStmt stmt, SootMethod method) {
        return MapUtils.queryCollection(this.useInfo, (Object)stmt);
    }

    public boolean isStable() {
        return true;
    }

    private void analyze(List<Local> listOfLocals) {
        FIFOWorkBag _wb = new FIFOWorkBag();
        HashMap<BasicBlockGraph.BasicBlock, Map<Local, DefinitionStmt>> _intrabb2local2defStmt = new HashMap<BasicBlockGraph.BasicBlock, Map<Local, DefinitionStmt>>();
        final HashMap<DefinitionStmt, Local> _defStmt2local = new HashMap<DefinitionStmt, Local>();
        HashMap<BasicBlockGraph.BasicBlock, Collection<DefinitionStmt>> _bb2reachingDefStmts = new HashMap<BasicBlockGraph.BasicBlock, Collection<DefinitionStmt>>();
        ArrayList _defsExitingBB = new ArrayList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("calculating definition basic blocks.");
        }
        _wb.addAllWork(this.seedDefInfo(listOfLocals, _intrabb2local2defStmt, _defStmt2local));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("propagating information across basic blocks.");
        }
        while (_wb.hasWork()) {
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_wb.getWork();
            _defsExitingBB.clear();
            _defsExitingBB.addAll(MapUtils.getCollectionFromMap(_bb2reachingDefStmts, (Object)_bb));
            final Map _intraBBLocal2defStmt = (Map)_intrabb2local2defStmt.get(_bb);
            if (_intraBBLocal2defStmt != null) {
                CollectionUtils.filter(_defsExitingBB, (IPredicate)new IPredicate<DefinitionStmt>(){

                    public boolean evaluate(DefinitionStmt object) {
                        return _intraBBLocal2defStmt.get(_defStmt2local.get(object)) == null;
                    }
                });
                _defsExitingBB.addAll(_intraBBLocal2defStmt.values());
            }
            Iterator _i = _bb.getSuccsOf().iterator();
            int _iEnd = _bb.getSuccsOf().size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                BasicBlockGraph.BasicBlock _succBB = (BasicBlockGraph.BasicBlock)_i.next();
                Collection _defsReachingSuccBB = MapUtils.getCollectionFromMap(_bb2reachingDefStmts, (Object)_succBB);
                if (!_defsReachingSuccBB.containsAll(_defsExitingBB)) {
                    _defsReachingSuccBB.addAll(_defsExitingBB);
                    _wb.addWorkNoDuplicates((Object)_succBB);
                }
                ++_iIndex;
            }
        }
        this.calculateIntraBBUseDefInfo(_defStmt2local, _bb2reachingDefStmts);
    }

    private void calculateIntraBBUseDefInfo(Map<DefinitionStmt, Local> defStmt2local, Map<BasicBlockGraph.BasicBlock, Collection<DefinitionStmt>> bb2reachingDefStmts) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("calculating information at intra bb level and record the use-def information.");
        }
        Pair.PairManager _pairMgr = new Pair.PairManager(false, true);
        Map _local2defStmts = MapUtils.invertMap(defStmt2local);
        Collection _keySet = bb2reachingDefStmts.keySet();
        Iterator _i = _keySet.iterator();
        int _iEnd = _keySet.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_i.next();
            Collection<DefinitionStmt> _rDefs = bb2reachingDefStmts.get(_bb);
            List _stmtsOf = _bb.getStmtsOf();
            Iterator _j = _stmtsOf.iterator();
            int _jEnd = _stmtsOf.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Stmt _stmt = (Stmt)_j.next();
                List _useBoxes = _stmt.getUseBoxes();
                Iterator _k = _useBoxes.iterator();
                int _kEnd = _useBoxes.size();
                int _kIndex = 0;
                while (_kIndex < _kEnd) {
                    ValueBox _vb = (ValueBox)_k.next();
                    Value _value = _vb.getValue();
                    if (_value instanceof Local) {
                        Pair _pair = _pairMgr.getPair((Object)((Local)_value), (Object)_stmt);
                        Collection _d = SetUtils.intersection((Collection)((Collection)_local2defStmts.get(_value)), _rDefs);
                        this.defInfo.put((Pair<Local, Stmt>)_pair, _d);
                        for (DefinitionStmt _defStmt : _d) {
                            MapUtils.putIntoCollectionInMap(this.useInfo, (Object)_defStmt, (Object)_pair);
                        }
                    }
                    ++_kIndex;
                }
                if (defStmt2local.containsKey(_stmt)) {
                    _rDefs.removeAll((Collection)_local2defStmts.get(defStmt2local.get(_stmt)));
                    _rDefs.add((DefinitionStmt)_stmt);
                }
                ++_jIndex;
            }
            ++_iIndex;
        }
    }

    private Collection<BasicBlockGraph.BasicBlock> seedDefInfo(List<Local> listOfLocals, Map<BasicBlockGraph.BasicBlock, Map<Local, DefinitionStmt>> intraBB2local2exitDefStmts, Map<DefinitionStmt, Local> defStmt2local) {
        HashSet<BasicBlockGraph.BasicBlock> _defBBs = new HashSet<BasicBlockGraph.BasicBlock>();
        for (Stmt _stmt : this.bbGraph.getStmtGraph()) {
            DefinitionStmt _defStmt;
            Value _leftOp;
            if (!(_stmt instanceof DefinitionStmt) || !((_leftOp = (_defStmt = (DefinitionStmt)_stmt).getLeftOp()) instanceof Local)) continue;
            BasicBlockGraph.BasicBlock _enclosingBlock = this.bbGraph.getEnclosingBlock((Stmt)_defStmt);
            if (_enclosingBlock != null) {
                _defBBs.add(_enclosingBlock);
                defStmt2local.put(_defStmt, (Local)_leftOp);
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn(_defStmt + " in " + this.bbGraph.getStmtGraph().getBody().getMethod() + " is not enclosed " + "by a basic block!");
        }
        int _numOfLocals = listOfLocals.size();
        HashMap<Local, DefinitionStmt> _local2def = new HashMap<Local, DefinitionStmt>(_numOfLocals);
        Iterator _i = _defBBs.iterator();
        int _iEnd = _defBBs.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_i.next();
            List _stmtsOf = _bb.getStmtsOf();
            Iterator _j = _stmtsOf.iterator();
            int _jEnd = _stmtsOf.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                DefinitionStmt _defStmt;
                Stmt _stmt = (Stmt)_j.next();
                if (_stmt instanceof DefinitionStmt && (_defStmt = (DefinitionStmt)_stmt).getLeftOp() instanceof Local) {
                    _local2def.put((Local)_defStmt.getLeftOp(), _defStmt);
                }
                ++_jIndex;
            }
            intraBB2local2exitDefStmts.put(_bb, _local2def);
            _local2def = new HashMap(_numOfLocals);
            ++_iIndex;
        }
        return intraBB2local2exitDefStmts.keySet();
    }
}

