/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.cfg;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.FIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.PatchingChain;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalUseDefAnalysis
implements IUseDefInfo<DefinitionStmt, Pair<Local, Stmt>> {
    private final Map<Pair<Local, Stmt>, Collection<DefinitionStmt>> defInfo = new HashMap<Pair<Local, Stmt>, Collection<DefinitionStmt>>();
    private List<Stmt> stmtList;
    private UnitGraph unitGraph;
    private final Map<DefinitionStmt, Collection<Pair<Local, Stmt>>> useInfo = new HashMap<DefinitionStmt, Collection<Pair<Local, Stmt>>>();

    public LocalUseDefAnalysis(UnitGraph graph) {
        Body _body = graph.getBody();
        PatchingChain _stmts = _body.getUnits();
        BitSet[][] _l2defs = new BitSet[_stmts.size()][_body.getLocalCount()];
        this.stmtList = new ArrayList<Stmt>();
        this.stmtList.addAll((Collection<Stmt>)_stmts);
        ArrayList<Local> _listOfLocals = new ArrayList<Local>();
        _listOfLocals.addAll((Collection<Local>)_body.getLocals());
        this.unitGraph = graph;
        this.analyze(_l2defs, _listOfLocals);
        this.extract(_l2defs, _listOfLocals);
        this.unitGraph = null;
        this.stmtList = null;
    }

    public Collection<DefinitionStmt> getDefs(Local local, Stmt stmt, SootMethod method) {
        return Collections.unmodifiableCollection(MapUtils.queryCollection(this.defInfo, (Object)new Pair((Object)local, (Object)stmt)));
    }

    public Collection<DefinitionStmt> getDefs(Stmt useStmt, SootMethod method) {
        HashSet<DefinitionStmt> _result = new HashSet<DefinitionStmt>();
        for (ValueBox _vb : useStmt.getUseBoxes()) {
            Value _value = _vb.getValue();
            if (!(_value instanceof Local)) continue;
            _result.addAll(this.getDefs((Local)_value, useStmt, null));
        }
        return _result;
    }

    public Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(IUseDefInfo.LOCAL_USE_DEF_ID);
    }

    public Collection<Pair<Local, Stmt>> getUses(DefinitionStmt stmt, SootMethod method) {
        return MapUtils.queryCollection(this.useInfo, (Object)stmt);
    }

    public boolean isStable() {
        return true;
    }

    private void analyze(BitSet[][] local2defs, List<Local> listOfLocals) {
        FIFOWorkBag _wb = new FIFOWorkBag();
        BitSet _temp = new BitSet();
        HashMap<Stmt, Collection<Integer>> _stmt2localIndices = new HashMap<Stmt, Collection<Integer>>();
        _wb.addAllWork(this.seedDefInfo(local2defs, listOfLocals, _stmt2localIndices));
        while (_wb.hasWork()) {
            Value _leftOp;
            Stmt _stmt = (Stmt)_wb.getWork();
            BitSet[] _defsAtStmt = local2defs[this.stmtList.indexOf(_stmt)];
            Collection _localIndices = (Collection)_stmt2localIndices.get(_stmt);
            if (_stmt instanceof DefinitionStmt && (_leftOp = ((DefinitionStmt)_stmt).getLeftOp()) instanceof Local) {
                _localIndices.remove(new Integer(listOfLocals.indexOf(_leftOp)));
            }
            for (Integer _localIndexValue : _localIndices) {
                int _localIndex = _localIndexValue;
                BitSet _defsOfLocalAtStmt = _defsAtStmt[_localIndex];
                for (Stmt _succ : this.unitGraph.getSuccsOf((Object)_stmt)) {
                    int _succIndex = this.stmtList.indexOf(_succ);
                    BitSet[] _defsAtSucc = local2defs[_succIndex];
                    if (_defsAtSucc[_localIndex] == null) {
                        _defsAtSucc[_localIndex] = new BitSet();
                    }
                    _temp.clear();
                    _temp.or(_defsOfLocalAtStmt);
                    _temp.andNot(_defsAtSucc[_localIndex]);
                    if (_temp.cardinality() <= 0) continue;
                    _defsAtSucc[_localIndex].or(_defsOfLocalAtStmt);
                    _wb.addWorkNoDuplicates((Object)_succ);
                    ((Collection)_stmt2localIndices.get(_succ)).add(_localIndexValue);
                }
            }
            _localIndices.clear();
        }
    }

    private void extract(BitSet[][] local2defs, List<Local> localList) {
        Pair.PairManager _pairMgr = new Pair.PairManager(false, true);
        for (Stmt _stmt : this.unitGraph) {
            int _stmtIndex = this.stmtList.indexOf(_stmt);
            BitSet[] _stmtDefSet = local2defs[_stmtIndex];
            for (ValueBox _ub : _stmt.getUseBoxes()) {
                if (!(_ub.getValue() instanceof Local)) continue;
                Local _local = (Local)_ub.getValue();
                Pair _pair = _pairMgr.getPair((Object)_local, (Object)_stmt);
                int _lindex = localList.indexOf(_local);
                BitSet _defs = _stmtDefSet[_lindex];
                if (_defs == null || _defs.isEmpty()) continue;
                int _k = _defs.nextSetBit(0);
                while (_k >= 0) {
                    DefinitionStmt _defStmt = (DefinitionStmt)this.stmtList.get(_k);
                    Local _l = (Local)_defStmt.getLeftOp();
                    if (_l == _local) {
                        MapUtils.putIntoCollectionInMap(this.useInfo, (Object)_defStmt, (Object)_pair);
                        MapUtils.putIntoCollectionInMap(this.defInfo, (Object)_pair, (Object)_defStmt);
                    }
                    _k = _defs.nextSetBit(_k + 1);
                }
            }
        }
    }

    private Collection<Stmt> seedDefInfo(BitSet[][] local2defs, List<Local> listOfLocals, Map<Stmt, Collection<Integer>> stmt2localIndices) {
        ArrayList<Stmt> _result = new ArrayList<Stmt>();
        ArrayList<DefinitionStmt> _defStmts = new ArrayList<DefinitionStmt>();
        for (Stmt stmt : this.unitGraph) {
            stmt2localIndices.put(stmt, new HashSet());
            if (!(stmt instanceof DefinitionStmt)) continue;
            _defStmts.add((DefinitionStmt)stmt);
        }
        for (DefinitionStmt definitionStmt : _defStmts) {
            Value _value = definitionStmt.getLeftOp();
            if (!(_value instanceof Local) || !listOfLocals.contains(_value)) continue;
            int _localIndex = listOfLocals.indexOf(_value);
            int _stmtIndex = this.stmtList.indexOf(definitionStmt);
            for (Stmt _succ : this.unitGraph.getSuccsOf((Object)definitionStmt)) {
                int _succIndex = this.stmtList.indexOf(_succ);
                BitSet _temp = local2defs[_succIndex][_localIndex];
                if (_temp == null) {
                    local2defs[_succIndex][_localIndex] = _temp = new BitSet();
                }
                _temp.set(_stmtIndex, true);
                _result.add(_succ);
                stmt2localIndices.get(_succ).add(new Integer(_localIndex));
            }
        }
        return _result;
    }
}

