/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.cfg;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IExceptionRaisingInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.TrapManager;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.CastExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionRaisingAnalysis
extends AbstractProcessor
implements IExceptionRaisingInfo {
    private static final String JAVA_LANG_ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION = "java.lang.ArrayIndexOutOfBoundsException";
    private static final String JAVA_LANG_ARRAY_STORE_EXCEPTION = "java.lang.ArrayStoreException";
    private static final String JAVA_LANG_CLASS_CAST_EXCEPTION = "java.lang.ClassCastException";
    private static final String JAVA_LANG_ILLEGAL_ACCESS_ERROR = "java.lang.IllegalAccessError";
    private static final String JAVA_LANG_INSTANTIATION_ERROR = "java.lang.InstantiationError";
    private static final String JAVA_LANG_NEGATIVE_ARRAY_SIZE_EXCEPTION = "java.lang.NegativeArraySizeException";
    private static final String JAVA_LANG_NO_SUCH_METHOD_EXCEPTION = "java.lang.NoSuchMethodException";
    private static final String JAVA_LANG_NULL_POINTER_EXCEPTION = "java.lang.NullPointerException";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionRaisingAnalysis.class);
    private final Map<Class<?>, Collection<String>> astNodeType2thrownTypeNames = new HashMap();
    private final ICallGraphInfo cgi;
    private final IEnvironment env;
    private final Map<SootMethod, Map<Stmt, Collection<SootClass>>> method2stmt2exceptions = new HashMap<SootMethod, Map<Stmt, Collection<SootClass>>>();
    private final Map<SootMethod, Map<Stmt, Collection<SootClass>>> method2stmt2uncaughtExceptions = new HashMap<SootMethod, Map<Stmt, Collection<SootClass>>>();
    private IStmtGraphFactory<?> stmtGraphFactory;
    private final IWorkBag<Triple<Stmt, SootMethod, SootClass>> workbagCache;

    public ExceptionRaisingAnalysis(IStmtGraphFactory factory, ICallGraphInfo callgraph, IEnvironment environment) {
        this.stmtGraphFactory = factory;
        this.cgi = callgraph;
        this.workbagCache = new HistoryAwareFIFOWorkBag(new ArrayList());
        this.env = environment;
    }

    public void callback(Stmt stmt, Context context) {
        SootMethod _method = context.getCurrentMethod();
        Map _stmt2exceptions = MapUtils.getMapFromMap(this.method2stmt2exceptions, (Object)_method);
        Collection _thrownTypes = MapUtils.getCollectionFromMap((Map)_stmt2exceptions, (Object)stmt);
        if (stmt instanceof ThrowStmt) {
            SootClass _thrownType = ((RefType)((ThrowStmt)stmt).getOp().getType()).getSootClass();
            this.processStmt(stmt, _method, _thrownTypes, _thrownType);
        } else if (stmt.containsInvokeExpr()) {
            Collection _callees = this.cgi.getCallees(stmt.getInvokeExpr(), context);
            Iterator _i = _callees.iterator();
            int _iEnd = _callees.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                SootMethod _callee = (SootMethod)_i.next();
                Iterator _j = _callee.getExceptions().iterator();
                int _jEnd = _callee.getExceptions().size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    SootClass _thrownType = (SootClass)_j.next();
                    this.processStmt(stmt, _method, _thrownTypes, _thrownType);
                    ++_jIndex;
                }
                ++_iIndex;
            }
        }
    }

    public void callback(ValueBox vb, Context context) {
        Value _v = vb.getValue();
        Stmt _stmt = context.getStmt();
        SootMethod _method = context.getCurrentMethod();
        Collection<String> _c = this.getExceptionTypeNamesFor(_v.getClass());
        Iterator<String> _i = _c.iterator();
        int _iEnd = _c.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            String _typeName = _i.next();
            SootClass _sc = this.env.getClass(_typeName);
            if (this.isThrownExceptionNotCaught(_stmt, _method, _sc)) {
                this.workbagCache.addWorkNoDuplicates((Object)new Triple((Object)_stmt, (Object)_method, (Object)_sc));
            }
            ++_iIndex;
        }
    }

    public void consolidate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("consolidate() - BEGIN");
        }
        super.consolidate();
        while (this.workbagCache.hasWork()) {
            Triple _triple = (Triple)this.workbagCache.getWork();
            Stmt _stmt = (Stmt)_triple.getFirst();
            SootMethod _method = (SootMethod)_triple.getSecond();
            SootClass _thrownType = (SootClass)_triple.getThird();
            Collection _callers = this.cgi.getCallers(_method);
            Iterator _j = _callers.iterator();
            int _jEnd = _callers.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                ICallGraphInfo.CallTriple _ctrp = (ICallGraphInfo.CallTriple)_j.next();
                SootMethod _caller = _ctrp.getMethod();
                Stmt _callingStmt = _ctrp.getStmt();
                if (this.isThrownExceptionNotCaught(_callingStmt, _caller, _thrownType)) {
                    this.workbagCache.addWorkNoDuplicates((Object)new Triple((Object)_callingStmt, (Object)_caller, (Object)_thrownType));
                }
                ++_jIndex;
            }
            MapUtils.putIntoCollectionInMap((Map)MapUtils.getMapFromMap(this.method2stmt2uncaughtExceptions, (Object)_method), (Object)_stmt, (Object)_thrownType);
        }
        this.workbagCache.clear();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("consolidate() - END - method-to-stmt-to-throwntypes - " + MapUtils.verbosePrint(this.method2stmt2uncaughtExceptions));
        }
    }

    public boolean doesStmtThrowUncaughtException(Stmt stmt, SootMethod method) {
        Map _map = MapUtils.queryMap(this.method2stmt2uncaughtExceptions, (Object)method);
        return _map.containsKey(stmt);
    }

    public Collection<SootClass> getExceptionsThrownBy(Stmt stmt, SootMethod method) {
        Map _map = MapUtils.queryMap(this.method2stmt2exceptions, (Object)method);
        Collection _col1 = MapUtils.queryCollection((Map)_map, (Object)stmt);
        Collection<SootClass> _col2 = this.getUncaughtExceptionsThrownBy(stmt, method);
        return SetUtils.union((Collection)_col1, _col2);
    }

    public Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(ID);
    }

    public Collection<SootClass> getUncaughtExceptionsThrownBy(Stmt stmt, SootMethod method) {
        Map _map = MapUtils.queryMap(this.method2stmt2uncaughtExceptions, (Object)method);
        return MapUtils.queryCollection((Map)_map, (Object)stmt);
    }

    public void hookup(ProcessingController ppc) {
        ppc.registerForAllStmts((IProcessor)this);
        Collection _c = this.astNodeType2thrownTypeNames.keySet();
        Iterator _i = _c.iterator();
        int _iEnd = _c.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            ppc.register((Class)_i.next(), (IProcessor)this);
            ++_iIndex;
        }
    }

    public void reset() {
        super.reset();
        this.method2stmt2uncaughtExceptions.clear();
        this.method2stmt2exceptions.clear();
        this.astNodeType2thrownTypeNames.clear();
    }

    public void setupForCommonUncheckedExceptions() {
        this.toggleExceptionsToTrack(ArrayRef.class, JAVA_LANG_ARRAY_STORE_EXCEPTION, true);
        this.toggleExceptionsToTrack(ArrayRef.class, JAVA_LANG_ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION, true);
        this.toggleExceptionsToTrack(ArrayRef.class, JAVA_LANG_NULL_POINTER_EXCEPTION, true);
        this.toggleExceptionsToTrack(NewExpr.class, JAVA_LANG_INSTANTIATION_ERROR, true);
        this.toggleExceptionsToTrack(NewArrayExpr.class, JAVA_LANG_NEGATIVE_ARRAY_SIZE_EXCEPTION, true);
        this.toggleExceptionsToTrack(NewArrayExpr.class, JAVA_LANG_INSTANTIATION_ERROR, true);
        this.toggleExceptionsToTrack(NewMultiArrayExpr.class, JAVA_LANG_NEGATIVE_ARRAY_SIZE_EXCEPTION, true);
        this.toggleExceptionsToTrack(NewMultiArrayExpr.class, JAVA_LANG_INSTANTIATION_ERROR, true);
        this.toggleExceptionsToTrack(InstanceFieldRef.class, JAVA_LANG_NULL_POINTER_EXCEPTION, true);
        this.toggleExceptionsToTrack(InstanceFieldRef.class, JAVA_LANG_ILLEGAL_ACCESS_ERROR, true);
        this.toggleExceptionsToTrack(StaticFieldRef.class, JAVA_LANG_ILLEGAL_ACCESS_ERROR, true);
        this.toggleExceptionsToTrack(CastExpr.class, JAVA_LANG_CLASS_CAST_EXCEPTION, true);
        this.toggleExceptionsToTrack(VirtualInvokeExpr.class, JAVA_LANG_NULL_POINTER_EXCEPTION, true);
        this.toggleExceptionsToTrack(VirtualInvokeExpr.class, JAVA_LANG_NO_SUCH_METHOD_EXCEPTION, true);
        this.toggleExceptionsToTrack(VirtualInvokeExpr.class, JAVA_LANG_ILLEGAL_ACCESS_ERROR, true);
        this.toggleExceptionsToTrack(SpecialInvokeExpr.class, JAVA_LANG_NULL_POINTER_EXCEPTION, true);
        this.toggleExceptionsToTrack(SpecialInvokeExpr.class, JAVA_LANG_NO_SUCH_METHOD_EXCEPTION, true);
        this.toggleExceptionsToTrack(SpecialInvokeExpr.class, JAVA_LANG_ILLEGAL_ACCESS_ERROR, true);
        this.toggleExceptionsToTrack(InterfaceInvokeExpr.class, JAVA_LANG_NULL_POINTER_EXCEPTION, true);
        this.toggleExceptionsToTrack(InterfaceInvokeExpr.class, JAVA_LANG_NO_SUCH_METHOD_EXCEPTION, true);
        this.toggleExceptionsToTrack(InterfaceInvokeExpr.class, JAVA_LANG_ILLEGAL_ACCESS_ERROR, true);
        this.toggleExceptionsToTrack(StaticInvokeExpr.class, JAVA_LANG_NO_SUCH_METHOD_EXCEPTION, true);
        this.toggleExceptionsToTrack(StaticInvokeExpr.class, JAVA_LANG_ILLEGAL_ACCESS_ERROR, true);
    }

    public void toggleExceptionsToTrack(Class<? extends Value> astNodeType, String exceptionName, boolean consider) {
        if (consider) {
            MapUtils.putIntoCollectionInMap(this.astNodeType2thrownTypeNames, astNodeType, (Object)exceptionName);
        } else {
            Collection _typeNames = MapUtils.queryCollection(this.astNodeType2thrownTypeNames, astNodeType);
            _typeNames.remove(exceptionName);
        }
    }

    public String toString() {
        StringBuffer _sb = new StringBuffer();
        _sb.append("Caught+Uncaught Exception info ");
        _sb.append(MapUtils.verbosePrint(this.method2stmt2exceptions));
        _sb.append("\n");
        _sb.append("Uncaught exception info ");
        _sb.append(MapUtils.verbosePrint(this.method2stmt2uncaughtExceptions));
        _sb.append("\n");
        return _sb.toString();
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregisterForAllStmts((IProcessor)this);
        Collection _c = this.astNodeType2thrownTypeNames.keySet();
        Iterator _i = _c.iterator();
        int _iEnd = _c.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            ppc.unregister((Class)_i.next(), (IProcessor)this);
            ++_iIndex;
        }
    }

    private Collection<String> getExceptionTypeNamesFor(Class<? extends Value> c) {
        Collection<String> _result = Collections.emptySet();
        Set<Class<?>> _keySet = this.astNodeType2thrownTypeNames.keySet();
        Iterator<Class<?>> _i = _keySet.iterator();
        int _iEnd = _keySet.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Class<? extends Value> _nodeType = _i.next();
            if (_nodeType.isAssignableFrom(c)) {
                _result = this.astNodeType2thrownTypeNames.get(_nodeType);
                break;
            }
            ++_iIndex;
        }
        return _result;
    }

    private boolean isThrownExceptionNotCaught(Stmt stmt, SootMethod method, SootClass thrownType) {
        UnitGraph _graph = this.stmtGraphFactory.getStmtGraph(method);
        List _succs = _graph.getSuccsOf((Object)stmt);
        boolean _result = true;
        if (!_succs.isEmpty()) {
            boolean _isCaught = false;
            Body _body = _graph.getBody();
            Iterator _i = _succs.iterator();
            int _iEnd = _succs.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd && !_isCaught) {
                Stmt _handler = (Stmt)_i.next();
                Iterator _j = TrapManager.getExceptionTypesOf((Unit)_handler, (Body)_body).iterator();
                int _jEnd = TrapManager.getExceptionTypesOf((Unit)_handler, (Body)_body).size();
                int _jIndex = 0;
                while (_jIndex < _jEnd && !_isCaught) {
                    RefType _caughtType = (RefType)_j.next();
                    _isCaught |= Util.isDescendentOf((SootClass)thrownType, (SootClass)_caughtType.getSootClass());
                    ++_jIndex;
                }
                ++_iIndex;
            }
            _result = !_isCaught;
        }
        return _result;
    }

    private void processStmt(Stmt stmt, SootMethod method, Collection<SootClass> thrownTypes, SootClass thrownType) {
        if (this.isThrownExceptionNotCaught(stmt, method, thrownType)) {
            this.workbagCache.addWorkNoDuplicates((Object)new Triple((Object)stmt, (Object)method, (Object)thrownType));
        } else {
            thrownTypes.add(thrownType);
        }
    }
}

