/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.cfg;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.SootPredicatesAndTransformers;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CFGAnalysis {
    private static final Logger LOGGER = LoggerFactory.getLogger(CFGAnalysis.class);
    private final BasicBlockGraphMgr bbm;
    private final ICallGraphInfo cgi;
    private Map<SootMethod, List<Stmt>> method2EnclosingInvokingStmtsCache = new HashMap<SootMethod, List<Stmt>>();

    public CFGAnalysis(ICallGraphInfo cgiParam, BasicBlockGraphMgr bbmParam) {
        this.cgi = cgiParam;
        this.bbm = bbmParam;
    }

    public boolean checkForLoopEnclosedNewExpr(Stmt newStmt, SootMethod method) {
        boolean _result = false;
        BasicBlockGraph _bbg = this.bbm.getBasicBlockGraph(method);
        if (this.occursInCycle((IDirectedGraph<BasicBlockGraph.BasicBlock>)_bbg, _bbg.getEnclosingBlock(newStmt))) {
            _result = true;
        }
        return _result;
    }

    public boolean doesControlFlowPathExistBetween(SootMethod method, Stmt stmt, SootMethod targetMethod, boolean forward, boolean exclusive) {
        ArrayList _bbDefStmts;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("doesControlFlowPathExistsBetween(SootMethod method = " + method + ", Stmt stmt = " + stmt + ", SootMethod targetMethod = " + targetMethod + ", boolean forward = " + forward + ", boolean exclusive = " + exclusive + ") - BEGIN");
        }
        boolean _result = false;
        BasicBlockGraph _bbg = this.bbm.getBasicBlockGraph(method);
        BasicBlockGraph.BasicBlock _bbDef = _bbg.getEnclosingBlock(stmt);
        if (forward) {
            _bbDefStmts = new ArrayList(_bbDef.getStmtsFrom(stmt));
            if (exclusive) {
                _bbDefStmts.remove(0);
            }
        } else {
            _bbDefStmts = new ArrayList(_bbDef.getStmtsFromTo(_bbDef.getLeaderStmt(), stmt));
            if (exclusive) {
                _bbDefStmts.remove(_bbDefStmts.size() - 1);
            }
        }
        Iterator _j = IteratorUtils.filteredIterator(_bbDefStmts.iterator(), (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE);
        while (_j.hasNext() && !_result) {
            Stmt _stmt = (Stmt)_j.next();
            _result = this.cgi.isCalleeReachableFromCallSite(targetMethod, _stmt, method);
        }
        Iterator _i = _bbg.getReachablesFrom((INode)_bbDef, forward).iterator();
        while (_i.hasNext() && !_result) {
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_i.next();
            Iterator _j2 = IteratorUtils.filteredIterator(_bb.getStmtsOf().iterator(), (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE);
            while (_j2.hasNext() && !_result) {
                Stmt _stmt = (Stmt)_j2.next();
                _result = this.cgi.isCalleeReachableFromCallSite(targetMethod, _stmt, method);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("doesControlFlowPathExistsBetween() - END - return value" + _result);
        }
        return _result;
    }

    public boolean doesControlFlowPathExistBetween(Stmt srcStmt, Stmt destStmt, SootMethod method) {
        List _sl;
        BasicBlockGraph.BasicBlock _bbSrc;
        BasicBlockGraph _bbg = this.bbm.getBasicBlockGraph(method);
        BasicBlockGraph.BasicBlock _bbDest = _bbg.getEnclosingBlock(destStmt);
        boolean _result = _bbDest == (_bbSrc = _bbg.getEnclosingBlock(srcStmt)) ? (_sl = _bbDest.getStmtsOf()).indexOf(srcStmt) < _sl.indexOf(destStmt) : _bbg.isReachable((INode)_bbSrc, (INode)_bbDest, true);
        return _result;
    }

    public boolean doesControlPathExistFromTo(SootMethod srcMethod, SootMethod destMethod) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("doesControlPathExistsFromTo(SootMethod srcMethod = " + srcMethod + ", SootMethod destMethod = " + destMethod + ") - BEGIN");
        }
        boolean _result = false;
        Collection _commonAncestors = this.cgi.getCommonMethodsReachableFrom(srcMethod, false, destMethod, false);
        Iterator _i = _commonAncestors.iterator();
        while (_i.hasNext() && !_result) {
            SootMethod _sm = (SootMethod)_i.next();
            _result = this.doesMethodLiesOnTheDataFlowPathBetween(_sm, srcMethod, destMethod);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("doesControlPathExistsFromTo() - END - return value" + _result);
        }
        return _result;
    }

    public boolean doesMethodLiesOnTheDataFlowPathBetween(SootMethod method, SootMethod srcMethod, SootMethod destMethod) {
        Iterator<Stmt> _invokingStmtIterator;
        boolean _result = false;
        Iterator<Stmt> _j = _invokingStmtIterator = this.getInvokingStmtIteratorFor(method);
        while (_j.hasNext() && !_result) {
            Stmt _stmt = _j.next();
            if (!this.cgi.isCalleeReachableFromCallSite(srcMethod, _stmt, method)) continue;
            _result = this.doesControlFlowPathExistBetween(method, _stmt, destMethod, true, true);
        }
        return _result;
    }

    public boolean executedMultipleTimes(SootMethod method) {
        boolean _result = false;
        Collection _callers = this.cgi.getCallers(method);
        if (_callers.size() > 1) {
            _result = true;
        } else if (_callers.size() == 1) {
            Iterator _i = this.cgi.getSCCs(true).iterator();
            while (_i.hasNext() && !_result) {
                Collection _scc = (Collection)_i.next();
                if (!_scc.contains(method) || _scc.size() <= 1) continue;
                _result = true;
            }
            if (!_result) {
                ICallGraphInfo.CallTriple _ctrp = (ICallGraphInfo.CallTriple)_callers.iterator().next();
                SootMethod _caller = _ctrp.getMethod();
                BasicBlockGraph _bbg = this.bbm.getBasicBlockGraph(_caller);
                _result = this.occursInCycle((IDirectedGraph<BasicBlockGraph.BasicBlock>)_bbg, _bbg.getEnclosingBlock(_ctrp.getStmt())) ? true : this.executedMultipleTimes(_caller);
            }
        }
        return _result;
    }

    public boolean executedMultipleTimes(Stmt stmt, SootMethod caller) {
        BasicBlockGraph _bbg = this.bbm.getBasicBlockGraph(caller);
        return this.occursInCycle((IDirectedGraph<BasicBlockGraph.BasicBlock>)_bbg, _bbg.getEnclosingBlock(stmt)) || this.executedMultipleTimes(caller);
    }

    public boolean isReachableViaInterProceduralControlFlow(SootMethod srcMethod, Stmt srcStmt, SootMethod destMethod, Stmt destStmt, IThreadGraphInfo tgi, boolean exclusive) {
        boolean _result;
        boolean bl = _result = tgi == null || !tgi.mustOccurInDifferentThread(srcMethod, destMethod);
        if (_result) {
            _result = false;
            if (this.cgi.isCalleeReachableFromCaller(destMethod, srcMethod)) {
                _result = this.doesControlFlowPathExistBetween(srcMethod, srcStmt, destMethod, true, exclusive);
            }
            if (!_result && this.cgi.isCalleeReachableFromCaller(srcMethod, destMethod)) {
                _result = this.doesControlFlowPathExistBetween(destMethod, destStmt, srcMethod, false, exclusive);
            }
            if (!_result) {
                _result = this.doesControlPathExistFromTo(srcMethod, destMethod);
            }
        } else {
            _result = tgi == null || tgi.containsClassInitThread(tgi.getExecutionThreads(srcMethod));
        }
        return _result;
    }

    public boolean notInSameSCC(SootMethod m, SootMethod p) {
        boolean _result = true;
        Iterator _i = this.cgi.getSCCs(true).iterator();
        while (_i.hasNext() && _result) {
            Collection _scc = (Collection)_i.next();
            if (!_scc.contains(m)) continue;
            boolean bl = _result = !_scc.contains(p);
        }
        return _result;
    }

    public boolean occursInCycle(IDirectedGraph<BasicBlockGraph.BasicBlock> graph, BasicBlockGraph.BasicBlock node) {
        return graph.isReachable((INode)node, (INode)node, true);
    }

    public void reset() {
        this.method2EnclosingInvokingStmtsCache.clear();
    }

    private Iterator<Stmt> getInvokingStmtIteratorFor(SootMethod method) {
        Iterator<Stmt> _result;
        Collection _temp = this.method2EnclosingInvokingStmtsCache.get(method);
        if (_temp == null) {
            Iterator _stmts = this.bbm.getBasicBlockGraph(method).getStmtGraph().iterator();
            Iterator _r = IteratorUtils.filteredIterator((Iterator)_stmts, (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE);
            this.method2EnclosingInvokingStmtsCache.put(method, IteratorUtils.toList((Iterator)_r));
            _result = this.method2EnclosingInvokingStmtsCache.get(method).iterator();
        } else {
            _result = _temp.iterator();
        }
        return _result;
    }
}

