/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IClassHierarchy;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CHABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.ICallInfoCollector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.CastExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RTABasedCallInfoCollector
extends AbstractProcessor
implements ICallInfoCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTABasedCallInfoCollector.class);
    private final CallInfo callInfoHolder = new CallInfo();
    private IClassHierarchy cha;
    private CHABasedCallInfoCollector chaCallInfo;
    private IEnvironment env;
    private final Map<SootMethod, Collection<SootClass>> method2instantiatedClasses = new HashMap<SootMethod, Collection<SootClass>>();
    private final Map<SootMethod, Collection<SootMethod>> method2requiredCLInits = new HashMap<SootMethod, Collection<SootMethod>>();
    private final Collection<SootMethod> roots = new HashSet<SootMethod>();

    public void callback(SootMethod method) {
        HashSet<SootClass> _temp = new HashSet<SootClass>();
        _temp.addAll(method.getExceptions());
        _temp.add(method.getDeclaringClass());
        int _j = method.getParameterCount() - 1;
        while (_j >= 0) {
            Type _type = method.getParameterType(_j);
            if (_type instanceof RefType) {
                _temp.add(((RefType)_type).getSootClass());
            }
            --_j;
        }
        Type _type = method.getReturnType();
        if (_type != null && _type instanceof RefType) {
            _temp.add(((RefType)_type).getSootClass());
        }
        Iterator _i = _temp.iterator();
        int _iEnd = _temp.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            this.capturePossibleRoots((SootClass)_i.next(), method);
            ++_iIndex;
        }
    }

    public void callback(ValueBox vBox, Context context) {
        Value _value = vBox.getValue();
        Type _type = null;
        SootMethod _currentMethod = context.getCurrentMethod();
        if (_value instanceof NewExpr || _value instanceof InstanceFieldRef || _value instanceof StaticFieldRef || _value instanceof ArrayRef || _value instanceof CastExpr || _value instanceof Local) {
            _type = _value.getType();
        } else if (_value instanceof NewArrayExpr) {
            NewArrayExpr _n = (NewArrayExpr)_value;
            _type = _n.getBaseType();
        } else if (_value instanceof StringConstant) {
            _type = this.env.getClass("java.lang.String").getType();
        } else if (_value instanceof StaticInvokeExpr) {
            this.recordCall(context, (InvokeExpr)_value);
        } else if (_value instanceof SpecialInvokeExpr) {
            SootMethod _invoked = ((SpecialInvokeExpr)_value).getMethod();
            if (_invoked.getName().equals("<init>") || _invoked.isPrivate()) {
                this.recordCall(context, (InvokeExpr)_value);
            }
        } else if (_value instanceof NewMultiArrayExpr) {
            NewMultiArrayExpr _n = (NewMultiArrayExpr)_value;
            _type = _n.getBaseType().baseType;
        }
        if (_type != null && _type instanceof RefType) {
            MapUtils.putIntoCollectionInMap(this.method2instantiatedClasses, (Object)_currentMethod, (Object)((RefType)_type).getSootClass());
            this.capturePossibleRoots(((RefType)_type).getSootClass(), _currentMethod);
        }
    }

    public void consolidate() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("consolidate() - BEGIN");
        }
        HashSet<SootClass> _instantiatedClasses = new HashSet<SootClass>();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(new HashSet());
        _wb.addAllWorkNoDuplicates(this.roots);
        while (_wb.hasWork()) {
            SootMethod _sootMethod = (SootMethod)_wb.getWork();
            this.callInfoHolder.addReachable(_sootMethod);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("consolidate() - Processed method: " + _sootMethod);
            }
            this.processCallerAndAlreadyInstantiatedClasses(_sootMethod, (IWorkBag<SootMethod>)_wb, _instantiatedClasses);
            Collection _t = MapUtils.getCollectionFromMap(this.method2instantiatedClasses, (Object)_sootMethod);
            if (!_instantiatedClasses.containsAll(_t)) {
                _t.removeAll(_instantiatedClasses);
                _instantiatedClasses.addAll(_t);
                this.processNewInstantiatedClasses(_t, (IWorkBag<SootMethod>)_wb);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("consolidate() - Considered classes: " + _t);
                }
            }
            Collection _requiredClassInitializers = MapUtils.getCollectionFromMap(this.method2requiredCLInits, (Object)_sootMethod);
            _wb.addAllWorkNoDuplicates(_requiredClassInitializers);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("consolidate() - Required initializers: " + _requiredClassInitializers);
        }
        this.callInfoHolder.fixupMethodsHavingZeroCallersAndCallees();
        this.method2instantiatedClasses.clear();
        this.method2requiredCLInits.clear();
        this.roots.clear();
        this.stable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("consolidate() - END");
        }
    }

    @Override
    public CallGraphInfo.ICallInfo getCallInfo() {
        return this.callInfoHolder;
    }

    public void hookup(ProcessingController ppc) {
        ppc.register((IProcessor)this);
        ppc.register(NewExpr.class, (IProcessor)this);
        ppc.register(InstanceFieldRef.class, (IProcessor)this);
        ppc.register(StaticFieldRef.class, (IProcessor)this);
        ppc.register(ArrayRef.class, (IProcessor)this);
        ppc.register(CastExpr.class, (IProcessor)this);
        ppc.register(Local.class, (IProcessor)this);
        ppc.register(SpecialInvokeExpr.class, (IProcessor)this);
        ppc.register(StaticInvokeExpr.class, (IProcessor)this);
        ppc.register(StringConstant.class, (IProcessor)this);
        this.env = ppc.getEnvironment();
    }

    public void initialize(CHABasedCallInfoCollector chaBasedCallInfo, IClassHierarchy analysis) {
        this.chaCallInfo = chaBasedCallInfo;
        this.cha = analysis;
    }

    public void processingBegins() {
        this.unstable();
    }

    public void reset() {
        this.cha = null;
        this.chaCallInfo = null;
        this.roots.clear();
        this.callInfoHolder.reset();
        this.method2instantiatedClasses.clear();
        this.method2requiredCLInits.clear();
    }

    public void setRootMethods(Collection<SootMethod> rootMethods) {
        this.roots.clear();
        this.roots.addAll(rootMethods);
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister((IProcessor)this);
        ppc.unregister(NewExpr.class, (IProcessor)this);
        ppc.unregister(InstanceFieldRef.class, (IProcessor)this);
        ppc.unregister(StaticFieldRef.class, (IProcessor)this);
        ppc.unregister(ArrayRef.class, (IProcessor)this);
        ppc.unregister(CastExpr.class, (IProcessor)this);
        ppc.unregister(Local.class, (IProcessor)this);
        ppc.unregister(SpecialInvokeExpr.class, (IProcessor)this);
        ppc.unregister(StaticInvokeExpr.class, (IProcessor)this);
        ppc.unregister(StringConstant.class, (IProcessor)this);
        this.env = null;
    }

    private void capturePossibleRoots(SootClass sootClass, SootMethod method) {
        Collection _reqMethods = MapUtils.getCollectionFromMap(this.method2requiredCLInits, (Object)method);
        HashSet<SootClass> _classes = new HashSet<SootClass>();
        _classes.add(sootClass);
        _classes.addAll(this.cha.getProperAncestorClassesOf(sootClass));
        _classes.addAll(this.cha.getProperAncestorInterfacesOf(sootClass));
        Iterator _i = _classes.iterator();
        int _iEnd = _classes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _sc = (SootClass)_i.next();
            if (_sc.declaresMethodByName("<clinit>")) {
                SootMethod _sm = _sc.getMethodByName("<clinit>");
                _reqMethods.add(_sm);
            }
            ++_iIndex;
        }
    }

    private void processCallerAndAlreadyInstantiatedClasses(SootMethod caller, IWorkBag<SootMethod> wb, Collection<SootClass> instantiatedClasses) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processCallerAndAlreadyInstantiatedClasses(SootMethod caller = " + caller + ", IWorkBag wb = " + wb + ") - BEGIN");
        }
        HashSet _chaCallees = new HashSet();
        _chaCallees.addAll(MapUtils.queryCollection(this.chaCallInfo.getCallInfo().getCaller2CalleesMap(), (Object)caller));
        _chaCallees.removeAll(MapUtils.queryCollection(this.callInfoHolder.getCaller2CalleesMap(), (Object)caller));
        Iterator _i = _chaCallees.iterator();
        int _iEnd = _chaCallees.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            ICallGraphInfo.CallTriple _calleeTriple = (ICallGraphInfo.CallTriple)_i.next();
            SootMethod _callee = _calleeTriple.getMethod();
            SootClass _calleeDeclaringClass = _callee.getDeclaringClass();
            if (!_callee.isAbstract() && (instantiatedClasses.contains(_calleeDeclaringClass) || CollectionUtils.containsAny(instantiatedClasses, (Collection)this.cha.getProperSubclassesOf(_calleeDeclaringClass)) || _callee.isStatic() || _calleeTriple.getExpr() instanceof SpecialInvokeExpr && _callee.getName().equals("<init>"))) {
                MapUtils.putIntoCollectionInMap(this.callInfoHolder.callee2callers, (Object)_callee, (Object)new ICallGraphInfo.CallTriple(caller, _calleeTriple.getStmt(), _calleeTriple.getExpr()));
                MapUtils.putIntoCollectionInMap(this.callInfoHolder.caller2callees, (Object)caller, (Object)_calleeTriple);
                wb.addWorkNoDuplicates((Object)_callee);
            }
            ++_iIndex;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processCallerAndAlreadyInstantiatedClasses() - END");
        }
    }

    private void processNewInstantiatedClasses(Collection<SootClass> newClasses, IWorkBag<SootMethod> wb) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processNewInstantiatedClassesAndReachables(Collection newClasses = " + newClasses + ", IWorkBag wb = " + wb + ") - BEGIN");
        }
        Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> _chaCallee2Callers = this.chaCallInfo.getCallInfo().getCallee2CallersMap();
        Collection<SootMethod> _reachables = this.callInfoHolder.getReachableMethods();
        Collection _methodsInNewClasses = Util.getResolvedMethods(newClasses);
        Iterator _j = _methodsInNewClasses.iterator();
        int _jEnd = _methodsInNewClasses.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            SootMethod _callee = (SootMethod)_j.next();
            Collection _callers = MapUtils.queryCollection(_chaCallee2Callers, (Object)_callee);
            Iterator _k = _callers.iterator();
            int _kEnd = _callers.size();
            boolean _flag = false;
            int _kIndex = 0;
            while (_kIndex < _kEnd) {
                ICallGraphInfo.CallTriple _callerTriple = (ICallGraphInfo.CallTriple)_k.next();
                SootMethod _caller = _callerTriple.getMethod();
                if (_reachables.contains(_caller)) {
                    _flag |= true;
                    MapUtils.putIntoCollectionInMap(this.callInfoHolder.callee2callers, (Object)_callee, (Object)_callerTriple);
                    MapUtils.putIntoCollectionInMap(this.callInfoHolder.caller2callees, (Object)_caller, (Object)new ICallGraphInfo.CallTriple(_callee, _callerTriple.getStmt(), _callerTriple.getExpr()));
                }
                ++_kIndex;
            }
            if (_flag) {
                wb.addWorkNoDuplicates((Object)_callee);
            }
            ++_jIndex;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processNewInstantiatedClassesAndReachables() - END");
        }
    }

    private void recordCall(Context context, InvokeExpr expr) {
        SootMethod _invokedMethod = expr.getMethod();
        Stmt _stmt = context.getStmt();
        SootMethod _caller = context.getCurrentMethod();
        ICallGraphInfo.CallTriple _callerTriple = new ICallGraphInfo.CallTriple(_caller, _stmt, expr);
        MapUtils.putIntoCollectionInMap(this.callInfoHolder.callee2callers, (Object)_invokedMethod, (Object)_callerTriple);
        MapUtils.putIntoCollectionInMap(this.callInfoHolder.caller2callees, (Object)_caller, (Object)new ICallGraphInfo.CallTriple(_invokedMethod, _stmt, expr));
        this.callInfoHolder.addReachable(_caller);
        this.callInfoHolder.addReachable(_invokedMethod);
    }
}

