/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.ICallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFABasedCallInfoCollector
extends AbstractValueAnalyzerBasedProcessor<Value>
implements ICallInfoCollector {
    static final Logger LOGGER = LoggerFactory.getLogger(OFABasedCallInfoCollector.class);
    private IValueAnalyzer<Value> analyzer;
    private final CallInfo callInfoHolder = new CallInfo();

    public void callback(SootMethod method) {
        this.callInfoHolder.addReachable(method);
    }

    public void callback(ValueBox vBox, Context context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("callback(ValueBox vBox = " + vBox + ", Context context = " + context + ") - BEGIN");
        }
        Stmt _stmt = context.getStmt();
        SootMethod _caller = context.getCurrentMethod();
        Value _value = vBox.getValue();
        InvokeExpr _invokeExpr = (InvokeExpr)_value;
        SootMethod _callee = _invokeExpr.getMethod();
        if (_value instanceof StaticInvokeExpr || _value instanceof SpecialInvokeExpr) {
            Collection _callees = MapUtils.getCollectionFromMap(this.callInfoHolder.caller2callees, (Object)_caller);
            ICallGraphInfo.CallTriple _triple1 = new ICallGraphInfo.CallTriple(_callee, _stmt, _invokeExpr);
            _callees.add(_triple1);
            Collection _callers = MapUtils.getCollectionFromMap(this.callInfoHolder.callee2callers, (Object)_callee);
            ICallGraphInfo.CallTriple _triple2 = new ICallGraphInfo.CallTriple(_caller, _stmt, _invokeExpr);
            _callers.add(_triple2);
        } else {
            this.callBackOnInstanceInvokeExpr(context, (InstanceInvokeExpr)_value);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("callback() - END");
        }
    }

    public void consolidate() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: call graph consolidation");
        }
        this.callInfoHolder.fixupMethodsHavingZeroCallersAndCallees();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Call Graph Info - " + this.callInfoHolder.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: call graph consolidation");
        }
        this.stable();
    }

    @Override
    public CallGraphInfo.ICallInfo getCallInfo() {
        return this.callInfoHolder;
    }

    public void hookup(ProcessingController ppc) {
        this.unstable();
        ppc.register(VirtualInvokeExpr.class, (IProcessor)this);
        ppc.register(InterfaceInvokeExpr.class, (IProcessor)this);
        ppc.register(StaticInvokeExpr.class, (IProcessor)this);
        ppc.register(SpecialInvokeExpr.class, (IProcessor)this);
        ppc.register((IProcessor)this);
    }

    public void processingBegins() {
        this.unstable();
    }

    public void reset() {
        this.callInfoHolder.reset();
    }

    @Override
    public void setAnalyzer(IValueAnalyzer<Value> objFlowAnalyzer) {
        this.analyzer = objFlowAnalyzer;
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister(VirtualInvokeExpr.class, (IProcessor)this);
        ppc.unregister(InterfaceInvokeExpr.class, (IProcessor)this);
        ppc.unregister(StaticInvokeExpr.class, (IProcessor)this);
        ppc.unregister(SpecialInvokeExpr.class, (IProcessor)this);
        ppc.unregister((IProcessor)this);
        this.stable();
    }

    private void callBackOnInstanceInvokeExpr(Context context, InstanceInvokeExpr expr) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("callBackOnInstanceInvokeExpr(Context context = " + context + ", InstanceInvokeExpr expr = " + expr + ") - BEGIN");
        }
        Stmt _stmt = context.getStmt();
        SootMethod _caller = context.getCurrentMethod();
        SootMethod _calleeMethod = expr.getMethod();
        context.setProgramPoint(expr.getBaseBox());
        Collection<Value> _values = this.analyzer.getValues(expr.getBase(), context);
        Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> _callee2callers = this.callInfoHolder.callee2callers;
        Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> _caller2callees = this.callInfoHolder.caller2callees;
        Collection _callees = MapUtils.getCollectionFromMap(_caller2callees, (Object)_caller);
        ICallGraphInfo.CallTriple _ctrp = new ICallGraphInfo.CallTriple(_caller, _stmt, (InvokeExpr)expr);
        if (!_values.isEmpty()) {
            for (Value _t : _values) {
                SootClass _accessClass = null;
                if (_t instanceof NewExpr) {
                    NewExpr _newExpr = (NewExpr)_t;
                    _accessClass = this.analyzer.getEnvironment().getClass(_newExpr.getBaseType().getClassName());
                } else if (_t instanceof StringConstant) {
                    _accessClass = this.analyzer.getEnvironment().getClass("java.lang.String");
                } else {
                    if (!(_t instanceof NewArrayExpr) && !(_t instanceof NewMultiArrayExpr)) continue;
                    _accessClass = this.analyzer.getEnvironment().getClass("java.lang.Object");
                }
                String _methodName = _calleeMethod.getName();
                List _parameterTypes = _calleeMethod.getParameterTypes();
                Type _returnType = _calleeMethod.getReturnType();
                SootMethod _callee = Util.findMethodImplementation((SootClass)_accessClass, (String)_methodName, (List)_parameterTypes, (Type)_returnType);
                ICallGraphInfo.CallTriple _triple = new ICallGraphInfo.CallTriple(_callee, _stmt, (InvokeExpr)expr);
                _callees.add(_triple);
                Collection _callers = MapUtils.getCollectionFromMap(_callee2callers, (Object)_callee);
                _callers.add(_ctrp);
            }
        } else if (_calleeMethod.isConcrete()) {
            ICallGraphInfo.CallTriple _triple = new ICallGraphInfo.CallTriple(_calleeMethod, _stmt, (InvokeExpr)expr);
            _callees.add(_triple);
            Collection _callers = MapUtils.getCollectionFromMap(_callee2callers, (Object)_calleeMethod);
            _callers.add(_ctrp);
            this.callInfoHolder.addReachable(_calleeMethod);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("callBackOnInstanceInvokeExpr() - END");
        }
    }
}

