/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphTest;
import edu.ksu.cis.indus.staticanalyses.flow.IFATest;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import soot.SootClass;
import soot.SootMethod;

public final class OFABasedCallGraphTest
extends CallGraphTest
implements IFATest {
    private OFAnalyzer ofa;

    public void localtestIsReachable() {
        Collection _reachables = this.cgi.getReachableMethods();
        Collection _heads = this.cgi.getEntryMethods();
        for (SootClass _sc : this.ofa.getEnvironment().getClasses()) {
            for (SootMethod _sm : _sc.getMethods()) {
                OFABasedCallGraphTest.assertEquals((boolean)this.cgi.isReachable(_sm), (boolean)_reachables.contains(_sm));
                if (!this.cgi.isReachable(_sm)) continue;
                boolean _t = false;
                Iterator _k = _heads.iterator();
                while (_k.hasNext()) {
                    _t |= this.cg.isReachable((INode)this.cg.getNode(_k.next()), (INode)this.cg.getNode((Object)_sm), true);
                }
                OFABasedCallGraphTest.assertTrue((_t || _heads.contains(_sm) ? 1 : 0) != 0);
            }
        }
    }

    public void setAnalyzer(IValueAnalyzer valueAnalyzer) {
        this.ofa = (OFAnalyzer)valueAnalyzer;
    }

    public void setFATagName(String tagName) {
    }

    public void testTagsOnReachableMethods() {
        Context _ctxt = new Context();
        Collection _reachables = this.cgi.getReachableMethods();
        OFABasedCallGraphTest.assertNotNull((Object)_reachables);
        for (SootMethod _o : _reachables) {
            OFABasedCallGraphTest.assertTrue((boolean)_o.hasTag("indus.staticanalyses.flow.FATestSetup:FA"));
            OFABasedCallGraphTest.assertTrue((boolean)_o.getDeclaringClass().hasTag("indus.staticanalyses.flow.FATestSetup:FA"));
            if (_o.isStatic()) continue;
            _ctxt.setRootMethod(_o);
            OFABasedCallGraphTest.assertNotNull(this.ofa.getValuesForThis(_ctxt));
        }
        Collection _methods = new HashSet();
        Iterator _i = this.ofa.getEnvironment().getClasses().iterator();
        while (_i.hasNext()) {
            _methods.addAll(((SootClass)_i.next()).getMethods());
        }
        _methods = SetUtils.difference(_methods, (Collection)_reachables);
        for (SootMethod _sm : _methods) {
            if (_sm.isAbstract()) continue;
            OFABasedCallGraphTest.assertFalse((boolean)_sm.hasTag("indus.staticanalyses.flow.FATestSetup:FA"));
        }
    }

    protected void tearDown() throws Exception {
        this.ofa = null;
        super.tearDown();
    }
}

