/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import soot.SootMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CallInfo
implements CallGraphInfo.ICallInfo {
    final Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> callee2callers = new HashMap<SootMethod, Collection<ICallGraphInfo.CallTriple>>();
    final Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> caller2callees = new HashMap<SootMethod, Collection<ICallGraphInfo.CallTriple>>();
    private final Set<SootMethod> reachables = new HashSet<SootMethod>();
    private transient String toString;

    CallInfo() {
    }

    public void addReachable(SootMethod method) {
        this.reachables.add(method);
    }

    @Override
    public Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> getCallee2CallersMap() {
        return Collections.unmodifiableMap(this.callee2callers);
    }

    @Override
    public Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> getCaller2CalleesMap() {
        return Collections.unmodifiableMap(this.caller2callees);
    }

    @Override
    public Collection<SootMethod> getReachableMethods() {
        return Collections.unmodifiableCollection(this.reachables);
    }

    public void reset() {
        this.callee2callers.clear();
        this.caller2callees.clear();
        this.reachables.clear();
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = new ToStringBuilder((Object)this).appendSuper(super.toString()).append("reachables-size", this.reachables.size()).append((Object)"\n").append("caller2callees-size", this.caller2callees.size()).append((Object)"\n").append("callee2callers-size", this.callee2callers.size()).append("reachables", this.reachables).append((Object)"\n").append("caller2callees", this.caller2callees).append((Object)"\n").append("callee2callers", this.callee2callers).toString();
        }
        return this.toString;
    }

    void fixupMethodsHavingZeroCallersAndCallees() {
        Iterator<SootMethod> _i = this.reachables.iterator();
        int _iEnd = this.reachables.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootMethod _o = _i.next();
            if (this.callee2callers.get(_o) == null) {
                this.callee2callers.put(_o, Collections.emptySet());
            }
            if (this.caller2callees.get(_o) == null) {
                this.caller2callees.put(_o, Collections.emptySet());
            }
            ++_iIndex;
        }
        assert (this.validate());
    }

    private boolean validate() {
        Collection _k1 = this.caller2callees.keySet();
        for (Collection<ICallGraphInfo.CallTriple> _c : this.callee2callers.values()) {
            for (ICallGraphInfo.CallTriple _ctrp : _c) {
                assert (_k1.contains(_ctrp.getMethod()));
            }
        }
        Collection _k2 = this.callee2callers.keySet();
        for (Collection<ICallGraphInfo.CallTriple> _c : this.caller2callees.values()) {
            for (ICallGraphInfo.CallTriple _ctrp : _c) {
                assert (_k2.contains(_ctrp.getMethod()));
            }
        }
        assert (_k1.containsAll(this.reachables)) : SetUtils.difference(this.reachables, (Collection)_k1);
        assert (_k2.containsAll(this.reachables)) : SetUtils.difference(this.reachables, (Collection)_k2);
        assert (this.reachables.containsAll(_k1)) : SetUtils.difference((Collection)_k1, this.reachables);
        assert (this.reachables.containsAll(_k2)) : SetUtils.difference((Collection)_k2, this.reachables);
        return true;
    }
}

