/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.MetricsProcessor;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CGBasedXMLizingProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CHABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphXMLizer;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.callgraphs.RTABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyXMLizerCLI;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAXMLizerCLI;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.impl.ClassHierarchy;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallGraphXMLizerCLI
extends SootBasedDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallGraphXMLizerCLI.class);
    private final CallGraphXMLizer xmlizer = new CallGraphXMLizer();
    private boolean cumulative;

    public static void main(String[] args) {
        Options _options = new Options();
        Option _option = new Option("c", "cumulative", false, "Builds one call graph that includes all root methods.");
        _options.addOption(_option);
        _option = new Option("o", "output", true, "Directory into which xml files will be written into.  Defaults to current directory if omitted");
        _option.setArgs(1);
        _option.setArgName("output-dir");
        _options.addOption(_option);
        _option = new Option("j", "jimple", false, "Dump xmlized jimple.");
        _option.setArgName("dump-jimple");
        _options.addOption(_option);
        _option = new Option("p", "soot-classpath", true, "Prepend this to soot class path.");
        _option.setArgs(1);
        _option.setArgName("classpath");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("h", "help", false, "Display message.");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("t", "call-graph-type", true, "Call graph type.  This has to be one of {cha, rta, ofa-oi, ofa-oirt, ofa-os}.");
        _option.setArgs(1);
        _option.setArgName("type");
        _option.setRequired(true);
        _options.addOption(_option);
        _option = new Option("S", "scope", true, "The scope that should be analyzed.");
        _option.setArgs(1);
        _option.setArgName("scope");
        _option.setRequired(false);
        _options.addOption(_option);
        PosixParser _parser = new PosixParser();
        try {
            String _outputDir;
            CommandLine _cl = _parser.parse(_options, args);
            if (_cl.hasOption('h')) {
                CallGraphXMLizerCLI.printUsage(_options);
                System.exit(1);
            }
            if ((_outputDir = _cl.getOptionValue('o')) == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Defaulting to current directory for output.");
                }
                _outputDir = ".";
            }
            if (_cl.getArgList().isEmpty()) {
                throw new MissingArgumentException("Please specify atleast one class.");
            }
            CallGraphXMLizerCLI _cli = new CallGraphXMLizerCLI();
            _cli.xmlizer.setXmlOutputDir(_outputDir);
            _cli.xmlizer.setGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
            _cli.setCumulative(_cl.hasOption('c'));
            _cli.setClassNames(_cl.getArgList());
            _cli.addToSootClassPath(_cl.getOptionValue('p'));
            if (_cl.hasOption('S')) {
                _cli.setScopeSpecFile(_cl.getOptionValue('S'));
            }
            _cli.initialize();
            _cli.execute(_cl.hasOption('j'), _cl.getOptionValue('t'));
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            System.out.println("Error while parsing command line." + (Object)((Object)_e));
            CallGraphXMLizerCLI.printUsage(_options);
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    private static void printUsage(Options options) {
        String _cmdLineSyn = "java " + DependencyXMLizerCLI.class.getName() + " <options> <classnames>";
        new HelpFormatter().printHelp(_cmdLineSyn, "Options are: ", options, "");
    }

    private void setCumulative(boolean option) {
        this.cumulative = option;
    }

    private void dumpInfo(boolean dumpJimple, ICallGraphInfo cgi, String fileBaseName, IEnvironment env) {
        HashMap<Object, Object> _info = new HashMap<Object, Object>();
        _info.put(ICallGraphInfo.ID, cgi);
        ProcessingController _xmlcgipc = new ProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _xmlcgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _xmlcgipc.setEnvironment(env);
        _xmlcgipc.setProcessingFilter((IProcessingFilter)new CGBasedXMLizingProcessingFilter(cgi));
        _info.put(AbstractXMLizer.FILE_NAME_ID, fileBaseName);
        _info.put(IStmtGraphFactory.ID, this.getStmtGraphFactory());
        this.xmlizer.writeXML(_info);
        if (dumpJimple) {
            this.xmlizer.dumpJimple(fileBaseName, this.xmlizer.getXmlOutputDir(), _xmlcgipc);
        }
        System.out.println(cgi.toString());
    }

    private void execute(boolean dumpJimple, String type) {
        this.setInfoLogger(LOGGER);
        if (type.equals("cha")) {
            this.executeCHA(dumpJimple);
        } else if (type.equals("rta")) {
            this.executeRTA(dumpJimple);
        } else if (type.indexOf("ofa") == 0) {
            this.executeOFA(dumpJimple, type);
        }
    }

    private void executeCHA(boolean dumpJimple) {
        ClassHierarchy _cha = new ClassHierarchy();
        ProcessingController _pc = new ProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setEnvironment(this.getEnvironment());
        _cha.hookup(_pc);
        _pc.process();
        _cha.unhook(_pc);
        CHABasedCallInfoCollector _chaci = new CHABasedCallInfoCollector();
        _chaci.initialize(_cha);
        _chaci.hookup(_pc);
        _pc.process();
        _chaci.unhook(_pc);
        CallGraphInfo _cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        _cgi.createCallGraphInfo(_chaci.getCallInfo());
        this.dumpInfo(dumpJimple, _cgi, "CHA-Based", this.getEnvironment());
    }

    private <T extends ITokens<T, Value>> void executeOFA(boolean dumpJimple, String OFAType) {
        IValueAnalyzer _aa;
        if (OFAType.equals("ofa-oi")) {
            _aa = OFAnalyzer.getFSOIAnalyzer("CallGraphXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else if (OFAType.equals("ofa-oirt")) {
            _aa = OFAnalyzer.getFSOIRTAnalyzer("CallGraphXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else if (OFAType.equals("ofa-os")) {
            _aa = OFAnalyzer.getFSOSAnalyzer("CallGraphXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else {
            throw new IllegalArgumentException("callgraph-type has to be one of the following: ofa-oi, ofa-oirt, ofa-os, fsoirt.");
        }
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList<OFABasedCallInfoCollector> _processors = new ArrayList<OFABasedCallInfoCollector>();
        CallGraphInfo _cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        OFABasedCallInfoCollector _ofaci = new OFABasedCallInfoCollector();
        ArrayList<SootMethod> _rm = new ArrayList<SootMethod>();
        MetricsProcessor _countingProcessor = new MetricsProcessor();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(_aa);
        _pc.setEnvironment(this.getEnvironment());
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("CallGraphXMLizer:FA"));
        ArrayList<Collection> _roots = new ArrayList<Collection>();
        if (this.cumulative) {
            _roots.add(this.getRootMethods());
        } else {
            _roots.addAll(this.getRootMethods());
        }
        Collections.sort(_roots, ToStringBasedComparator.getComparator());
        this.writeInfo("Root methods are: " + _roots.size() + "\n" + _roots);
        Iterator _k = _roots.iterator();
        while (_k.hasNext()) {
            _rm.clear();
            Object _root = _k.next();
            String _fileBaseName = "OFA-Based_" + OFAXMLizerCLI.getBaseNameOfFileAndRootMethods(_root, _rm);
            this.writeInfo("RootMethod: " + _root);
            this.writeInfo("BEGIN: FA");
            long _start = System.currentTimeMillis();
            _aa.reset();
            this.getBbm().reset();
            _aa.analyze(this.getEnvironment(), _rm);
            long _stop = System.currentTimeMillis();
            this.addTimeLog("FA", _stop - _start);
            this.writeInfo("END: FA");
            _ofaci.reset();
            _processors.clear();
            _processors.add(_ofaci);
            _processors.add((OFABasedCallInfoCollector)_countingProcessor);
            _pc.reset();
            _pc.driveProcessors(_processors);
            _processors.clear();
            _cgi.reset();
            _cgi.createCallGraphInfo(_ofaci.getCallInfo());
            ByteArrayOutputStream _stream = new ByteArrayOutputStream();
            new PrintWriter(_stream).write("STATISTICS: " + MapUtils.verbosePrint(new TreeMap(_countingProcessor.getStatistics())));
            this.writeInfo(_stream.toString());
            this.dumpInfo(dumpJimple, _cgi, _fileBaseName, _aa.getEnvironment());
        }
    }

    private void executeRTA(boolean dumpJimple) {
        ClassHierarchy _cha = new ClassHierarchy();
        ProcessingController _pc = new ProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setEnvironment(this.getEnvironment());
        _cha.hookup(_pc);
        _pc.process();
        _cha.unhook(_pc);
        CHABasedCallInfoCollector _chaci = new CHABasedCallInfoCollector();
        _chaci.initialize(_cha);
        _chaci.hookup(_pc);
        _pc.process();
        _chaci.unhook(_pc);
        RTABasedCallInfoCollector _rtaci = new RTABasedCallInfoCollector();
        _rtaci.setRootMethods(this.getRootMethods());
        _rtaci.initialize(_chaci, _cha);
        _rtaci.hookup(_pc);
        _pc.process();
        _rtaci.unhook(_pc);
        CallGraphInfo _cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        _cgi.createCallGraphInfo(_rtaci.getCallInfo());
        this.dumpInfo(dumpJimple, _cgi, "RTA-Based", this.getEnvironment());
    }
}

