/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;

final class CallGraphXMLizer
extends AbstractXMLizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallGraphXMLizer.class);

    CallGraphXMLizer() {
    }

    public String getFileName(String name) {
        return "callgraph_" + CallGraphXMLizer.xmlizeString((String)name) + ".xml";
    }

    public void writeXML(Map info) {
        File _f = new File(String.valueOf(this.getXmlOutputDir()) + File.separator + this.getFileName((String)info.get(FILE_NAME_ID)));
        try {
            FileWriter _writer = new FileWriter(_f);
            CustomXMLOutputter _xmlWriter = new CustomXMLOutputter((Writer)_writer);
            ICallGraphInfo _cgi = (ICallGraphInfo)info.get(ICallGraphInfo.ID);
            _xmlWriter.declaration();
            _xmlWriter.startTag("callgraph");
            XMLizingProcessingFilter _filter = new XMLizingProcessingFilter();
            HashSet<SootMethod> _temp = new HashSet<SootMethod>();
            for (SootMethod _method : _filter.filterMethods(_cgi.getReachableMethods())) {
                _xmlWriter.startTag("method");
                _xmlWriter.attribute("id", this.getIdGenerator().getIdForMethod(_method));
                _temp.clear();
                for (ICallGraphInfo.CallTriple _ctrp : _cgi.getCallees(_method)) {
                    _temp.add(_ctrp.getMethod());
                }
                for (SootMethod _callee : _filter.filterMethods(_temp)) {
                    _xmlWriter.startTag("callee");
                    _xmlWriter.attribute("calleeId", this.getIdGenerator().getIdForMethod(_callee));
                    _xmlWriter.endTag();
                }
                _temp.clear();
                for (ICallGraphInfo.CallTriple _ctrp : _cgi.getCallers(_method)) {
                    _temp.add(_ctrp.getMethod());
                }
                for (SootMethod _caller : _filter.filterMethods(_temp)) {
                    _xmlWriter.startTag("caller");
                    _xmlWriter.attribute("callerId", this.getIdGenerator().getIdForMethod(_caller));
                    _xmlWriter.endTag();
                }
                _xmlWriter.endTag();
            }
            _xmlWriter.startTag("reachables");
            for (SootMethod _sm : _cgi.getReachableMethods()) {
                _xmlWriter.startTag("method");
                _xmlWriter.attribute("methodId", this.getIdGenerator().getIdForMethod(_sm));
                _xmlWriter.endTag();
            }
            _xmlWriter.endDocument();
            _writer.flush();
            _writer.close();
        }
        catch (IOException _e) {
            LOGGER.error("Error while xmlizing call graph", (Throwable)_e);
        }
    }
}

