/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.graph.AbstractDirectedGraphTest;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.IObjectNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.ICallGraphTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.SootMethod;

public class CallGraphTest
extends AbstractDirectedGraphTest
implements ICallGraphTest {
    protected ICallGraphInfo cgi;
    protected SimpleNodeGraph cg;

    public void setCallGraph(CallGraphInfo callgraph) {
        this.cgi = callgraph;
        this.cg = (SimpleNodeGraph)callgraph.getCallGraph();
        this.dg = this.cg;
    }

    public void localtestIsReachable() {
        Collection _reachables = this.cgi.getReachableMethods();
        Collection _heads = this.cgi.getEntryMethods();
        for (SootMethod _sm : _reachables) {
            CallGraphTest.assertEquals((boolean)this.cgi.isReachable(_sm), (boolean)_reachables.contains(_sm));
            if (!this.cgi.isReachable(_sm)) continue;
            boolean _t = false;
            Iterator _k = _heads.iterator();
            while (_k.hasNext()) {
                _t |= this.cg.isReachable((INode)this.cg.getNode(_k.next()), (INode)this.cg.getNode((Object)_sm), true);
            }
            CallGraphTest.assertTrue((_t || _heads.contains(_sm) ? 1 : 0) != 0);
        }
    }

    public void testGetCallGraph() {
        if (this.cgi instanceof CallGraphInfo) {
            CallGraphTest.assertNotNull(((CallGraphInfo)this.cgi).getCallGraph());
        }
    }

    public void testGetCalleesInvokeExprContext() {
        Context _context = new Context();
        ArrayList<SootMethod> _calleeMethods = new ArrayList<SootMethod>();
        for (SootMethod _caller : this.cgi.getReachableMethods()) {
            Collection _callees = this.cgi.getCallees(_caller);
            _calleeMethods.clear();
            for (ICallGraphInfo.CallTriple _ctrp : _callees) {
                _calleeMethods.add(_ctrp.getMethod());
            }
            for (ICallGraphInfo.CallTriple _ctrp1 : _callees) {
                _context.setStmt(_ctrp1.getStmt());
                _context.setRootMethod(_caller);
                Collection _newCallees = this.cgi.getCallees(_ctrp1.getExpr(), _context);
                for (ICallGraphInfo.CallTriple _ctrp2 : _callees) {
                    if (!_ctrp2.getExpr().equals(_ctrp1.getExpr())) continue;
                    CallGraphTest.assertTrue((boolean)_newCallees.contains(_ctrp2.getMethod()));
                }
                _calleeMethods.removeAll(_newCallees);
            }
            CallGraphTest.assertTrue((boolean)_calleeMethods.isEmpty());
        }
    }

    public void testGetCallersAndGetCallees() {
        Collection _heads = this.cgi.getEntryMethods();
        Collection _tails = this.cg.getSinks();
        for (SootMethod _callee : this.cgi.getReachableMethods()) {
            Collection _callers = this.cgi.getCallers(_callee);
            CallGraphTest.assertNotNull((Object)_callers);
            if (_callers.isEmpty()) {
                CallGraphTest.assertTrue((boolean)_heads.contains(_callee));
                continue;
            }
            for (ICallGraphInfo.CallTriple _ctrp1 : _callers) {
                SootMethod _caller = _ctrp1.getMethod();
                CallGraphTest.assertTrue((boolean)this.cgi.isReachable(_caller));
                Collection _callees = this.cgi.getCallees(_caller);
                if (_callees.isEmpty()) {
                    CallGraphTest.assertTrue((boolean)_tails.contains(_caller));
                    continue;
                }
                boolean _t = false;
                for (ICallGraphInfo.CallTriple _ctrp2 : _callees) {
                    if (!_ctrp2.getMethod().equals(_callee)) continue;
                    _t = true;
                    break;
                }
                CallGraphTest.assertTrue((boolean)_t);
            }
        }
    }

    public void testGetNodes() {
        Collection _reachables = this.cgi.getReachableMethods();
        HashSet<Object> _d = new HashSet<Object>();
        for (IObjectNode _node : this.dg.getNodes()) {
            _d.add(_node.getObject());
        }
        CallGraphTest.assertTrue((boolean)_d.containsAll(_reachables));
        CallGraphTest.assertTrue((boolean)_reachables.containsAll(_d));
    }

    public void testGetReachableMethods() {
        Collection _reachables = this.cgi.getReachableMethods();
        CallGraphTest.assertNotNull((Object)_reachables);
        Iterator _i = _reachables.iterator();
        while (_i.hasNext()) {
            CallGraphTest.assertTrue((boolean)(_i.next() instanceof SootMethod));
        }
    }

    public void testSize() {
        CallGraphTest.assertTrue((this.cgi.getReachableMethods().size() == this.dg.getNodes().size() ? 1 : 0) != 0);
    }

    protected void localtestGetHeads() {
        Collection _heads = new HashSet<Object>();
        for (IObjectNode _sn : this.dg.getSources()) {
            _heads.add(_sn.getObject());
        }
        CallGraphTest.assertTrue((boolean)_heads.containsAll(this.cgi.getEntryMethods()));
        CallGraphTest.assertTrue((boolean)this.cgi.getEntryMethods().containsAll(_heads));
        _heads = this.cgi.getEntryMethods();
        CallGraphTest.assertNotNull(_heads);
        for (SootMethod _sm : _heads) {
            CallGraphTest.assertTrue((boolean)this.cgi.getCallers(_sm).isEmpty());
        }
        CallGraphTest.assertTrue((boolean)this.cgi.getReachableMethods().containsAll(_heads));
    }

    protected void localtestGetSCCs() {
        List _sccs = this.cgi.getSCCs(true);
        Collection _reachables = this.cgi.getReachableMethods();
        CallGraphTest.assertNotNull((Object)_sccs);
        for (Collection _scc1 : _sccs) {
            CallGraphTest.assertNotNull((Object)_scc1);
            CallGraphTest.assertTrue((boolean)_reachables.containsAll(_scc1));
            for (Collection _scc2 : _sccs) {
                if (_scc1 == _scc2) continue;
                CallGraphTest.assertTrue((boolean)SetUtils.intersection((Collection)_scc1, (Collection)_scc2).isEmpty());
            }
        }
    }

    protected void localtestGraphGetTails() {
        for (IObjectNode _node : this.dg.getSinks()) {
            CallGraphTest.assertTrue((boolean)this.cgi.getCallees((SootMethod)_node.getObject()).isEmpty());
        }
        for (SootMethod _sm : this.cgi.getReachableMethods()) {
            if (!this.cgi.getCallees(_sm).isEmpty()) continue;
            CallGraphTest.assertTrue((boolean)this.cg.getNode((Object)_sm).getSuccsOf().isEmpty());
        }
    }

    protected void tearDown() throws Exception {
        this.cg = null;
        this.cgi = null;
        super.tearDown();
    }
}

