/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.collections.Cache;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.graph.GraphReachabilityPredicate;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.IMutableNode;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.IObjectNode;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.interfaces.AbstractStatus;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallGraphInfo
extends AbstractStatus
implements ICallGraphInfo {
    private static final int CONNECTIVITY_CACHE_SIZE = Constants.getNumOfMethodsInApplication() * 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(CallGraphInfo.class);
    private final Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> callee2callers = new HashMap<SootMethod, Collection<ICallGraphInfo.CallTriple>>();
    private Map<Triple<SootMethod, Stmt, SootMethod>, Boolean> calleeCallSiteReachabilityCache = new Cache(CONNECTIVITY_CACHE_SIZE);
    private final Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> caller2callees = new HashMap<SootMethod, Collection<ICallGraphInfo.CallTriple>>();
    private SimpleNodeGraph<SootMethod> graphCache;
    private final Collection<SootMethod> heads = new HashSet<SootMethod>();
    private final Map<Pair<Stmt, SootMethod>, Collection<SootMethod>> invocationsite2reachableMethods = new HashMap<Pair<Stmt, SootMethod>, Collection<SootMethod>>(Constants.getNumOfMethodsInApplication());
    private final Map<SootMethod, Collection<SootMethod>> method2backwardReachableMethods = new HashMap<SootMethod, Collection<SootMethod>>(Constants.getNumOfMethodsInApplication());
    private final Map<SootMethod, Collection<SootMethod>> method2forwardReachableMethods = new HashMap<SootMethod, Collection<SootMethod>>(Constants.getNumOfMethodsInApplication());
    private final Pair.PairManager pairMgr;
    private final Collection<SootMethod> reachables = new HashSet<SootMethod>();
    private WeakReference<List<List<SootMethod>>> topDownSCC;

    public CallGraphInfo(Pair.PairManager pairManager) {
        this.pairMgr = pairManager;
    }

    public boolean areAnyMethodsReachableFrom(Collection<SootMethod> methods, final SootMethod caller) {
        IPredicate<SootMethod> _pred = new IPredicate<SootMethod>(){

            public boolean evaluate(SootMethod object) {
                return CallGraphInfo.this.isCalleeReachableFromCaller(object, caller);
            }
        };
        return CollectionUtils.exists(methods, (IPredicate)_pred);
    }

    public boolean areAnyMethodsReachableFrom(Collection<SootMethod> methods, final Stmt stmt, final SootMethod caller) {
        IPredicate<SootMethod> _pred = new IPredicate<SootMethod>(){

            public boolean evaluate(SootMethod object) {
                return CallGraphInfo.this.isCalleeReachableFromCallSite(object, stmt, caller);
            }
        };
        return CollectionUtils.exists(methods, (IPredicate)_pred);
    }

    public void createCallGraphInfo(ICallInfo provider) {
        this.callee2callers.putAll(provider.getCallee2CallersMap());
        this.caller2callees.putAll(provider.getCaller2CalleesMap());
        this.reachables.addAll(provider.getReachableMethods());
        this.calculateHeads();
        this.createGraph();
        this.stable();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("createCallGraphInfo(ICallInfo) - call-graph: \n" + this.toString());
        }
    }

    public Collection<SootMethod> getCallees(InvokeExpr invokeExpr, Context context) {
        ArrayList<SootMethod> _result;
        SootMethod _currentMethod = context.getCurrentMethod();
        if (this.caller2callees.containsKey(_currentMethod)) {
            _result = new ArrayList<SootMethod>();
            for (ICallGraphInfo.CallTriple _ctrp : this.caller2callees.get(_currentMethod)) {
                if (!_ctrp.getExpr().equals(invokeExpr)) continue;
                _result.add(_ctrp.getMethod());
            }
        } else {
            _result = (ArrayList<SootMethod>)Collections.emptyList();
        }
        return _result;
    }

    public Collection<ICallGraphInfo.CallTriple> getCallees(SootMethod caller) {
        Collection _callees = MapUtils.queryCollection(this.caller2callees, (Object)caller);
        return Collections.unmodifiableCollection(_callees);
    }

    public Collection<ICallGraphInfo.CallTriple> getCallers(SootMethod callee) {
        Collection _callers = MapUtils.queryCollection(this.callee2callers, (Object)callee);
        return Collections.unmodifiableCollection(_callers);
    }

    public Collection<SootMethod> getCommonMethodsReachableFrom(SootMethod method1, boolean forward1, SootMethod method2, boolean forward2) {
        Collection _result;
        if (this.graphCache.hasCommonReachablesFrom((INode)this.graphCache.queryNode((Object)method1), forward1, (INode)this.graphCache.queryNode((Object)method2), forward2)) {
            Collection _r = this.graphCache.getCommonReachablesFrom((INode)this.graphCache.queryNode((Object)method1), forward1, (INode)this.graphCache.queryNode((Object)method2), forward2);
            _result = CollectionUtils.collect((Collection)_r, (ITransformer)this.graphCache.getObjectExtractor());
        } else {
            _result = Collections.emptyList();
        }
        return _result;
    }

    public Collection<SootMethod> getConnectivityCalleesFor(SootMethod method1, SootMethod method2) {
        Collection _result;
        if (this.graphCache.hasCommonReachablesFrom((INode)this.graphCache.queryNode((Object)method1), true, (INode)this.graphCache.queryNode((Object)method2), true)) {
            Collection _r = this.graphCache.getConnectivityNodesFor((INode)this.graphCache.queryNode((Object)method1), (INode)this.graphCache.queryNode((Object)method2), true);
            _result = CollectionUtils.collect((Collection)_r, (ITransformer)this.graphCache.getObjectExtractor());
        } else {
            _result = Collections.emptyList();
        }
        return _result;
    }

    public Collection<SootMethod> getConnectivityCallersFor(SootMethod method1, SootMethod method2) {
        Collection _result;
        if (this.graphCache.hasCommonReachablesFrom((INode)this.graphCache.queryNode((Object)method1), false, (INode)this.graphCache.queryNode((Object)method2), false)) {
            Collection _r = this.graphCache.getConnectivityNodesFor((INode)this.graphCache.queryNode((Object)method1), (INode)this.graphCache.queryNode((Object)method2), false);
            _result = CollectionUtils.collect((Collection)_r, (ITransformer)this.graphCache.getObjectExtractor());
        } else {
            _result = Collections.emptyList();
        }
        return _result;
    }

    public Collection<SootMethod> getEntryMethods() {
        return Collections.unmodifiableCollection(this.heads);
    }

    public Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(ICallGraphInfo.ID);
    }

    public List<SootMethod> getMethodsInTopologicalOrder(boolean topdown) {
        List _topologicalSorted = this.graphCache.performTopologicalSort(topdown);
        ArrayList<SootMethod> _result = new ArrayList<SootMethod>();
        CollectionUtils.transform((Collection)_topologicalSorted, (ITransformer)this.graphCache.getObjectExtractor(), _result);
        return _result;
    }

    public Collection<SootMethod> getMethodsReachableFrom(SootMethod root, boolean forward) {
        return Collections.unmodifiableCollection(this.getMethodsReachableFromHelper(root, forward));
    }

    public Collection<SootMethod> getMethodsReachableFrom(Stmt stmt, SootMethod root) {
        Pair _pair = this.pairMgr.getPair((Object)stmt, (Object)root);
        Collection<SootMethod> _result = this.invocationsite2reachableMethods.get(_pair);
        if (_result == null) {
            InvokeExpr _ie = stmt.getInvokeExpr();
            Context _context = new Context();
            _context.setRootMethod(root);
            Collection<SootMethod> _callees = this.getCallees(_ie, _context);
            ArrayList<SootMethod> _methods = new ArrayList<SootMethod>();
            _methods.addAll(_callees);
            Iterator<SootMethod> _i = _callees.iterator();
            while (_i.hasNext()) {
                _methods.addAll(this.getMethodsReachableFromHelper(_i.next(), true));
            }
            this.invocationsite2reachableMethods.put((Pair<Stmt, SootMethod>)_pair, _methods);
            _result = _methods;
        }
        return Collections.unmodifiableCollection(_result);
    }

    public Collection<SootMethod> getReachableMethods() {
        return Collections.unmodifiableCollection(this.reachables);
    }

    public List<List<SootMethod>> getSCCs(boolean topDown) {
        ArrayList _r;
        ArrayList arrayList = _r = this.topDownSCC == null ? null : (ArrayList)this.topDownSCC.get();
        if (_r == null) {
            _r = new ArrayList();
            List _temp = this.graphCache.getSCCs(true);
            for (List _scc : _temp) {
                _r.add(Collections.unmodifiableList(CollectionUtils.collect((Collection)_scc, (ITransformer)this.graphCache.getObjectExtractor())));
            }
            this.topDownSCC = new WeakReference(_r);
        }
        ArrayList<List<SootMethod>> _result = new ArrayList<List<SootMethod>>(_r);
        if (!topDown) {
            Collections.reverse(_result);
        }
        return _result;
    }

    public boolean isCalleeReachableFromCaller(SootMethod callee, SootMethod caller) {
        SimpleNode _calleeNode = this.graphCache.queryNode((Object)callee);
        SimpleNode _callerNode = this.graphCache.queryNode((Object)caller);
        return _calleeNode != null && _callerNode != null && this.graphCache.isReachable((INode)_callerNode, (INode)_calleeNode, true);
    }

    public boolean isCalleeReachableFromCallSite(SootMethod callee, Stmt stmt, SootMethod caller) {
        boolean _result;
        Triple _trp = new Triple((Object)callee, (Object)stmt, (Object)caller);
        if (!this.calleeCallSiteReachabilityCache.containsKey(_trp)) {
            SimpleNode _n = this.graphCache.queryNode((Object)callee);
            GraphReachabilityPredicate _rp = new GraphReachabilityPredicate((IObjectNode)_n, true, this.graphCache);
            if (_rp.evaluate((Object)caller)) {
                InvokeExpr _ie = stmt.getInvokeExpr();
                Context _context = new Context();
                _context.setRootMethod(caller);
                Collection<SootMethod> _methodsThatMayCallCallee = this.getCallees(_ie, _context);
                _result = _methodsThatMayCallCallee.contains(callee) || CollectionUtils.exists(_methodsThatMayCallCallee, (IPredicate)_rp);
            } else {
                _result = false;
            }
            this.calleeCallSiteReachabilityCache.put((Triple<SootMethod, Stmt, SootMethod>)_trp, _result);
        } else {
            _result = this.calleeCallSiteReachabilityCache.get(_trp);
        }
        return _result;
    }

    public boolean isReachable(SootMethod method) {
        return this.reachables.contains(method);
    }

    public void reset() {
        this.unstable();
        this.caller2callees.clear();
        this.callee2callers.clear();
        this.graphCache = null;
        this.topDownSCC = null;
        this.reachables.clear();
        this.heads.clear();
        this.method2forwardReachableMethods.clear();
        this.invocationsite2reachableMethods.clear();
        this.calleeCallSiteReachabilityCache.clear();
    }

    public String toString() {
        StringBuffer _result = new StringBuffer();
        ArrayList<SootMethod> _temp1 = new ArrayList<SootMethod>();
        _result.append("Roots of the system: ");
        _temp1.addAll(this.getEntryMethods());
        Collections.sort(_temp1, ToStringBasedComparator.getComparator());
        Iterator _i = _temp1.iterator();
        while (_i.hasNext()) {
            _result.append("\t" + ((SootMethod)_i.next()).getSignature());
        }
        _result.append("\nReachable methods in the system: " + this.getReachableMethods().size() + "\n" + this.getReachableMethods());
        _result.append("Strongly Connected components in the system: " + this.getSCCs(true).size() + "\n");
        _result.append("top-down\n");
        _temp1.clear();
        _temp1.addAll((Collection)this.caller2callees.keySet());
        Collections.sort(_temp1, ToStringBasedComparator.getComparator());
        ArrayList<ICallGraphInfo.CallTriple> _temp3 = new ArrayList<ICallGraphInfo.CallTriple>();
        for (SootMethod _caller : _temp1) {
            _result.append("\n" + _caller.getSignature() + "\n");
            _temp3.clear();
            _temp3.addAll(this.caller2callees.get(_caller));
            Collections.sort(_temp3, new CallTripleMethodToStringBasedComparator());
            for (ICallGraphInfo.CallTriple _ctrp : _temp3) {
                _result.append("\t" + _ctrp + "\n");
            }
        }
        _result.append("bottom-up\n");
        _temp1.clear();
        _temp1.addAll((Collection)this.callee2callers.keySet());
        Collections.sort(_temp1, ToStringBasedComparator.getComparator());
        for (SootMethod _callee : _temp1) {
            _result.append("\n" + _callee.getSignature() + "\n");
            _temp3.clear();
            _temp3.addAll(this.callee2callers.get(_callee));
            Collections.sort(_temp3, new CallTripleMethodToStringBasedComparator());
            for (ICallGraphInfo.CallTriple _ctrp : _temp3) {
                _result.append("\t" + _ctrp.getMethod().getSignature() + "\n");
            }
        }
        return _result.toString();
    }

    IDirectedGraph<?> getCallGraph() {
        return this.graphCache;
    }

    private void calculateHeads() {
        Set<SootMethod> _keySet = this.callee2callers.keySet();
        Iterator<SootMethod> _i = _keySet.iterator();
        int _iEnd = _keySet.size();
        this.heads.addAll(this.reachables);
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootMethod _method = _i.next();
            if (!this.callee2callers.get(_method).isEmpty()) {
                this.heads.remove(_method);
            }
            ++_iIndex;
        }
    }

    private void createGraph() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting construction of call graph...");
        }
        this.graphCache = new SimpleNodeGraph();
        for (SootMethod _caller : this.reachables) {
            SimpleNode _callerNode = this.graphCache.getNode((Object)_caller);
            Collection _callees = MapUtils.queryCollection(this.caller2callees, (Object)_caller);
            if (_callees.isEmpty()) continue;
            for (ICallGraphInfo.CallTriple _ctrp : _callees) {
                SootMethod _method = _ctrp.getMethod();
                this.graphCache.addEdgeFromTo((IMutableNode)_callerNode, (IMutableNode)this.graphCache.getNode((Object)_method));
            }
        }
        this.graphCache.setConnectivityCacheSize(CONNECTIVITY_CACHE_SIZE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Call Graph : " + this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: call graph consolidation");
        }
    }

    private Collection<SootMethod> getMethodsReachableFromHelper(SootMethod root, boolean forward) {
        Map<SootMethod, Collection<SootMethod>> _map = forward ? this.method2forwardReachableMethods : this.method2backwardReachableMethods;
        Collection<SootMethod> _result = _map.get(root);
        if (_result == null) {
            _result = new ArrayList<SootMethod>();
            CollectionUtils.transform((Collection)this.graphCache.getReachablesFrom((INode)this.graphCache.queryNode((Object)root), forward), (ITransformer)this.graphCache.getObjectExtractor(), _result);
            _map.put(root, _result);
        }
        return _result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICallInfo {
        public Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> getCallee2CallersMap();

        public Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> getCaller2CalleesMap();

        public Collection<SootMethod> getReachableMethods();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallTripleMethodToStringBasedComparator
    implements Comparator<ICallGraphInfo.CallTriple> {
        private CallTripleMethodToStringBasedComparator() {
        }

        @Override
        public int compare(ICallGraphInfo.CallTriple o1, ICallGraphInfo.CallTriple o2) {
            int _i = o1.getMethod().getSignature().compareTo(o2.getMethod().getSignature());
            return _i == 0 ? o1.toString().compareTo(o2.toString()) : _i;
        }
    }
}

