/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.callgraphs;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IClassHierarchy;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.ICallInfoCollector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

public final class CHABasedCallInfoCollector
extends AbstractProcessor
implements ICallInfoCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHABasedCallInfoCollector.class);
    private final CallInfo callInfoHolder = new CallInfo();
    private IClassHierarchy cha;
    private final Map<SootMethod, Collection<ICallGraphInfo.CallTriple>> invokedMethod2callerTriple = new HashMap<SootMethod, Collection<ICallGraphInfo.CallTriple>>();

    public void callback(SootMethod method) {
        this.callInfoHolder.addReachable(method);
    }

    public void callback(ValueBox vBox, Context context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("callback(ValueBox vBox = " + vBox + ", Context context = " + context + ") - BEGIN");
        }
        Value _val = vBox.getValue();
        Stmt _stmt = context.getStmt();
        SootMethod _caller = context.getCurrentMethod();
        InvokeExpr _expr = (InvokeExpr)_val;
        SootMethod _callee = _expr.getMethod();
        Collection _callees = MapUtils.getCollectionFromMap(this.callInfoHolder.caller2callees, (Object)_caller);
        ICallGraphInfo.CallTriple _callerTriple = new ICallGraphInfo.CallTriple(_caller, _stmt, _expr);
        if (_expr instanceof StaticInvokeExpr || _expr instanceof SpecialInvokeExpr && (_callee.getName().equals("<init>") || _callee.isPrivate())) {
            Collection _callers = MapUtils.getCollectionFromMap(this.callInfoHolder.callee2callers, (Object)_callee);
            _callers.add(_callerTriple);
            _callees.add(new ICallGraphInfo.CallTriple(_callee, _stmt, _expr));
        } else {
            MapUtils.putIntoCollectionInMap(this.invokedMethod2callerTriple, (Object)_callee, (Object)_callerTriple);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("callback() - END");
        }
    }

    public void consolidate() {
        HashSet<SootMethod> _temp = new HashSet<SootMethod>();
        HashSet<SootClass> _implClasses = new HashSet<SootClass>();
        Set<Map.Entry<SootMethod, Collection<ICallGraphInfo.CallTriple>>> _entrySet = this.invokedMethod2callerTriple.entrySet();
        Iterator<Map.Entry<SootMethod, Collection<ICallGraphInfo.CallTriple>>> _j = _entrySet.iterator();
        int _jEnd = _entrySet.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            Map.Entry<SootMethod, Collection<ICallGraphInfo.CallTriple>> _entry = _j.next();
            SootMethod _invokedMethod = _entry.getKey();
            Collection<ICallGraphInfo.CallTriple> _callerTriples = _entry.getValue();
            String _invokedMethodSubSignature = _invokedMethod.getSubSignature();
            SootClass _declInterface = _invokedMethod.getDeclaringClass();
            _implClasses.clear();
            _implClasses.addAll(this.cha.getProperSubclassesOf(_declInterface));
            _implClasses.add(_declInterface);
            Iterator _i = _implClasses.iterator();
            int _iEnd = _implClasses.size();
            _temp.clear();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                SootClass _impl = (SootClass)_i.next();
                if (_impl.declaresMethod(_invokedMethodSubSignature) && !_impl.getMethod(_invokedMethodSubSignature).isAbstract()) {
                    SootMethod _implMethod = _impl.getMethod(_invokedMethodSubSignature);
                    MapUtils.putAllIntoCollectionInMap(this.callInfoHolder.callee2callers, (Object)_implMethod, _callerTriples);
                    _temp.add(_implMethod);
                }
                ++_iIndex;
            }
            Iterator<ICallGraphInfo.CallTriple> _k = _callerTriples.iterator();
            int _kEnd = _callerTriples.size();
            int _kIndex = 0;
            while (_kIndex < _kEnd) {
                ICallGraphInfo.CallTriple _callerTriple = _k.next();
                SootMethod _caller = _callerTriple.getMethod();
                Stmt _stmt = _callerTriple.getStmt();
                InvokeExpr _expr = _callerTriple.getExpr();
                Collection _callees = MapUtils.getCollectionFromMap(this.callInfoHolder.caller2callees, (Object)_caller);
                Iterator _l = _temp.iterator();
                int _lEnd = _temp.size();
                int _lIndex = 0;
                while (_lIndex < _lEnd) {
                    SootMethod _callee = (SootMethod)_l.next();
                    _callees.add(new ICallGraphInfo.CallTriple(_callee, _stmt, _expr));
                    ++_lIndex;
                }
                ++_kIndex;
            }
            ++_jIndex;
        }
        this.callInfoHolder.fixupMethodsHavingZeroCallersAndCallees();
        this.invokedMethod2callerTriple.clear();
        this.stable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END - Call info collection");
        }
    }

    public CallGraphInfo.ICallInfo getCallInfo() {
        return this.callInfoHolder;
    }

    public void hookup(ProcessingController ppc) {
        ppc.register((IProcessor)this);
        ppc.register(InterfaceInvokeExpr.class, (IProcessor)this);
        ppc.register(SpecialInvokeExpr.class, (IProcessor)this);
        ppc.register(StaticInvokeExpr.class, (IProcessor)this);
        ppc.register(VirtualInvokeExpr.class, (IProcessor)this);
    }

    public void initialize(IClassHierarchy analysis) {
        this.cha = analysis;
    }

    public void processingBegins() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN - Call info collection");
        }
    }

    public void reset() {
        super.reset();
        this.callInfoHolder.reset();
        this.cha = null;
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister((IProcessor)this);
        ppc.unregister(InterfaceInvokeExpr.class, (IProcessor)this);
        ppc.unregister(SpecialInvokeExpr.class, (IProcessor)this);
        ppc.unregister(StaticInvokeExpr.class, (IProcessor)this);
        ppc.unregister(VirtualInvokeExpr.class, (IProcessor)this);
    }
}

