/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.staticanalyses.flow.IIndex;
import edu.ksu.cis.indus.staticanalyses.flow.indexmanagement.IIndexManagementStrategy;
import edu.ksu.cis.indus.staticanalyses.flow.indexmanagement.MemoryIntensiveIndexManagementStrategy;
import edu.ksu.cis.indus.staticanalyses.flow.indexmanagement.ProcessorIntensiveIndexManagementStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constants {
    public static final String CONSTANTS_CONFIGURATION_FILE_PROPERTY = "indus.staticanalyses.constant.configuration.properties.file";
    public static final String MEMORY_INTENSIVE_INDEX_MANAGEMENT = "MEMORY_INTENSIVE_INDEX_MANAGEMENT";
    public static final String PROCESSOR_INTENSIVE_INDEX_MANAGEMENT = "PROCESSOR_INTENSIVE_INDEX_MANAGEMENT";
    public static final String INDEX_MANAGEMENT_STRATEGY_PROPERTY = "edu.ksu.cis.indus.staticanalyses.flow.indexManagementStrategy";
    public static final String SCC_OPTIMIZATION_INTERVAL_PROPERTY = "edu.ksu.cis.indus.staticanalyses.flow.FA.sccOptimizationInterval";
    public static final String INDUS_STATICANALYSES_TOKENMANAGERTYPE = "edu.ksu.cis.indus.staticanalyses.tokens.TokenManagerClass";
    public static final String OBJECT_SENSITIVITY_SCOPE_PATTERN_PROPERTY = "edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.ObjectSensitivityScope.pattern";
    public static final String FA_SCOPE_PATTERN_PROPERTY = "edu.ksu.cis.indus.staticanalyses.flow.FAScope.pattern";
    public static final String OBJECT_SENSITIVE_ARRAY_TRACKING_PROPERTY = "edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.ObjectSensitivityArrayTracking";
    private static final int DEFAULT_SCC_OPTIMIZATION_INTERVAL = 1000;
    private static final Properties CONFIGURATIONS = new Properties();

    static {
        String _propFileName = System.getProperty(CONSTANTS_CONFIGURATION_FILE_PROPERTY);
        if (_propFileName != null) {
            try {
                InputStream _stream = ClassLoader.getSystemResourceAsStream(_propFileName);
                CONFIGURATIONS.load(_stream);
            }
            catch (IOException _e) {
                System.err.println("Well, error loading property file.  Bailing.");
                throw new RuntimeException(_e);
            }
        }
    }

    @Empty
    private Constants() {
    }

    public static String getFAScopePattern() {
        return CONFIGURATIONS.getProperty(FA_SCOPE_PATTERN_PROPERTY);
    }

    public static <I extends IIndex<I>> IIndexManagementStrategy<I> getIndexManagementStrategy() {
        String _t = CONFIGURATIONS.getProperty(INDEX_MANAGEMENT_STRATEGY_PROPERTY);
        IIndexManagementStrategy _result = _t != null && _t.equals(MEMORY_INTENSIVE_INDEX_MANAGEMENT) ? new MemoryIntensiveIndexManagementStrategy() : new ProcessorIntensiveIndexManagementStrategy();
        return _result;
    }

    public static boolean getObjectSensitiveArrayTracking() {
        return Constants.retrieveBooleanValue(true, OBJECT_SENSITIVE_ARRAY_TRACKING_PROPERTY, CONFIGURATIONS);
    }

    public static String getObjectSensitivityScopePattern() {
        return CONFIGURATIONS.getProperty(OBJECT_SENSITIVITY_SCOPE_PATTERN_PROPERTY);
    }

    public static int getSCCOptimizationIntervalForFA() {
        int _result = edu.ksu.cis.indus.common.soot.Constants.retrieveIntValue((int)1000, (String)SCC_OPTIMIZATION_INTERVAL_PROPERTY, (Properties)CONFIGURATIONS);
        return _result;
    }

    public static String getTokenManagerType() {
        String _t = CONFIGURATIONS.getProperty(INDUS_STATICANALYSES_TOKENMANAGERTYPE);
        String _result = _t != null ? _t : "edu.ksu.cis.indus.staticanalyses.tokens.BitSetTokenManager";
        return _result;
    }

    public static boolean retrieveBooleanValue(boolean defaultValue, String key, Properties props) throws NumberFormatException {
        String _temp = props.getProperty(key);
        boolean _result = _temp != null ? Boolean.valueOf(_temp) : defaultValue;
        return _result;
    }
}

