/*
 * Decompiled with CFR 0.152.
 */
package ase05;

import ase05.CallGraphView;
import ase05.DependenceGraphView;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.fa.IAutomaton;
import edu.ksu.cis.indus.common.fa.IState;
import edu.ksu.cis.indus.common.fa.ITransitionLabel;
import edu.ksu.cis.indus.common.fa.NFA;
import edu.ksu.cis.indus.common.fa.State;
import edu.ksu.cis.indus.common.graph.IDirectedGraphView;
import edu.ksu.cis.indus.common.graph.IEdgeLabel;
import edu.ksu.cis.indus.common.graph.IEdgeLabelledDirectedGraphView;
import edu.ksu.cis.indus.common.soot.MetricsProcessor;
import edu.ksu.cis.indus.common.soot.RootMethodTrapper;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CGBasedXMLizingProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.cfg.StaticFieldUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.concurrency.MonitorAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.SafeLockAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationSensitiveEntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.processors.AliasedUseDefInfov2;
import edu.ksu.cis.indus.staticanalyses.flow.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfluenceChecker
extends SootBasedDriver {
    static final TransitionLabel EPSILON = new TransitionLabel("-Epsilon->");
    static final TransitionLabel CALLS = new TransitionLabel("-CALLS->");
    static final TransitionLabel CD = new TransitionLabel("-CD->");
    static final TransitionLabel DD = new TransitionLabel("-DD->");
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluenceChecker.class);
    protected IValueAnalyzer<Value> aa;
    protected final Map<Comparable<?>, Object> info = new HashMap();
    final Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> cdas = new ArrayList();
    CallGraphInfo cgi;
    List<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> das = new ArrayList();
    final Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> ddas = new ArrayList();
    private final boolean invoked;

    public InfluenceChecker(boolean b) {
        this.invoked = b;
    }

    public static void main(String[] args) {
        Options _options = new Options();
        Option _option = new Option("h", "help", false, "Display message.");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("p", "soot-classpath", false, "Prepend this to soot class path.");
        _option.setArgs(1);
        _option.setArgName("classpath");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("t", "type", false, "influence type (ai, di, ci)");
        _option.setRequired(true);
        _option.setArgs(1);
        _option.setArgName("type");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("i", "invoked method", false, "consider invoked method for ai");
        _option.setArgs(0);
        _options.addOption(_option);
        _option = new Option("c", "classnames", false, "list of class of interest");
        _option.setRequired(true);
        _option.setArgs(1);
        _option.setArgName("list of classes");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        GnuParser _parser = new GnuParser();
        try {
            String _classNames;
            CommandLine _cl = _parser.parse(_options, args);
            if (_cl.hasOption("h")) {
                InfluenceChecker.printUsage(_options);
                System.exit(1);
            }
            InfluenceChecker _checker = new InfluenceChecker(_cl.hasOption('i'));
            _checker.setRootMethodTrapper(new RootMethodTrapper(){

                protected boolean isThisARootMethod(SootMethod sm) {
                    return true;
                }
            });
            if (_cl.hasOption('p')) {
                _checker.addToSootClassPath(_cl.getOptionValue('p'));
            }
            if ((_classNames = _cl.getOptionValue('c')).length() == 0) {
                throw new MissingArgumentException("Please specify atleast one class.");
            }
            _checker.setClassNames(Arrays.asList(_classNames.split(" ")));
            InterferenceDAv3 _da1 = new InterferenceDAv3();
            _da1.setUseOFA(true);
            _checker.ddas.add(_da1);
            _checker.ddas.add(new IdentifierBasedDataDAv3());
            _checker.ddas.add(new ReferenceBasedDataDA());
            ReadyDAv1 _da2 = ReadyDAv3.getBackwardReadyDA();
            _checker.cdas.add(_da2);
            _checker.cdas.add(new NonTerminationSensitiveEntryControlDA());
            _da2.setUseOFA(true);
            _da2.setUseSafeLockAnalysis(true);
            _checker.execute();
            _checker.performCheck(_cl.getArgList(), _cl.getOptionValue('t'));
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            InfluenceChecker.printUsage(_options);
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    private static void printUsage(Options options) {
        String _cmdLineSyn = "java " + InfluenceChecker.class.getName() + " <options> <classnames>";
        new HelpFormatter().printHelp(_cmdLineSyn, "Options are: ", options, "");
    }

    private <T extends ITokens<T, Value>> void execute() {
        this.setInfoLogger(LOGGER);
        this.aa = OFAnalyzer.getFSOSAnalyzer("DependencyXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList _processors = new ArrayList();
        Pair.PairManager _pairManager = new Pair.PairManager(false, true);
        this.cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        ThreadGraph _tgi = new ThreadGraph(this.cgi, new CFGAnalysis(this.cgi, this.getBbm()), _pairManager);
        ProcessingController _xmlcgipc = new ProcessingController();
        ValueAnalyzerBasedProcessingController _cgipc = new ValueAnalyzerBasedProcessingController();
        MetricsProcessor _countingProcessor = new MetricsProcessor();
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(this.aa);
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("DependencyXMLizer:FA"));
        _cgipc.setAnalyzer(this.aa);
        _cgipc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(this.cgi));
        _cgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _xmlcgipc.setEnvironment(this.aa.getEnvironment());
        _xmlcgipc.setProcessingFilter((IProcessingFilter)new CGBasedXMLizingProcessingFilter(this.cgi));
        _xmlcgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        StaticFieldUseDefInfo _staticFieldUD = new StaticFieldUseDefInfo();
        AliasedUseDefInfov2 _aliasUD = new AliasedUseDefInfov2(this.aa, this.cgi, _tgi, this.bbm, _pairManager);
        this.info.put(ICallGraphInfo.ID, (Object)this.cgi);
        this.info.put(IThreadGraphInfo.ID, _tgi);
        this.info.put(Pair.PairManager.ID, _pairManager);
        this.info.put(IEnvironment.ID, this.aa.getEnvironment());
        this.info.put(IValueAnalyzer.ID, this.aa);
        this.info.put(IUseDefInfo.ALIASED_USE_DEF_ID, _aliasUD);
        this.info.put(IUseDefInfo.GLOBAL_USE_DEF_ID, (Object)_staticFieldUD);
        EquivalenceClassBasedEscapeAnalysis _ecba = new EquivalenceClassBasedEscapeAnalysis(this.cgi, null, this.getBbm());
        this.info.put(IEscapeInfo.ID, _ecba);
        MonitorAnalysis _monitorInfo = new MonitorAnalysis();
        this.info.put(IMonitorInfo.ID, _monitorInfo);
        SafeLockAnalysis _sla = new SafeLockAnalysis();
        this.info.put(SafeLockAnalysis.ID, _sla);
        this.initialize();
        this.aa.analyze(this.getEnvironment(), this.getRootMethods());
        _callGraphInfoCollector.reset();
        _processors.clear();
        _processors.add(_callGraphInfoCollector);
        _pc.reset();
        _pc.driveProcessors(_processors);
        this.cgi.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
        this.writeInfo("CALL GRAPH:\n" + this.cgi.toString());
        _processors.clear();
        _tgi.reset();
        _processors.add(_tgi);
        _processors.add(_countingProcessor);
        _cgipc.reset();
        _cgipc.driveProcessors(_processors);
        this.writeInfo("THREAD GRAPH:\n" + _tgi.toString());
        this.writeInfo("STATISTICS: " + MapUtils.verbosePrint((Map)_countingProcessor.getStatistics()));
        _aliasUD.hookup(_cgipc);
        _staticFieldUD.hookup(_cgipc);
        _cgipc.process();
        _staticFieldUD.unhook(_cgipc);
        _aliasUD.unhook(_cgipc);
        this.writeInfo("BEGIN: dependency analyses");
        AnalysesController _ac = new AnalysesController(this.info, _cgipc, this.getBbm());
        _ac.addAnalyses(IMonitorInfo.ID, (Collection<? extends IAnalysis>)Collections.singleton(_monitorInfo));
        _ac.addAnalyses(IEscapeInfo.ID, (Collection<? extends IAnalysis>)Collections.singleton(_ecba));
        _ac.addAnalyses(SafeLockAnalysis.ID, (Collection<? extends IAnalysis>)Collections.singleton(_sla));
        Iterator _i1 = IteratorUtils.chainedIterator(this.cdas.iterator(), this.ddas.iterator());
        while (_i1.hasNext()) {
            IDependencyAnalysis _da = (IDependencyAnalysis)_i1.next();
            for (Comparable comparable : _da.getIds()) {
                _ac.addAnalyses(comparable, (Collection<? extends IAnalysis>)Collections.singleton(_da));
            }
        }
        _ac.initialize();
        _ac.execute();
    }

    private IAutomaton<State, TransitionLabel> getAutomaton(String type) {
        NFA _result = new NFA((ITransitionLabel.IEpsilonLabelFactory)new ITransitionLabel.IEpsilonLabelFactory<TransitionLabel>(){

            public TransitionLabel getEpsilonTransitionLabel() {
                return EPSILON;
            }
        });
        if (type.equals("di")) {
            State _s1 = new State((Object)"s1");
            State _s2 = new State((Object)"s2");
            State _s3 = new State((Object)"s3");
            _result.addFinalState((IState)_s3);
            _result.setStartState((IState)_s1);
            _result.addLabelledTransitionFromTo((IState)_s1, (ITransitionLabel)DD, (IState)_s1);
            _result.addLabelledTransitionFromTo((IState)_s1, (ITransitionLabel)EPSILON, (IState)_s2);
            _result.addLabelledTransitionFromTo((IState)_s2, (ITransitionLabel)CD, (IState)_s2);
            _result.addLabelledTransitionFromTo((IState)_s2, (ITransitionLabel)EPSILON, (IState)_s3);
            _result.addLabelledTransitionFromTo((IState)_s3, (ITransitionLabel)DD, (IState)_s3);
        } else if (type.equals("ci")) {
            State _s1 = new State((Object)"s1");
            State _s2 = new State((Object)"s2");
            State _s3 = new State((Object)"s3");
            State _s4 = new State((Object)"s4");
            State _s5 = new State((Object)"s5");
            _result.addFinalState((IState)_s5);
            _result.setStartState((IState)_s1);
            _result.addLabelledTransitionFromTo((IState)_s1, (ITransitionLabel)DD, (IState)_s1);
            _result.addLabelledTransitionFromTo((IState)_s1, (ITransitionLabel)EPSILON, (IState)_s2);
            _result.addLabelledTransitionFromTo((IState)_s2, (ITransitionLabel)CD, (IState)_s2);
            _result.addLabelledTransitionFromTo((IState)_s2, (ITransitionLabel)EPSILON, (IState)_s3);
            _result.addLabelledTransitionFromTo((IState)_s3, (ITransitionLabel)DD, (IState)_s3);
            _result.addLabelledTransitionFromTo((IState)_s3, (ITransitionLabel)EPSILON, (IState)_s4);
            _result.addLabelledTransitionFromTo((IState)_s4, (ITransitionLabel)CD, (IState)_s5);
            _result.addLabelledTransitionFromTo((IState)_s5, (ITransitionLabel)CD, (IState)_s5);
        } else if (type.equals("ai")) {
            State _s1 = new State((Object)"s1");
            State _s2 = new State((Object)"s2");
            _result.addFinalState((IState)_s2);
            _result.setStartState((IState)_s1);
            _result.addLabelledTransitionFromTo((IState)_s1, (ITransitionLabel)CALLS, (IState)_s2);
            _result.addLabelledTransitionFromTo((IState)_s2, (ITransitionLabel)CALLS, (IState)_s2);
        } else {
            throw new IllegalArgumentException("type has to be one of ai, di, ci.");
        }
        _result.start();
        return _result;
    }

    private IEdgeLabelledDirectedGraphView<IDirectedGraphView.INode> getGraph(String type) {
        Object _result;
        if (type.equals("ai")) {
            _result = new CallGraphView(this, this.invoked);
        } else if (type.equals("di") || type.equals("ci")) {
            _result = new DependenceGraphView(this);
        } else {
            throw new IllegalArgumentException("type has to be one of ai, ddi, cdi, ci, or di.");
        }
        return _result;
    }

    private SootMethod getMethod(String clazz, String methodSignature) {
        SootClass _sc = this.getEnvironment().getClass(clazz);
        SootMethod _result = _sc.getMethod(methodSignature);
        return _result;
    }

    private PairNode getSourceAndTargets(List<String> args, String type, Collection<PairNode> targets) {
        Iterator<String> _i = args.iterator();
        SootMethod _sm = this.getMethod(_i.next(), _i.next());
        Stmt _ss = type.equals("ai") ? null : this.getStmt(_sm, Integer.parseInt(_i.next()));
        while (_i.hasNext()) {
            String _ecName = _i.next();
            String _emSig = _i.next();
            SootMethod _em = this.getMethod(_ecName, _emSig);
            Stmt _es = type.equals("ai") ? null : this.getStmt(_em, Integer.parseInt(_i.next()));
            targets.add(new PairNode(_es, _em));
        }
        return new PairNode(_ss, _sm);
    }

    private Stmt getStmt(SootMethod sm, int index) {
        ArrayList _units = new ArrayList(this.getBbm().getStmtGraph(sm).getBody().getUnits());
        return (Stmt)_units.get(index);
    }

    private void performCheck(List<String> args, String type) {
        IEdgeLabelledDirectedGraphView<IDirectedGraphView.INode> _graph = this.getGraph(type);
        LIFOWorkBag _wb = new LIFOWorkBag();
        HashSet<PairNode> _targets = new HashSet<PairNode>();
        PairNode _source = this.getSourceAndTargets(args, type, _targets);
        HashSet<Stack> _matchedPaths = new HashSet<Stack>();
        _wb.addWork((Object)new Triple((Object)_source, (Object)new Stack(), this.getAutomaton(type)));
        int _missedPaths = 0;
        while (_wb.hasWork()) {
            Triple _triple = (Triple)_wb.getWork();
            IDirectedGraphView.INode _src = (IDirectedGraphView.INode)_triple.getFirst();
            Stack _path = (Stack)_triple.getSecond();
            IAutomaton _auto = (IAutomaton)_triple.getThird();
            _path.push((Object)_src);
            if (_auto.isInFinalState() && _targets.contains(_src)) {
                _matchedPaths.add(_path);
                continue;
            }
            if (_auto.canPerformTransition((ITransitionLabel)EPSILON)) {
                IAutomaton _aclone = _auto.clone();
                _aclone.performTransitionOn((ITransitionLabel)EPSILON);
                Stack _temp = _path.clone();
                _temp.push((Object)EPSILON);
                _wb.addWork((Object)new Triple((Object)_src, (Object)_temp, (Object)_aclone));
            }
            HashSet<Triple> _temp = new HashSet<Triple>();
            ArrayList<Collection> _succs = new ArrayList<Collection>();
            Collection _outgoingEdgeLabels = _graph.getOutgoingEdgeLabels(_src);
            Iterator _i = _outgoingEdgeLabels.iterator();
            int _iEnd = _outgoingEdgeLabels.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                TransitionLabel _label = (TransitionLabel)_i.next();
                if (_auto.canPerformTransition((ITransitionLabel)_label)) {
                    Collection _succsViaLabel = _graph.getSuccsViaEdgesLabelled(_src, (IEdgeLabel)_label);
                    Iterator _j = _succsViaLabel.iterator();
                    int _jEnd = _succsViaLabel.size();
                    int _jIndex = 0;
                    while (_jIndex < _jEnd) {
                        IDirectedGraphView.INode _dest = (IDirectedGraphView.INode)_j.next();
                        if (!_path.contains((Object)_dest)) {
                            IAutomaton _aclone = _auto.clone();
                            _aclone.performTransitionOn((ITransitionLabel)_label);
                            Stack _t = _path.clone();
                            _t.push((Object)_label);
                            _temp.add(new Triple((Object)_dest, (Object)_t, (Object)_aclone));
                        }
                        ++_jIndex;
                    }
                    _succs.add(_succsViaLabel);
                }
                ++_iIndex;
            }
            _wb.addAllWorkNoDuplicates(_temp);
            if (!_temp.isEmpty() && _temp.size() == _succs.size()) continue;
            ++_missedPaths;
        }
        System.out.println("Starting at statement '" + _source.first + "' in method '" + _source.second + "'");
        Iterator _i = _targets.iterator();
        int _iEnd = _targets.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            PairNode _p = (PairNode)_i.next();
            System.out.println("Ending at statement '" + _p.first + "' in method '" + _p.second + "'");
            ++_iIndex;
        }
        System.out.println("Type: " + type);
        System.out.println("Lower bound on the number of Missed paths: " + _missedPaths);
        System.out.println("Number of Matched paths: " + _matchedPaths.size());
        System.out.println("Matched paths are ");
        Iterator _j = _matchedPaths.iterator();
        int _jEnd = _matchedPaths.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            Stack _path = (Stack)_j.next();
            System.out.println(_path + "\n");
            ++_jIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PairNode
    implements IDirectedGraphView.INode {
        final Object first;
        final Object second;

        PairNode(Object f, Object s) {
            this.first = f;
            this.second = s;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PairNode)) {
                return false;
            }
            PairNode _rhs = (PairNode)object;
            return new EqualsBuilder().append(this.first, _rhs.first).append(this.second, _rhs.second).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(7, 37).append(this.first).append(this.second).toHashCode();
        }

        public String toString() {
            return "(" + this.first + ", " + this.second + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransitionLabel
    implements ITransitionLabel<TransitionLabel> {
        final String label;

        TransitionLabel(String theLabel) {
            this.label = theLabel;
        }

        public String toString() {
            return this.label;
        }
    }
}

