/*
 * Decompiled with CFR 0.152.
 */
package ase05;

import ase05.InfluenceChecker;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.graph.IDirectedGraphView;
import edu.ksu.cis.indus.common.graph.IEdgeLabel;
import edu.ksu.cis.indus.common.graph.IEdgeLabelledDirectedGraphView;
import edu.ksu.cis.indus.common.soot.SootPredicatesAndTransformers;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CallGraphView
implements IEdgeLabelledDirectedGraphView<IDirectedGraphView.INode> {
    private final InfluenceChecker checker;
    private final boolean invoked;

    CallGraphView(InfluenceChecker checker, boolean includeInvoked) {
        this.checker = checker;
        this.invoked = includeInvoked;
    }

    public Collection<IEdgeLabel> getIncomingEdgeLabels(IDirectedGraphView.INode node) {
        throw new UnsupportedOperationException();
    }

    public Collection<IEdgeLabel> getOutgoingEdgeLabels(IDirectedGraphView.INode node) {
        ArrayList _l;
        HashSet<IEdgeLabel> _result = new HashSet<IEdgeLabel>();
        SootMethod _method = (SootMethod)((InfluenceChecker.PairNode)node).second;
        if (!this.checker.cgi.getCallees(_method).isEmpty()) {
            _result.add((IEdgeLabel)InfluenceChecker.CALLS);
        }
        if (this.invoked && _method.hasActiveBody() && CollectionUtils.exists(_l = new ArrayList(_method.getActiveBody().getUnits()), (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE)) {
            _result.add((IEdgeLabel)InfluenceChecker.CALLS);
        }
        return _result;
    }

    public Collection<IDirectedGraphView.INode> getPredsOf(IDirectedGraphView.INode node) {
        throw new UnsupportedOperationException();
    }

    public Collection<IDirectedGraphView.INode> getPredsViaEdgesLabelled(IDirectedGraphView.INode node, IEdgeLabel label) {
        throw new UnsupportedOperationException();
    }

    public Collection<IDirectedGraphView.INode> getSuccsOf(IDirectedGraphView.INode node) {
        HashSet<IDirectedGraphView.INode> _result = new HashSet<IDirectedGraphView.INode>();
        SootMethod _method = (SootMethod)((InfluenceChecker.PairNode)node).second;
        Collection<ICallGraphInfo.CallTriple> _callees = this.checker.cgi.getCallees(_method);
        boolean _b = _method.hasActiveBody();
        if (_b) {
            ArrayList _l = new ArrayList(_method.getActiveBody().getUnits());
            CollectionUtils.filter(_l, (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE);
            Iterator<ICallGraphInfo.CallTriple> _i = _callees.iterator();
            int _iEnd = _callees.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                ICallGraphInfo.CallTriple _triple = _i.next();
                Stmt _stmt = (Stmt)_triple.getSecond();
                _result.add(new InfluenceChecker.PairNode(_stmt, _triple.getMethod()));
                if (this.invoked) {
                    _result.add(new InfluenceChecker.PairNode(_stmt, _stmt.getInvokeExpr().getMethod()));
                }
                _l.remove(_stmt);
                ++_iIndex;
            }
            if (this.invoked) {
                Iterator _j = _l.iterator();
                int _jEnd = _l.size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    Stmt _s = (Stmt)_j.next();
                    _result.add(new InfluenceChecker.PairNode(null, _s.getInvokeExpr().getMethod()));
                    ++_jIndex;
                }
            }
        }
        return _result;
    }

    public Collection<IDirectedGraphView.INode> getSuccsViaEdgesLabelled(IDirectedGraphView.INode node, IEdgeLabel label) {
        return label.equals(InfluenceChecker.CALLS) ? this.getSuccsOf(node) : Collections.EMPTY_SET;
    }
}

