/*
 * Decompiled with CFR 0.152.
 */
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAXMLizerCLI;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Rete;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.options.Options;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JessTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(JessTester.class);
    private static final NullConstant NULL = NullConstant.v();
    Rete rete = new Rete();
    SootClass sc;
    Scene scene;
    SootMethod sm;
    jess.Value value;
    private int methodCount = 0;
    final IWorkBag<SootMethod> methodsWorkBag = new HistoryAwareFIFOWorkBag(new HashSet());
    final IWorkBag<SootClass> typesWorkBag = new HistoryAwareFIFOWorkBag(new HashSet());
    private final JimpleStmtSwitch sSwitch = new JimpleStmtSwitch();
    final JimpleValueSwitch vSwitch = new JimpleValueSwitch();
    private int classCount = 0;

    public static void main(String[] args) {
        org.apache.commons.cli.Options _options = new org.apache.commons.cli.Options();
        Option _option = new Option("o", "output", true, "Directory into which xml files will be written into.");
        _option.setArgs(1);
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("p", "soot-classpath", true, "Prepend this to soot class path.");
        _option.setArgs(1);
        _option.setArgName("classpath");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("l", "pre-load-classes", false, "Preload the system before starting OFA.");
        _options.addOption(_option);
        PosixParser _parser = new PosixParser();
        try {
            String _outputDir;
            CommandLine _cl = _parser.parse(_options, args);
            if (_cl.hasOption("h")) {
                String _cmdLineSyn = "java " + OFAXMLizerCLI.class.getName() + " <options> <classnames>";
                new HelpFormatter().printHelp(_cmdLineSyn, "Options are: ", _options, "");
                System.exit(1);
            }
            if ((_outputDir = _cl.getOptionValue('o')) == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Defaulting to current directory for output.");
                }
                _outputDir = ".";
            }
            Scene _scene = Scene.v();
            Options.v().parse(Util.getSootOptions());
            if (_cl.hasOption('p')) {
                _scene.setSootClassPath(_cl.getOptionValue('p'));
            }
            String[] stringArray = _cl.getArgs();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String _cls = stringArray[n];
                _scene.loadClassAndSupport(_cls);
                ++n;
            }
            if (_cl.hasOption('l')) {
                for (SootClass _sc : _scene.getClasses()) {
                    for (SootMethod _sm : _sc.getMethods()) {
                        if (!_sm.isConcrete()) continue;
                        _sm.retrieveActiveBody();
                    }
                }
            }
            JessTester _jt = new JessTester();
            _jt.scene = _scene;
            _jt.processScene(_cl.getArgList());
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            String _cmdLineSyn = "java " + OFAXMLizerCLI.class.getName() + " <options> <classnames>";
            new HelpFormatter().printHelp(_cmdLineSyn, "Options are: ", _options, "");
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    void addTypeForProcessing(Type type) {
        if (type instanceof RefType) {
            this.typesWorkBag.addWorkNoDuplicates((Object)((RefType)type).getSootClass());
        }
    }

    void addClassForProcessing(SootClass clazz) {
        this.typesWorkBag.addWorkNoDuplicates((Object)clazz);
    }

    void addMethodForProcessing(SootMethod method) {
        this.methodsWorkBag.addWorkNoDuplicates((Object)method);
    }

    private void processClassInitializer(SootClass clazz) {
        if (clazz.declaresMethodByName("<clinit>")) {
            this.processMethod(clazz.getMethodByName("<clinit>"));
        }
    }

    private void processMethod(SootMethod method) {
        this.sm = method;
        if (method.isConcrete()) {
            System.out.println("MProcessing " + ++this.methodCount + ") " + method.getSignature());
            for (Object _except : method.getExceptions()) {
                this.addClassForProcessing((SootClass)_except);
            }
            if (Util.isStartMethod((SootMethod)method)) {
                Util.fixupThreadStartBody((Scene)this.scene);
            }
            PatchingChain _stmts = this.sm.retrieveActiveBody().getUnits();
            for (Stmt _stmt : _stmts) {
                _stmt.apply((Switch)this.sSwitch);
            }
        }
    }

    private void processClass(SootClass clazz) {
        ++this.classCount;
        System.out.println("CProcessing " + this.classCount + ") " + clazz);
        this.processClassInitializer(clazz);
        for (Object _super : clazz.getInterfaces()) {
            this.addClassForProcessing((SootClass)_super);
        }
        if (clazz.hasSuperclass()) {
            this.addClassForProcessing(clazz.getSuperclass());
        }
    }

    public void resolveInvocation(Object v, InstanceInvokeExpr e, SootMethod ctxt) {
        SootClass _sc;
        if (v instanceof NewExpr) {
            _sc = ((NewExpr)v).getBaseType().getSootClass();
        } else if (v instanceof NewArrayExpr || v instanceof NewMultiArrayExpr) {
            _sc = this.scene.getSootClass("java.lang.Object");
        } else if (v instanceof StringConstant) {
            _sc = this.scene.getSootClass("java.lang.String");
        } else {
            throw new RuntimeException("Inappropriate type at receiver site - " + e + " -- " + v + " -- " + v.getClass());
        }
        try {
            SootMethod _invokedMethod = e.getMethod();
            SootMethod _resolvedMethod = Util.findDeclaringMethod((SootClass)_sc, (SootMethod)_invokedMethod);
            Fact _fact = new Fact(this.rete.findDeftemplate("assignTo"));
            _fact.setSlotValue("lhs", new jess.Value((Object)(String.valueOf(_resolvedMethod.getSignature()) + "+thisRefCallee")));
            _fact.setSlotValue("rhs", new jess.Value((Object)(String.valueOf(_invokedMethod.getSignature()) + "+thisRefCaller")));
            _fact.setSlotValue("invocationSite", new jess.Value((Object)e));
            _fact.setSlotValue("context", new jess.Value((Object)ctxt));
            _fact.setSlotValue("index", new jess.Value(-1, 4));
            this.rete.assertFact(_fact);
            this.addClassForProcessing(_resolvedMethod.getDeclaringClass());
            this.addMethodForProcessing(_resolvedMethod);
            int _i = 0;
            while (_i < _resolvedMethod.getParameterCount()) {
                if (_resolvedMethod.getParameterType(_i) instanceof RefType) {
                    Fact _pFact = new Fact(this.rete.findDeftemplate("assignTo"));
                    _pFact.setSlotValue("lhs", new jess.Value((Object)(String.valueOf(_resolvedMethod.getSignature()) + "+" + _i)));
                    _pFact.setSlotValue("rhs", new jess.Value((Object)(String.valueOf(_invokedMethod.getSignature()) + "+" + _i)));
                    _pFact.setSlotValue("invocationSite", new jess.Value((Object)e));
                    _pFact.setSlotValue("context", new jess.Value((Object)ctxt));
                    _pFact.setSlotValue("index", new jess.Value(_i, 4));
                    this.rete.assertFact(_pFact);
                }
                ++_i;
            }
            if (_resolvedMethod.getReturnType() instanceof RefType) {
                this.addTypeForProcessing(_resolvedMethod.getReturnType());
                Fact _rFact = new Fact(this.rete.findDeftemplate("assignTo"));
                _rFact.setSlotValue("lhs", new jess.Value((Object)(String.valueOf(_invokedMethod.getSignature()) + "+returnCaller")));
                _rFact.setSlotValue("rhs", new jess.Value((Object)(String.valueOf(_resolvedMethod.getSignature()) + "+returnCallee")));
                _rFact.setSlotValue("invocationSite", new jess.Value((Object)e));
                _rFact.setSlotValue("context", new jess.Value((Object)ctxt));
                _rFact.setSlotValue("index", new jess.Value(-2, 4));
                this.rete.assertFact(_rFact);
            }
        }
        catch (IllegalStateException _e) {
            System.out.println(":-( Failed!! " + e + " -- " + v);
            _e.printStackTrace();
        }
        catch (JessException _e) {
            System.out.println(":-( Failed!! " + e + " -- " + v);
            _e.printStackTrace();
        }
    }

    public boolean isCompatible(Object v, Object obj) {
        if (v instanceof Value) {
            SootClass _sootClass = ((RefType)((Value)v).getType()).getSootClass();
            if (obj instanceof StringConstant) {
                return _sootClass.getName().equals("java.lang.String");
            }
            if (obj instanceof Value) {
                SootClass _sootClass2 = ((RefType)((Value)obj).getType()).getSootClass();
                return _sootClass2.equals(_sootClass) || Util.isDescendentOf((SootClass)_sootClass2, (SootClass)_sootClass);
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processScene(Collection<String> classes) {
        try {
            this.rete.store("Engine", (Object)this);
            this.rete.executeCommand("(import soot.jimple.*)");
            this.rete.executeCommand("(deftemplate assignTo (slot lhs) (slot rhs) (slot invocationSite (default nil)) (slot index (default -4)) (slot context (default nil)))");
            this.rete.executeCommand("(deftemplate pointsTo (slot reference) (slot object) (slot context))");
            this.rete.executeCommand("(defrule expansionRule (and (assignTo (lhs ?a) (rhs ?) (invocationSite ?c&~nil) (index -1) (context ?d)) (pointsTo (reference ?a) (object ?o) (context ?d)) ) => (call (fetch Engine) resolveInvocation ?o ?c ?d))");
            this.rete.executeCommand("(defrule pointsToRule (and (assignTo (lhs ?c) (rhs ?a&:(neq ?a ?c)) (invocationSite ?) (index ?) (context ?ctxt))(pointsTo (reference ?a) (object ?o) (context ?)))=> (if (and (call (fetch Engine) isCompatible ?c ?o) (call (fetch Engine) isCompatible ?a ?c)) then (assert (pointsTo (reference ?c) (object ?o) (context ?ctxt)))))");
            this.rete.executeCommand("(defquery findParamFactsFor \"Finds facts for Parameters at given invocation site\"(declare (variables ?callSite)) (assignTo (lhs ?a) (rhs ?b) (invocationSite ?callSite) (index ?i&:(> ?i -1)) (context ?)))");
            this.rete.executeCommand("(defquery findReturnFactsFor \"Finds facts for returned values at given invocation site\"(declare (variables ?callSite)) (assignTo (lhs ?a) (rhs ?b) (invocationSite ?callSite) (index ?i&:(= ?i -2)) (context ?)))");
            this.rete.executeCommand("(defquery findThrowFactsFor \"Finds facts for Thrown exceptions at given invocation site\"(declare (variables ?callSite)) (assignTo (lhs ?a) (rhs ?b) (invocationSite ?callSite) (index ?i&:(= ?i -3)) (context ?)))");
            _stringArrayType = ArrayType.v((Type)this.scene.getSootClass("java.lang.String").getType(), (int)1);
            _voidType = VoidType.v();
            for (String _className : classes) {
                this.sc = this.scene.getSootClass(_className);
                this.addClassForProcessing(this.sc);
                for (SootMethod _m : this.sc.getMethods()) {
                    if (!_m.getName().equals("main") || !_m.getReturnType().equals(_voidType) || _m.getParameterCount() != 1 || !_m.getParameterType(0).equals(_stringArrayType)) continue;
                    this.addMethodForProcessing(_m);
                }
            }
            ** GOTO lbl42
        }
        catch (JessException _e) {
            _e.printStackTrace();
            throw new RuntimeException(_e);
        }
        {
            this.processClass((SootClass)this.typesWorkBag.getWork());
            do {
                if (this.typesWorkBag.hasWork()) continue block4;
                while (this.methodsWorkBag.hasWork()) {
                    this.processMethod((SootMethod)this.methodsWorkBag.getWork());
                }
                this.rete.run();
lbl42:
                // 2 sources

            } while (this.typesWorkBag.hasWork() || this.methodsWorkBag.hasWork());
        }
        _sw = new StringWriter();
        this.extractFactsAsString(_sw);
        System.out.println(_sw.toString());
    }

    private void extractFactsAsString(StringWriter writer) throws JessException {
        Context _context = this.rete.getGlobalContext();
        Iterator _i = this.rete.listFacts();
        while (_i.hasNext()) {
            Fact _fact = (Fact)_i.next();
            if (_fact.getName().equals("MAIN::assignTo")) {
                writer.append("(assignTo\n\t(lhs ");
                writer.append(_fact.getSlotValue("lhs").javaObjectValue(_context).toString());
                writer.append(")\n\t(rhs ");
                writer.append(_fact.getSlotValue("rhs").javaObjectValue(_context).toString());
                writer.append(")\n\t(invocationSite ");
                Object _javaObjectValue1 = _fact.getSlotValue("invocationSite").javaObjectValue(_context);
                if (_javaObjectValue1 == null) {
                    writer.append("null");
                } else {
                    writer.append(_javaObjectValue1.toString());
                }
                writer.append(")\n\t(context ");
                Object _javaObjectValue2 = _fact.getSlotValue("context").javaObjectValue(_context);
                if (_javaObjectValue2 == null) {
                    writer.append("null");
                } else {
                    writer.append(_javaObjectValue2.toString());
                }
                writer.append(")\n\t(index ");
                writer.append(String.valueOf(_fact.getSlotValue("index").intValue(_context)));
                writer.append("))\n");
                continue;
            }
            if (!_fact.getName().equals("MAIN::pointsTo")) continue;
            writer.append("(pointsTo\n\t(reference ");
            writer.append(_fact.getSlotValue("reference").javaObjectValue(_context).toString());
            writer.append(")\n\t(object ");
            writer.append(_fact.getSlotValue("object").javaObjectValue(_context).toString());
            writer.append(")\n\t(context ");
            writer.append(_fact.getSlotValue("context").javaObjectValue(_context).toString());
            writer.append("))\n");
        }
    }

    private class JimpleStmtSwitch
    extends AbstractStmtSwitch {
        private JimpleStmtSwitch() {
        }

        public void caseAssignStmt(AssignStmt stmt) {
            Value _rightOp = stmt.getRightOp();
            if (_rightOp.getType() instanceof RefType) {
                try {
                    Fact _fact;
                    if (_rightOp instanceof NewExpr || _rightOp instanceof NewArrayExpr || _rightOp instanceof NewMultiArrayExpr || _rightOp instanceof StringConstant) {
                        _fact = new Fact(JessTester.this.rete.findDeftemplate("pointsTo"));
                        _fact.setSlotValue("object", new jess.Value((Object)_rightOp));
                        stmt.getLeftOp().apply((Switch)JessTester.this.vSwitch);
                        _fact.setSlotValue("reference", JessTester.this.value);
                    } else {
                        _fact = new Fact(JessTester.this.rete.findDeftemplate("assignTo"));
                        _rightOp.apply((Switch)JessTester.this.vSwitch);
                        _fact.setSlotValue("rhs", JessTester.this.value);
                        stmt.getLeftOp().apply((Switch)JessTester.this.vSwitch);
                        _fact.setSlotValue("lhs", JessTester.this.value);
                        if (stmt.containsInvokeExpr()) {
                            _fact.setSlotValue("invocationSite", new jess.Value((Object)stmt.getInvokeExpr()));
                        }
                    }
                    _fact.setSlotValue("context", new jess.Value((Object)JessTester.this.sm));
                    JessTester.this.rete.assertFact(_fact);
                }
                catch (JessException _e) {
                    _e.printStackTrace();
                    throw new RuntimeException(_e);
                }
            } else if (stmt.containsInvokeExpr()) {
                stmt.getRightOp().apply((Switch)JessTester.this.vSwitch);
            }
        }

        public void caseIdentityStmt(IdentityStmt stmt) {
            if (stmt.getLeftOp().getType() instanceof RefType && !(stmt.getRightOp() instanceof CaughtExceptionRef)) {
                try {
                    Fact fact = new Fact(JessTester.this.rete.findDeftemplate("assignTo"));
                    stmt.getLeftOp().apply((Switch)JessTester.this.vSwitch);
                    fact.setSlotValue("lhs", JessTester.this.value);
                    stmt.getRightOp().apply((Switch)JessTester.this.vSwitch);
                    fact.setSlotValue("rhs", JessTester.this.value);
                    fact.setSlotValue("context", new jess.Value((Object)JessTester.this.sm));
                    JessTester.this.rete.assertFact(fact);
                }
                catch (JessException _e) {
                    _e.printStackTrace();
                    throw new RuntimeException(_e);
                }
            }
        }

        public void caseInvokeStmt(InvokeStmt stmt) {
            stmt.getInvokeExpr().apply((Switch)JessTester.this.vSwitch);
        }

        public void caseReturnStmt(ReturnStmt stmt) {
            try {
                Fact fact = new Fact(JessTester.this.rete.findDeftemplate("assignTo"));
                fact.setSlotValue("lhs", new jess.Value((Object)(String.valueOf(JessTester.this.sm.getSignature()) + "+returnCallee")));
                stmt.getOp().apply((Switch)JessTester.this.vSwitch);
                fact.setSlotValue("rhs", JessTester.this.value);
                fact.setSlotValue("index", new jess.Value(-2, 4));
                fact.setSlotValue("context", new jess.Value((Object)JessTester.this.sm));
                JessTester.this.rete.assertFact(fact);
            }
            catch (JessException _e) {
                _e.printStackTrace();
                throw new RuntimeException(_e);
            }
        }

        public void caseThrowStmt(ThrowStmt stmt) {
            try {
                Fact fact = new Fact(JessTester.this.rete.findDeftemplate("assignTo"));
                fact.setSlotValue("lhs", new jess.Value((Object)(String.valueOf(JessTester.this.sm.getSignature()) + "+throwCallee")));
                stmt.getOp().apply((Switch)JessTester.this.vSwitch);
                fact.setSlotValue("rhs", JessTester.this.value);
                fact.setSlotValue("index", new jess.Value(-3, 4));
                fact.setSlotValue("context", new jess.Value((Object)JessTester.this.sm));
                JessTester.this.rete.assertFact(fact);
            }
            catch (JessException _e) {
                _e.printStackTrace();
                throw new RuntimeException(_e);
            }
        }
    }

    private class JimpleValueSwitch
    extends AbstractJimpleValueSwitch {
        private JimpleValueSwitch() {
        }

        public void caseArrayRef(ArrayRef v) {
            JessTester.this.value = new jess.Value((Object)v.getType());
        }

        public void caseCastExpr(CastExpr v) {
            v.getOp().apply((Switch)this);
        }

        public void caseInstanceFieldRef(InstanceFieldRef v) {
            if (v.getField().getType() instanceof RefType) {
                JessTester.this.value = new jess.Value((Object)v.getField());
            }
        }

        public void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
            this.caseInstanceInvokeExpr((InstanceInvokeExpr)v);
        }

        public void caseLocal(Local l) {
            JessTester.this.addTypeForProcessing(l.getType());
            JessTester.this.value = new jess.Value((Object)l);
        }

        public void caseNewArrayExpr(NewArrayExpr v) {
            JessTester.this.addTypeForProcessing(((ArrayType)v.getType()).getElementType());
            JessTester.this.value = new jess.Value((Object)v);
        }

        public void caseNewExpr(NewExpr v) {
            JessTester.this.addTypeForProcessing(v.getType());
            JessTester.this.value = new jess.Value((Object)v);
        }

        public void caseNewMultiArrayExpr(NewMultiArrayExpr v) {
            JessTester.this.addTypeForProcessing(((ArrayType)v.getType()).getElementType());
            JessTester.this.value = new jess.Value((Object)v);
        }

        public void caseNullConstant(NullConstant v) {
            JessTester.this.value = new jess.Value((Object)NULL);
        }

        public void caseParameterRef(ParameterRef v) {
            if (v.getType() instanceof RefType) {
                JessTester.this.value = new jess.Value((Object)(String.valueOf(JessTester.this.sm.getSignature()) + "+" + v.getIndex()));
            }
        }

        public void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
            this.caseInstanceInvokeExpr((InstanceInvokeExpr)v);
        }

        public void caseStaticFieldRef(StaticFieldRef v) {
            JessTester.this.value = new jess.Value((Object)v.getField());
        }

        public void caseStaticInvokeExpr(StaticInvokeExpr v) {
            try {
                SootMethod _callee = v.getMethod();
                JessTester.this.addClassForProcessing(_callee.getDeclaringClass());
                JessTester.this.addMethodForProcessing(_callee);
                int _i = 0;
                while (_i < _callee.getParameterCount()) {
                    if (v.getArg(_i).getType() instanceof RefType) {
                        JessTester.this.addTypeForProcessing(v.getArg(_i).getType());
                        Fact _fact = new Fact(JessTester.this.rete.findDeftemplate("assignTo"));
                        _fact.setSlotValue("lhs", new jess.Value((Object)(String.valueOf(_callee.getSignature()) + "+" + _i)));
                        v.getArg(_i).apply((Switch)this);
                        _fact.setSlotValue("rhs", JessTester.this.value);
                        _fact.setSlotValue("invocationSite", new jess.Value((Object)v));
                        _fact.setSlotValue("context", new jess.Value((Object)JessTester.this.sm));
                        _fact.setSlotValue("index", new jess.Value(_i, 4));
                        JessTester.this.rete.assertFact(_fact);
                    }
                    ++_i;
                }
                if (_callee.getReturnType() instanceof RefType) {
                    JessTester.this.addTypeForProcessing(_callee.getReturnType());
                    JessTester.this.value = new jess.Value((Object)(String.valueOf(_callee.getSignature()) + "+returnCaller"));
                    Fact _fact = new Fact(JessTester.this.rete.findDeftemplate("assignTo"));
                    _fact.setSlotValue("lhs", JessTester.this.value);
                    _fact.setSlotValue("rhs", new jess.Value((Object)(String.valueOf(_callee.getSignature()) + "+returnCallee")));
                    _fact.setSlotValue("invocationSite", new jess.Value((Object)v));
                    _fact.setSlotValue("context", new jess.Value((Object)JessTester.this.sm));
                    _fact.setSlotValue("index", new jess.Value(-2, 4));
                    JessTester.this.rete.assertFact(_fact);
                }
            }
            catch (JessException _e) {
                _e.printStackTrace();
                throw new RuntimeException(_e);
            }
        }

        public void caseStringConstant(StringConstant v) {
            JessTester.this.addTypeForProcessing(v.getType());
            JessTester.this.value = new jess.Value((Object)v);
        }

        public void caseThisRef(ThisRef v) {
            JessTester.this.value = new jess.Value((Object)(String.valueOf(JessTester.this.sm.getSignature()) + "+thisRefCallee"));
        }

        public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
            this.caseInstanceInvokeExpr((InstanceInvokeExpr)v);
        }

        private void caseInstanceInvokeExpr(InstanceInvokeExpr v) {
            try {
                SootMethod _invokedMethod = v.getMethod();
                JessTester.this.addClassForProcessing(_invokedMethod.getDeclaringClass());
                int _i = 0;
                while (_i < _invokedMethod.getParameterCount()) {
                    if (v.getArg(_i).getType() instanceof RefType) {
                        JessTester.this.addTypeForProcessing(v.getArg(_i).getType());
                        Fact _fact = new Fact(JessTester.this.rete.findDeftemplate("assignTo"));
                        _fact.setSlotValue("lhs", new jess.Value((Object)(String.valueOf(_invokedMethod.getSignature()) + "+" + _i)));
                        v.getArg(_i).apply((Switch)this);
                        _fact.setSlotValue("rhs", JessTester.this.value);
                        _fact.setSlotValue("invocationSite", new jess.Value((Object)v));
                        _fact.setSlotValue("index", new jess.Value(_i, 4));
                        _fact.setSlotValue("context", new jess.Value((Object)JessTester.this.sm));
                        JessTester.this.rete.assertFact(_fact);
                    }
                    ++_i;
                }
                Fact _fact = new Fact(JessTester.this.rete.findDeftemplate("assignTo"));
                _fact.setSlotValue("lhs", new jess.Value((Object)(String.valueOf(_invokedMethod.getSignature()) + "+thisRefCaller")));
                v.getBase().apply((Switch)this);
                _fact.setSlotValue("rhs", JessTester.this.value);
                _fact.setSlotValue("invocationSite", new jess.Value((Object)v));
                _fact.setSlotValue("context", new jess.Value((Object)JessTester.this.sm));
                _fact.setSlotValue("index", new jess.Value(-1, 4));
                JessTester.this.rete.assertFact(_fact);
                if (_invokedMethod.getReturnType() instanceof RefType) {
                    JessTester.this.addTypeForProcessing(_invokedMethod.getReturnType());
                    JessTester.this.value = new jess.Value((Object)(String.valueOf(_invokedMethod.getSignature()) + "+returnCaller"));
                }
            }
            catch (JessException _e) {
                _e.printStackTrace();
                throw new RuntimeException(_e);
            }
        }
    }
}

