/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Block;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class ReachChecker
extends DataFlow {
    public ReachChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true, true);
    }

    public DataFlow.Item createInitialItem(FlowGraph graph) {
        return DataFlowItem.NOT_REACHABLE;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term n, Set succEdgeKeys) {
        if (n == graph.entryNode()) {
            return ReachChecker.itemToMap(DataFlowItem.REACHABLE, succEdgeKeys);
        }
        return ReachChecker.itemToMap(in, succEdgeKeys);
    }

    public DataFlow.Item confluence(List inItems, Term node) {
        Iterator i = inItems.iterator();
        while (i.hasNext()) {
            if (!((DataFlowItem)i.next()).reachable) continue;
            return DataFlowItem.REACHABLE;
        }
        return DataFlowItem.NOT_REACHABLE;
    }

    public Node leaveCall(Node n) throws SemanticException {
        if (n instanceof Term) {
            n = this.checkReachability((Term)n);
        }
        return super.leaveCall(n);
    }

    protected Node checkReachability(Term n) throws SemanticException {
        Collection peers;
        FlowGraph g = this.currentFlowGraph();
        if (g != null && (peers = g.peers(n)) != null && !peers.isEmpty()) {
            Iterator iter = peers.iterator();
            while (iter.hasNext()) {
                FlowGraph.Peer p = (FlowGraph.Peer)iter.next();
                if (p.inItem != null && ((DataFlowItem)p.inItem).reachable) {
                    return n.reachable(true);
                }
                if (p.outItems == null) continue;
                Iterator k = p.outItems.values().iterator();
                while (k.hasNext()) {
                    DataFlowItem item = (DataFlowItem)k.next();
                    if (item == null || !item.reachable) continue;
                    return n.reachable(true);
                }
            }
            if ((n = n.reachable(false)) instanceof Block && ((Block)n).statements().isEmpty() || n instanceof Stmt && !(n instanceof CompoundStmt)) {
                throw new SemanticException("Unreachable statement.", n.position());
            }
        }
        return n;
    }

    public void post(FlowGraph graph, Term root) throws SemanticException {
        if (Report.should_report(Report.cfg, 2)) {
            this.dumpFlowGraph(graph, root);
        }
    }

    public void check(FlowGraph graph, Term n, DataFlow.Item inItem, Map outItems) throws SemanticException {
        throw new InternalCompilerError("ReachChecker.check should never be called.");
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        final boolean reachable;
        public static DataFlowItem REACHABLE = new DataFlowItem(true);
        public static DataFlowItem NOT_REACHABLE = new DataFlowItem(false);

        protected DataFlowItem(boolean reachable) {
            this.reachable = reachable;
        }

        public String toString() {
            return "reachable=" + this.reachable;
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return this.reachable == ((DataFlowItem)o).reachable;
            }
            return false;
        }

        public int hashCode() {
            return this.reachable ? 5423 : 5753;
        }
    }
}

