/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeDecl;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Initializer;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.visit.CFGBuilder;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public class InitChecker
extends DataFlow {
    protected ClassBodyInfo currCBI = null;

    public InitChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true, false);
    }

    protected FlowGraph initGraph(CodeDecl code, Term root) {
        this.currCBI.currCodeDecl = code;
        return new FlowGraph(root, this.forward);
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (n instanceof ClassBody) {
            this.setupClassBody((ClassBody)n);
        }
        return super.enterCall(n);
    }

    public Node leaveCall(Node n) throws SemanticException {
        if (n instanceof ConstructorDecl) {
            this.currCBI.allConstructors.add(n);
            return n;
        }
        if (n instanceof ClassBody) {
            Iterator iter = this.currCBI.allConstructors.iterator();
            while (iter.hasNext()) {
                ConstructorDecl cd = (ConstructorDecl)iter.next();
                this.dataflow(cd);
            }
            this.checkStaticFinalFieldsInit((ClassBody)n);
            this.checkNonStaticFinalFieldsInit((ClassBody)n);
            if (this.currCBI.outer != null) {
                this.currCBI.outer.localsUsedInClassBodies.put(n, this.currCBI.outerLocalsUsed);
            }
            this.currCBI = this.currCBI.outer;
        }
        return super.leaveCall(n);
    }

    protected void setupClassBody(ClassBody n) throws SemanticException {
        ClassBodyInfo newCDI = new ClassBodyInfo();
        newCDI.outer = this.currCBI;
        this.currCBI = newCDI;
        Iterator classMembers = n.members().iterator();
        while (classMembers.hasNext()) {
            MinMaxInitCount initCount;
            FieldDecl fd;
            ClassMember cm = (ClassMember)classMembers.next();
            if (!(cm instanceof FieldDecl) || !(fd = (FieldDecl)cm).flags().isFinal()) continue;
            if (fd.init() != null) {
                initCount = new MinMaxInitCount(InitCount.ONE, InitCount.ONE);
                if (this.currCBI.outer != null) {
                    this.dataflow(fd.init());
                }
            } else {
                initCount = new MinMaxInitCount(InitCount.ZERO, InitCount.ZERO);
            }
            newCDI.currClassFinalFieldInitCounts.put(fd.fieldInstance(), initCount);
        }
    }

    protected void checkStaticFinalFieldsInit(ClassBody cb) throws SemanticException {
        Iterator iter = this.currCBI.currClassFinalFieldInitCounts.entrySet().iterator();
        while (iter.hasNext()) {
            MinMaxInitCount initCount;
            FieldInstance fi;
            Map.Entry e = iter.next();
            if (!(e.getKey() instanceof FieldInstance) || !(fi = (FieldInstance)e.getKey()).flags().isStatic() || !fi.flags().isFinal() || !InitCount.ZERO.equals((initCount = (MinMaxInitCount)e.getValue()).getMin())) continue;
            throw new SemanticException("field \"" + fi.name() + "\" might not have been initialized", cb.position());
        }
    }

    protected void checkNonStaticFinalFieldsInit(ClassBody cb) throws SemanticException {
        Iterator iter = this.currCBI.currClassFinalFieldInitCounts.keySet().iterator();
        while (iter.hasNext()) {
            FieldInstance fi = (FieldInstance)iter.next();
            if (!fi.flags().isFinal() || fi.flags().isStatic()) continue;
            boolean fieldInitializedBeforeConstructors = false;
            MinMaxInitCount ic = (MinMaxInitCount)this.currCBI.currClassFinalFieldInitCounts.get(fi);
            if (ic != null && !InitCount.ZERO.equals(ic.getMin())) {
                fieldInitializedBeforeConstructors = true;
            }
            Iterator iter2 = this.currCBI.allConstructors.iterator();
            while (iter2.hasNext()) {
                ConstructorInstance ciStart;
                ConstructorDecl cd = (ConstructorDecl)iter2.next();
                ConstructorInstance ci = ciStart = cd.constructorInstance();
                boolean isInitialized = fieldInitializedBeforeConstructors;
                while (ci != null) {
                    Set s = (Set)this.currCBI.fieldsConstructorInitializes.get(ci);
                    if (s != null && s.contains(fi)) {
                        if (isInitialized) {
                            throw new SemanticException("field \"" + fi.name() + "\" might have already been initialized", cd.position());
                        }
                        isInitialized = true;
                    }
                    ci = (ConstructorInstance)this.currCBI.constructorCalls.get(ci);
                }
                if (isInitialized) continue;
                throw new SemanticException("field \"" + fi.name() + "\" might not have been initialized", ciStart.position());
            }
        }
    }

    protected void dataflow(Expr root) throws SemanticException {
        FlowGraph g = new FlowGraph(root, this.forward);
        CFGBuilder v = new CFGBuilder(this.ts, g, this);
        v.visitGraph();
        this.dataflow(g);
        this.post(g, root);
    }

    public DataFlow.Item createInitialItem(FlowGraph graph) {
        return new DataFlowItem(new HashMap(this.currCBI.currClassFinalFieldInitCounts));
    }

    public DataFlow.Item confluence(List inItems, Term node) {
        Iterator iter = inItems.iterator();
        HashMap<VarInstance, MinMaxInitCount> m = new HashMap<VarInstance, MinMaxInitCount>(((DataFlowItem)iter.next()).initStatus);
        while (iter.hasNext()) {
            Map n = ((DataFlowItem)iter.next()).initStatus;
            Iterator iter2 = n.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                VarInstance v = (VarInstance)entry.getKey();
                MinMaxInitCount initCount1 = (MinMaxInitCount)m.get(v);
                MinMaxInitCount initCount2 = (MinMaxInitCount)entry.getValue();
                m.put(v, MinMaxInitCount.join(initCount1, initCount2));
            }
        }
        return new DataFlowItem(m);
    }

    public Map flow(DataFlow.Item inItem, FlowGraph graph, Term n, Set succEdgeKeys) {
        DataFlowItem inDFItem = (DataFlowItem)inItem;
        Map ret = null;
        if (n instanceof Formal) {
            ret = this.flowFormal(inDFItem, graph, (Formal)n, succEdgeKeys);
        } else if (n instanceof LocalDecl) {
            ret = this.flowLocalDecl(inDFItem, graph, (LocalDecl)n, succEdgeKeys);
        } else if (n instanceof LocalAssign) {
            ret = this.flowLocalAssign(inDFItem, graph, (LocalAssign)n, succEdgeKeys);
        } else if (n instanceof FieldAssign) {
            ret = this.flowFieldAssign(inDFItem, graph, (FieldAssign)n, succEdgeKeys);
        } else if (n instanceof ConstructorCall) {
            ret = this.flowConstructorCall(inDFItem, graph, (ConstructorCall)n, succEdgeKeys);
        }
        if (ret != null) {
            return ret;
        }
        return InitChecker.itemToMap(inItem, succEdgeKeys);
    }

    protected Map flowFormal(DataFlowItem inItem, FlowGraph graph, Formal f, Set succEdgeKeys) {
        HashMap<LocalInstance, MinMaxInitCount> m = new HashMap<LocalInstance, MinMaxInitCount>(inItem.initStatus);
        m.put(f.localInstance(), new MinMaxInitCount(InitCount.ONE, InitCount.ONE));
        return InitChecker.itemToMap(new DataFlowItem(m), succEdgeKeys);
    }

    protected Map flowLocalDecl(DataFlowItem inItem, FlowGraph graph, LocalDecl ld, Set succEdgeKeys) {
        HashMap<LocalInstance, MinMaxInitCount> m = new HashMap<LocalInstance, MinMaxInitCount>(inItem.initStatus);
        if (ld.init() == null) {
            m.put(ld.localInstance(), new MinMaxInitCount(InitCount.ZERO, InitCount.ZERO));
        } else {
            m.put(ld.localInstance(), new MinMaxInitCount(InitCount.ONE, InitCount.ONE));
        }
        return InitChecker.itemToMap(new DataFlowItem(m), succEdgeKeys);
    }

    protected Map flowLocalAssign(DataFlowItem inItem, FlowGraph graph, LocalAssign a, Set succEdgeKeys) {
        HashMap<LocalInstance, MinMaxInitCount> m = new HashMap<LocalInstance, MinMaxInitCount>(inItem.initStatus);
        Local l = (Local)a.left();
        MinMaxInitCount initCount = (MinMaxInitCount)m.get(l.localInstance());
        if (initCount != null) {
            initCount = new MinMaxInitCount(initCount.getMin().increment(), initCount.getMax().increment());
            m.put(l.localInstance(), initCount);
            return InitChecker.itemToMap(new DataFlowItem(m), succEdgeKeys);
        }
        return null;
    }

    protected Map flowFieldAssign(DataFlowItem inItem, FlowGraph graph, FieldAssign a, Set succEdgeKeys) {
        HashMap<FieldInstance, MinMaxInitCount> m;
        MinMaxInitCount initCount;
        Field f = (Field)a.left();
        FieldInstance fi = f.fieldInstance();
        if (fi.flags().isFinal() && this.isFieldsTargetAppropriate(f) && (initCount = (MinMaxInitCount)(m = new HashMap<FieldInstance, MinMaxInitCount>(inItem.initStatus)).get(fi)) != null) {
            initCount = new MinMaxInitCount(initCount.getMin().increment(), initCount.getMax().increment());
            m.put(fi, initCount);
            return InitChecker.itemToMap(new DataFlowItem(m), succEdgeKeys);
        }
        return null;
    }

    protected Map flowConstructorCall(DataFlowItem inItem, FlowGraph graph, ConstructorCall cc, Set succEdgeKeys) {
        if (ConstructorCall.THIS.equals(cc.kind())) {
            this.currCBI.constructorCalls.put(((ConstructorDecl)this.currCBI.currCodeDecl).constructorInstance(), cc.constructorInstance());
        }
        return null;
    }

    protected boolean isFieldsTargetAppropriate(Field f) {
        if (f.fieldInstance().flags().isStatic()) {
            ClassType containingClass = (ClassType)this.currCBI.currCodeDecl.codeInstance().container();
            return containingClass.equals(f.fieldInstance().container());
        }
        return f.target() instanceof Special && Special.THIS.equals(((Special)f.target()).kind());
    }

    public void check(FlowGraph graph, Term n, DataFlow.Item inItem, Map outItems) throws SemanticException {
        Set localsUsed;
        DataFlowItem dfIn = (DataFlowItem)inItem;
        if (dfIn == null) {
            dfIn = (DataFlowItem)this.createInitialItem(graph);
        }
        DataFlowItem dfOut = null;
        if (outItems != null && !outItems.isEmpty()) {
            dfOut = (DataFlowItem)outItems.values().iterator().next();
        }
        if (n instanceof Local) {
            this.checkLocal(graph, (Local)n, dfIn, dfOut);
        } else if (n instanceof LocalAssign) {
            this.checkLocalAssign(graph, (LocalAssign)n, dfIn, dfOut);
        } else if (n instanceof FieldAssign) {
            this.checkFieldAssign(graph, (FieldAssign)n, dfIn, dfOut);
        } else if (n instanceof ClassBody && (localsUsed = (Set)this.currCBI.localsUsedInClassBodies.get(n)) != null) {
            this.checkLocalsUsedByInnerClass(graph, (ClassBody)n, localsUsed, dfIn, dfOut);
        }
        if (n == graph.finishNode() && this.currCBI.currCodeDecl instanceof Initializer) {
            Iterator iter = dfOut.initStatus.entrySet().iterator();
            while (iter.hasNext()) {
                FieldInstance fi;
                Map.Entry e = iter.next();
                if (!(e.getKey() instanceof FieldInstance) || !(fi = (FieldInstance)e.getKey()).flags().isFinal()) continue;
                this.currCBI.currClassFinalFieldInitCounts.put(fi, e.getValue());
            }
        }
    }

    protected void checkLocal(FlowGraph graph, Local l, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        MinMaxInitCount initCount = (MinMaxInitCount)dfIn.initStatus.get(l.localInstance());
        if (initCount == null) {
            this.currCBI.outerLocalsUsed.add(l.localInstance());
        } else if (InitCount.ZERO.equals(initCount.getMin())) {
            throw new SemanticException("Local variable \"" + l.name() + "\" may not have been initialized", l.position());
        }
    }

    protected void checkLocalAssign(FlowGraph graph, LocalAssign a, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        LocalInstance li = ((Local)a.left()).localInstance();
        MinMaxInitCount initCount = (MinMaxInitCount)dfOut.initStatus.get(li);
        if (initCount == null) {
            throw new SemanticException("Final local variable \"" + li.name() + "\" cannot be assigned to in an inner class.", a.position());
        }
        if (li.flags().isFinal() && InitCount.MANY.equals(initCount.getMax())) {
            throw new SemanticException("variable \"" + li.name() + "\" might already have been assigned to", a.position());
        }
    }

    protected void checkFieldAssign(FlowGraph graph, FieldAssign a, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        Field f = (Field)a.left();
        FieldInstance fi = f.fieldInstance();
        if (fi.flags().isFinal()) {
            if ((this.currCBI.currCodeDecl instanceof ConstructorDecl || this.currCBI.currCodeDecl instanceof Initializer) && this.isFieldsTargetAppropriate(f)) {
                MinMaxInitCount initCount = (MinMaxInitCount)dfOut.initStatus.get(fi);
                if (InitCount.MANY.equals(initCount.getMax())) {
                    throw new SemanticException("field \"" + fi.name() + "\" might already have been assigned to", a.position());
                }
                if (!fi.flags().isStatic() && this.currCBI.currCodeDecl instanceof ConstructorDecl) {
                    ConstructorInstance ci = ((ConstructorDecl)this.currCBI.currCodeDecl).constructorInstance();
                    HashSet<FieldInstance> s = (HashSet<FieldInstance>)this.currCBI.fieldsConstructorInitializes.get(ci);
                    if (s == null) {
                        s = new HashSet<FieldInstance>();
                        this.currCBI.fieldsConstructorInitializes.put(ci, s);
                    }
                    s.add(fi);
                }
            } else {
                throw new SemanticException("Cannot assign a value to final field \"" + fi.name() + "\"", a.position());
            }
        }
    }

    protected void checkLocalsUsedByInnerClass(FlowGraph graph, ClassBody cb, Set localsUsed, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        Iterator iter = localsUsed.iterator();
        while (iter.hasNext()) {
            LocalInstance li = (LocalInstance)iter.next();
            MinMaxInitCount initCount = (MinMaxInitCount)dfOut.initStatus.get(li);
            if (initCount == null) {
                this.currCBI.outerLocalsUsed.add(li);
                continue;
            }
            if (!InitCount.ZERO.equals(initCount.getMin())) continue;
            throw new SemanticException("Local variable \"" + li.name() + "\" must be initialized before the class " + "declaration.", cb.position());
        }
    }

    static class DataFlowItem
    extends DataFlow.Item {
        Map initStatus;

        DataFlowItem(Map m) {
            this.initStatus = Collections.unmodifiableMap(m);
        }

        public String toString() {
            return this.initStatus.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return ((Object)this.initStatus).equals(((DataFlowItem)o).initStatus);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.initStatus).hashCode();
        }
    }

    protected static class MinMaxInitCount {
        protected InitCount min;
        protected InitCount max;

        MinMaxInitCount(InitCount min, InitCount max) {
            this.min = min;
            this.max = max;
        }

        InitCount getMin() {
            return this.min;
        }

        InitCount getMax() {
            return this.max;
        }

        public String toString() {
            return "[ min: " + this.min + "; max: " + this.max + " ]";
        }

        public boolean equals(Object o) {
            if (o instanceof MinMaxInitCount) {
                return this.min.equals(((MinMaxInitCount)o).min) && this.max.equals(((MinMaxInitCount)o).max);
            }
            return false;
        }

        static MinMaxInitCount join(MinMaxInitCount initCount1, MinMaxInitCount initCount2) {
            if (initCount1 == null) {
                return initCount2;
            }
            if (initCount2 == null) {
                return initCount1;
            }
            MinMaxInitCount t = new MinMaxInitCount(InitCount.min(initCount1.getMin(), initCount2.getMin()), InitCount.max(initCount1.getMax(), initCount2.getMax()));
            return t;
        }
    }

    protected static class InitCount {
        static InitCount ZERO = new InitCount(0);
        static InitCount ONE = new InitCount(1);
        static InitCount MANY = new InitCount(2);
        protected int count;

        protected InitCount(int i) {
            this.count = i;
        }

        public boolean equals(Object o) {
            if (o instanceof InitCount) {
                return this.count == ((InitCount)o).count;
            }
            return false;
        }

        public String toString() {
            if (this.count == 0) {
                return "0";
            }
            if (this.count == 1) {
                return "1";
            }
            if (this.count == 2) {
                return "many";
            }
            throw new RuntimeException("Unexpected value for count");
        }

        public InitCount increment() {
            if (this.count == 0) {
                return ONE;
            }
            return MANY;
        }

        public static InitCount min(InitCount a, InitCount b) {
            if (ZERO.equals(a) || ZERO.equals(b)) {
                return ZERO;
            }
            if (ONE.equals(a) || ONE.equals(b)) {
                return ONE;
            }
            return MANY;
        }

        public static InitCount max(InitCount a, InitCount b) {
            if (MANY.equals(a) || MANY.equals(b)) {
                return MANY;
            }
            if (ONE.equals(a) || ONE.equals(b)) {
                return ONE;
            }
            return ZERO;
        }
    }

    protected static class ClassBodyInfo {
        ClassBodyInfo outer = null;
        CodeDecl currCodeDecl = null;
        Map currClassFinalFieldInitCounts = new HashMap();
        List allConstructors = new ArrayList();
        Map constructorCalls = new HashMap();
        Map fieldsConstructorInitializes = new HashMap();
        Set outerLocalsUsed = new HashSet();
        Map localsUsedInClassBodies = new HashMap();

        protected ClassBodyInfo() {
        }
    }
}

