/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import polyglot.ast.Node;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.visit.HaltingVisitor;
import polyglot.visit.NodeVisitor;

public class ExceptionChecker
extends HaltingVisitor {
    protected TypeSystem ts;
    protected ErrorQueue eq;
    protected ExceptionChecker outer;
    protected SubtypeSet scope;
    protected Map exceptionPositions;

    public ExceptionChecker(TypeSystem ts, ErrorQueue eq) {
        this.ts = ts;
        this.eq = eq;
        this.scope = new SubtypeSet(ts);
        this.exceptionPositions = new HashMap();
    }

    public ExceptionChecker push() {
        ExceptionChecker ec = (ExceptionChecker)this.copy();
        ec.outer = this;
        ec.scope = new SubtypeSet(this.ts);
        ec.exceptionPositions = new HashMap();
        return ec;
    }

    public ExceptionChecker pop() {
        return this.outer;
    }

    public NodeVisitor begin() {
        return this;
    }

    public void finish() {
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    public NodeVisitor enter(Node n) {
        try {
            return n.exceptionCheckEnter(this.push());
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.eq.enqueue(5, e.getMessage(), position);
            return this.push();
        }
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        ExceptionChecker inner = (ExceptionChecker)v;
        SubtypeSet t = inner.throwsSet();
        this.throwsSet().addAll((Collection)t);
        this.exceptionPositions.putAll(inner.exceptionPositions);
        if (inner.outer != this) {
            throw new InternalCompilerError("oops!");
        }
        try {
            return n.del().exceptionCheck(this);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.eq.enqueue(5, e.getMessage(), position);
            return n;
        }
    }

    public void throwsException(Type t, Position pos) {
        this.throwsSet().add(t);
        this.exceptionPositions.put(t, pos);
    }

    public SubtypeSet throwsSet() {
        return this.scope;
    }

    public Position exceptionPosition(Type t) {
        return (Position)this.exceptionPositions.get(t);
    }

    public ErrorQueue errorQueue() {
        return this.eq;
    }
}

