/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceFile;
import polyglot.ast.Stmt;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;
import polyglot.visit.HaltingVisitor;
import polyglot.visit.NodeVisitor;

public class ErrorHandlingVisitor
extends HaltingVisitor {
    protected boolean error;
    protected Job job;
    protected TypeSystem ts;
    protected NodeFactory nf;

    public ErrorHandlingVisitor(Job job, TypeSystem ts, NodeFactory nf) {
        this.job = job;
        this.ts = ts;
        this.nf = nf;
    }

    public Job job() {
        return this.job;
    }

    public NodeVisitor begin() {
        this.error = false;
        return super.begin();
    }

    public ErrorQueue errorQueue() {
        return this.job.compiler().errorQueue();
    }

    public NodeFactory nodeFactory() {
        return this.nf;
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    protected NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        if (Report.should_report(Report.visit, 3)) {
            Report.report(3, "enter: " + parent + " -> " + n);
        }
        return this.enterCall(n);
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        return this;
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        return this.leaveCall(n);
    }

    protected Node leaveCall(Node n) throws SemanticException {
        return n;
    }

    protected boolean catchErrors(Node n) {
        return n instanceof Stmt || n instanceof ClassMember || n instanceof ClassDecl || n instanceof SourceFile;
    }

    public NodeVisitor enter(Node parent, Node n) {
        if (Report.should_report(Report.visit, 5)) {
            Report.report(5, "enter(" + n + ")");
        }
        ErrorHandlingVisitor v = this;
        try {
            v = (ErrorHandlingVisitor)v.enterCall(parent, n);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.errorQueue().enqueue(5, e.getMessage(), position);
            v.error = true;
        }
        return v;
    }

    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        try {
            if (v instanceof ErrorHandlingVisitor && ((ErrorHandlingVisitor)v).error) {
                if (Report.should_report(Report.visit, 5)) {
                    Report.report(5, "leave(" + n + "): error below");
                }
                if (!this.catchErrors(n)) {
                    this.error = true;
                    if (Report.should_report(Report.visit, 5)) {
                        Report.report(5, "leave(" + n + "): error propagated");
                    }
                } else if (Report.should_report(Report.visit, 5)) {
                    Report.report(5, "leave(" + n + "): error not propagated");
                }
                return n;
            }
            if (Report.should_report(Report.visit, 5)) {
                Report.report(5, "leave(" + n + "): calling leaveCall");
            }
            return this.leaveCall(old, n, v);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.errorQueue().enqueue(5, e.getMessage(), position);
            if (!this.catchErrors(n)) {
                this.error = true;
            }
            return n;
        }
    }
}

