/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.StringTokenizer;
import polyglot.util.ErrorInfo;
import polyglot.util.ErrorLimitError;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;

public class StdErrorQueue
implements ErrorQueue {
    private PrintStream err;
    private int errorCount;
    private boolean flushed;
    private int limit;
    private String name;

    public StdErrorQueue(PrintStream err, int limit, String name) {
        this.err = err;
        this.errorCount = 0;
        this.flushed = true;
        this.limit = limit;
        this.name = name;
    }

    public void enqueue(int type, String message) {
        this.enqueue(type, message, null);
    }

    public void enqueue(int type, String message, Position position) {
        this.enqueue(new ErrorInfo(type, message, position));
    }

    public void enqueue(ErrorInfo e) {
        if (e.getErrorKind() != 0) {
            ++this.errorCount;
        }
        this.flushed = false;
        String message = e.getErrorKind() != 0 ? e.getMessage() : e.getErrorString() + " -- " + e.getMessage();
        Position position = e.getPosition();
        String prefix = position != null ? position.nameAndLineString() : this.name;
        int width = 0;
        this.err.print(prefix + ":");
        width += prefix.length() + 1;
        int lmargin = 4;
        int rmargin = 78;
        StringTokenizer st = new StringTokenizer(message, " ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.charAt(0) == '\n') {
                lmargin = 0;
                width = 0;
            }
            if (width + s.length() + 1 > rmargin) {
                this.err.println();
                for (int i = 0; i < lmargin; ++i) {
                    this.err.print(" ");
                }
                width = lmargin;
            } else {
                this.err.print(" ");
                ++width;
            }
            this.err.print(s);
            width += s.length();
        }
        this.err.println();
        if (position != null) {
            this.showError(position);
        }
        if (this.errorCount >= this.limit) {
            prefix = position != null ? position.file() + ": " : "";
            this.err.println(prefix + "Too many errors.  Aborting compilation.");
            this.flush();
            throw new ErrorLimitError();
        }
    }

    protected Reader reader(Position pos) throws IOException {
        if (pos.file() != null && pos.line() != -1) {
            return new FileReader(pos.file());
        }
        return null;
    }

    private void showError(Position pos) {
        try {
            int i;
            Reader r = this.reader(pos);
            if (r == null) {
                return;
            }
            LineNumberReader reader = new LineNumberReader(r);
            String s = null;
            for (i = 0; i < pos.line(); ++i) {
                s = reader.readLine();
            }
            reader.close();
            if (s != null) {
                this.err.println(s);
                if (pos.column() != -1) {
                    for (i = 0; i < pos.column(); ++i) {
                        if (s.charAt(i) == '\t') {
                            this.err.print("\t");
                            continue;
                        }
                        this.err.print(" ");
                    }
                    this.err.println("^");
                }
                this.err.println();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        if (!this.flushed) {
            if (this.errorCount > 0) {
                this.err.println(this.errorCount + " error" + (this.errorCount > 1 ? "s." : "."));
            }
            this.flushed = true;
        }
    }

    public boolean hasErrors() {
        return this.errorCount > 0;
    }

    public int errorCount() {
        return this.errorCount;
    }
}

