/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.Writer;
import polyglot.util.CodeWriter;
import polyglot.util.Overrun;

abstract class Item {
    Item next = null;
    int min_width = -1;
    int min_indent = -1;
    int min_pos_width = -1;
    boolean contains_brks;
    boolean cb_init = false;

    protected Item() {
    }

    abstract int formatN(int var1, int var2, int var3, int var4, boolean var5, boolean var6) throws Overrun;

    abstract int sendOutput(Writer var1, int var2, int var3) throws IOException;

    void free() {
        if (this.next != null) {
            this.next.free();
            this.next = null;
        }
    }

    static int format(Item it, int lmargin, int pos, int rmargin, int fin, boolean can_break, boolean nofail) throws Overrun {
        if (!nofail && pos > rmargin) {
            if (CodeWriter.precompute) {
                int amount2;
                int amount = pos + Item.getMinPosWidth(it) - rmargin;
                int amount1 = lmargin + Item.getMinWidth(it) - rmargin;
                if (amount1 > amount) {
                    amount = amount1;
                }
                if ((amount2 = lmargin + Item.getMinIndent(it) - fin) > amount) {
                    amount = amount2;
                }
                throw Overrun.overrun(amount);
            }
            throw Overrun.overrun(pos - rmargin);
        }
        if (it == null) {
            if (!nofail && pos > fin) {
                throw Overrun.overrun(pos - fin);
            }
            return pos;
        }
        return it.formatN(lmargin, pos, rmargin, fin, can_break, nofail);
    }

    static int max(int i, int j) {
        if (i > j) {
            return i;
        }
        return j;
    }

    static int getMinWidth(Item it) {
        if (it == null) {
            return 0;
        }
        if (it.min_width >= 0) {
            return it.min_width;
        }
        int p1 = it.selfMinWidth();
        int p2 = it.selfMinIndent();
        int p3 = Item.getMinPosWidth(it.next) + p2;
        int p4 = Item.getMinWidth(it.next);
        it.min_width = Item.max(Item.max(p1, p3), p4);
        return it.min_width;
    }

    static int getMinPosWidth(Item it) {
        if (it == null) {
            return 0;
        }
        if (it.min_pos_width >= 0) {
            return it.min_pos_width;
        }
        int p1 = it.selfMinPosWidth();
        if (it.next == null || it.selfContainsBreaks()) {
            return p1;
        }
        return p1 + Item.getMinPosWidth(it.next);
    }

    static int getMinIndent(Item it) {
        if (it == null) {
            return 0;
        }
        if (it.min_indent >= 0) {
            return it.min_indent;
        }
        int p1 = it.selfMinIndent();
        if (it.next == null) {
            return p1;
        }
        if (Item.containsBreaks(it.next)) {
            return Item.getMinIndent(it.next);
        }
        return p1 + Item.getMinPosWidth(it.next);
    }

    static boolean containsBreaks(Item it) {
        if (it == null) {
            return false;
        }
        if (it.cb_init) {
            return it.contains_brks;
        }
        if (it.selfContainsBreaks()) {
            it.contains_brks = true;
            it.cb_init = true;
            return true;
        }
        if (it.next == null) {
            return false;
        }
        it.contains_brks = Item.containsBreaks(it.next);
        it.cb_init = true;
        return it.contains_brks;
    }

    public String summarize(String s) {
        if (s.length() <= 60) {
            return s;
        }
        return s.substring(0, 57) + "...";
    }

    public String toString() {
        if (this.next == null) {
            return this.summarize(this.selfToString());
        }
        return this.summarize(this.selfToString() + this.next.toString());
    }

    abstract String selfToString();

    abstract int selfMinIndent();

    abstract int selfMinWidth();

    abstract int selfMinPosWidth();

    abstract boolean selfContainsBreaks();
}

