/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.Writer;
import polyglot.util.AllowBreak;
import polyglot.util.Item;
import polyglot.util.Overrun;
import polyglot.util.StringItem;

class BlockItem
extends Item {
    BlockItem parent;
    Item first;
    Item last;
    int indent;
    boolean self_contains_brks;
    boolean self_contains_brks_init = false;

    BlockItem(BlockItem parent_, int indent_) {
        this.parent = parent_;
        this.last = null;
        this.first = null;
        this.indent = indent_;
    }

    void add(Item it) {
        if (this.first == null) {
            this.first = it;
        } else {
            if (it instanceof StringItem && this.last instanceof StringItem) {
                StringItem lasts = (StringItem)this.last;
                lasts.appendString(((StringItem)it).s);
                return;
            }
            this.last.next = it;
        }
        this.last = it;
    }

    int formatN(int lmargin, int pos, int rmargin, int fin, boolean can_break, boolean nofail) throws Overrun {
        int this_fin = rmargin - BlockItem.getMinPosWidth(this.next);
        boolean this_nofail = false;
        boolean this_break = false;
        while (true) {
            int next_pos;
            try {
                next_pos = BlockItem.format(this.first, pos + this.indent, pos, rmargin, this_fin, this_break, this_nofail && this_break);
            }
            catch (Overrun o) {
                if (!can_break) {
                    throw o;
                }
                if (!this_break) {
                    this_break = true;
                    continue;
                }
                if (this_nofail) {
                    throw new Error("Failed with this_nofail");
                }
                if (nofail) {
                    this_nofail = true;
                    continue;
                }
                throw o;
            }
            try {
                return BlockItem.format(this.next, lmargin, next_pos, rmargin, fin, can_break, nofail);
            }
            catch (Overrun o) {
                if (!can_break) {
                    throw o;
                }
                if (this.next instanceof AllowBreak) {
                    throw o;
                }
                this_break = true;
                if (nofail) {
                    throw new Error("Failed with nofail");
                }
                if (next_pos > this_fin) {
                    next_pos = this_fin;
                }
                this_fin = next_pos - o.amount;
                continue;
            }
            break;
        }
    }

    int sendOutput(Writer o, int lmargin, int pos) throws IOException {
        Item it = this.first;
        lmargin = pos + this.indent;
        while (it != null) {
            pos = it.sendOutput(o, lmargin, pos);
            it = it.next;
        }
        return pos;
    }

    void free() {
        super.free();
        this.parent = null;
        if (this.first != null) {
            this.first.free();
        }
        this.last = null;
    }

    int selfMinWidth() {
        return BlockItem.getMinWidth(this.first);
    }

    int selfMinPosWidth() {
        return BlockItem.getMinPosWidth(this.first);
    }

    int selfMinIndent() {
        return BlockItem.getMinIndent(this.first);
    }

    boolean selfContainsBreaks() {
        if (this.self_contains_brks_init) {
            return this.self_contains_brks;
        }
        this.self_contains_brks = BlockItem.containsBreaks(this.first);
        return this.self_contains_brks;
    }

    String selfToString() {
        if (this.indent == 0) {
            return "[" + this.first + "]";
        }
        return "[" + this.indent + this.first + "]";
    }
}

