/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import polyglot.main.Report;
import polyglot.types.ClassResolver;
import polyglot.types.ClassType;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public class ClassContextResolver
extends ClassResolver {
    TypeSystem ts;
    ClassType type;
    private static final Collection TOPICS = CollectionUtil.list(Report.types, Report.resolver);

    public ClassContextResolver(TypeSystem ts, ClassType type) {
        this.ts = ts;
        this.type = type;
    }

    public String toString() {
        return "(class-context " + this.type + ")";
    }

    public Named find(String name) throws SemanticException {
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Looking for " + name + " in " + this);
        }
        if (!StringUtil.isNameShort(name)) {
            throw new InternalCompilerError("Cannot lookup qualified name " + name);
        }
        ClassType inner = this.ts.findMemberClass(this.type, name);
        if (inner != null) {
            if (Report.should_report(TOPICS, 2)) {
                Report.report(2, "Found member class " + inner);
            }
            return inner;
        }
        throw new NoClassException(name, this.type);
    }

    public ClassType classType() {
        return this.type;
    }
}

