/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.SemanticException;
import polyglot.util.Position;

public class BadSerializationException
extends SemanticException {
    private String className;

    private static String message(String className) {
        return "The deserialization of the Polyglot type information for \"" + className + "\" failed. The most likely cause of this " + "failure is that the compiler (or compiler extension) has " + "been modified since the class file was created, resulting " + "in incompatible serializations. The solution is to delete " + "the class file for the class \"" + className + "\", and recompile it from the source.";
    }

    public BadSerializationException(String className) {
        super(BadSerializationException.message(className));
        this.className = className;
    }

    public BadSerializationException(String className, Position position) {
        super(BadSerializationException.message(className), position);
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }
}

