/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Node;
import polyglot.frontend.BarrierPass;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.JobExt;
import polyglot.frontend.Pass;
import polyglot.frontend.Source;
import polyglot.frontend.SourceJob;
import polyglot.types.Context;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;

public abstract class Job {
    protected JobExt ext;
    protected ExtensionInfo lang;
    protected Node ast;
    protected ArrayList passes;
    protected int nextPass;
    protected boolean isRunning;
    protected boolean status;
    protected Map passMap;

    public Job(ExtensionInfo lang, JobExt ext, Node ast) {
        this.lang = lang;
        this.ext = ext;
        this.ast = ast;
        this.passes = null;
        this.passMap = null;
        this.nextPass = 0;
        this.isRunning = false;
        this.status = true;
    }

    public JobExt ext() {
        return this.ext;
    }

    public BarrierPass lastBarrier() {
        for (int i = this.nextPass - 1; i >= 0; --i) {
            Pass pass = (Pass)this.passes.get(i);
            if (!(pass instanceof BarrierPass)) continue;
            return (BarrierPass)pass;
        }
        return null;
    }

    public void setIsRunning(boolean flag) {
        this.isRunning = flag;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public Node ast() {
        return this.ast;
    }

    public void ast(Node ast) {
        this.ast = ast;
    }

    public void dump(CodeWriter cw) {
        if (this.ast != null) {
            this.ast.dump(cw);
        }
    }

    public Context context() {
        return null;
    }

    public abstract SourceJob sourceJob();

    public Source source() {
        return this.sourceJob().source();
    }

    protected abstract List getPasses();

    public final List passes() {
        if (this.passes == null) {
            this.init();
        }
        return this.passes;
    }

    private Map passMap() {
        if (this.passMap == null) {
            this.init();
        }
        return this.passMap;
    }

    protected void init() {
        this.passes = new ArrayList(this.getPasses());
        this.passMap = new HashMap();
        for (int i = 0; i < this.passes.size(); ++i) {
            Pass pass = (Pass)this.passes.get(i);
            this.passMap.put(pass.id(), new Integer(i));
        }
    }

    public boolean completed() {
        return this.pendingPasses().isEmpty();
    }

    public List completedPasses() {
        return this.passes().subList(0, this.nextPass);
    }

    public List pendingPasses() {
        return this.passes().subList(this.nextPass, this.passes.size());
    }

    public boolean completed(Pass.ID id) {
        Integer i = (Integer)this.passMap().get(id);
        return i != null && i < this.nextPass;
    }

    public boolean pending(Pass.ID id) {
        Integer i = (Integer)this.passMap().get(id);
        return i != null && i >= this.nextPass;
    }

    public Pass passByID(Pass.ID id) {
        Integer i = (Integer)this.passMap().get(id);
        if (i != null) {
            return (Pass)this.passes().get(i);
        }
        throw new InternalCompilerError("No pass named \"" + id + "\".");
    }

    public Pass getPreviousTo(Pass.ID id) {
        Integer i = (Integer)this.passMap().get(id);
        if (i != null) {
            if (i == 0) {
                return null;
            }
            return (Pass)this.passes().get(i - 1);
        }
        throw new InternalCompilerError("No pass named \"" + id + "\".");
    }

    public Pass nextPass() {
        if (this.nextPass < this.passes().size()) {
            Pass pass = (Pass)this.passes().get(this.nextPass);
            return pass;
        }
        return null;
    }

    public boolean status() {
        return this.status;
    }

    public void finishPass(Pass p, boolean okay) {
        List passes = this.passes();
        this.status &= okay;
        for (int i = this.nextPass; i < passes.size(); ++i) {
            Pass pass = (Pass)passes.get(i);
            if (pass != p) continue;
            this.nextPass = i + 1;
            return;
        }
        throw new InternalCompilerError("Pass " + p + " was not a pending " + "pass.");
    }

    public ExtensionInfo extensionInfo() {
        return this.lang;
    }

    public Compiler compiler() {
        return this.lang.compiler();
    }

    public Node spawn(Context c, Node ast, Pass.ID begin, Pass.ID end) {
        return this.lang.spawnJob(c, ast, this, begin, end);
    }
}

