/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import polyglot.frontend.Source;
import polyglot.util.InternalCompilerError;

public class FileSource
extends Source {
    File file;
    FileReader reader;

    public FileSource(String name) throws IOException {
        super(name);
        this.file = new File(name);
        if (!this.file.exists()) {
            throw new FileNotFoundException(name);
        }
        this.path = this.file.getPath();
        this.lastModified = new Date(this.file.lastModified());
    }

    public FileSource(File file) {
        super(file.getPath());
        this.file = file;
        if (!file.exists()) {
            throw new InternalCompilerError("FileSource given a non-existent file");
        }
        this.path = file.getPath();
        this.lastModified = new Date(file.lastModified());
    }

    public boolean equals(Object o) {
        if (o instanceof FileSource) {
            FileSource s = (FileSource)o;
            return this.file.equals(s.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.getAbsolutePath().hashCode();
    }

    public Reader open() throws IOException {
        if (this.reader == null) {
            this.reader = new FileReader(this.file);
        }
        return this.reader;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public String toString() {
        return this.file.getName();
    }
}

